/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.pdx.SimpleClass;
import com.gemstone.gemfire.pdx.internal.PeerTypeRegistration;
import dunit.AsyncInvocation;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import junit.framework.TestCase;

public class PdxSerializableDUnitTest
extends CacheTestCase {
    public PdxSerializableDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testSimplePut() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.REPLICATE);
                PdxSerializableDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                return null;
            }
        };
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm3.invoke(createRegion);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxSerializableDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)new SimpleClass(57, 3));
                TestCase.assertNotNull((Object)PdxSerializableDUnitTest.this.getRootRegion(PeerTypeRegistration.REGION_NAME));
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TestCase.assertNotNull((Object)PdxSerializableDUnitTest.this.getRootRegion(PeerTypeRegistration.REGION_NAME));
                Region r = PdxSerializableDUnitTest.this.getRootRegion("testSimplePdx");
                TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)r.get((Object)1));
                return null;
            }
        });
        vm3.invoke(new SerializableCallable("check for PDX"){

            public Object call() throws Exception {
                TestCase.assertNotNull((Object)PdxSerializableDUnitTest.this.getRootRegion(PeerTypeRegistration.REGION_NAME));
                return null;
            }
        });
    }

    public void testPersistenceDefaultDiskStore() throws Throwable {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory();
                cf.setPdxPersistent(true);
                PdxSerializableDUnitTest.this.getCache(cf);
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                PdxSerializableDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                return null;
            }
        };
        this.persistenceTest(createRegion);
    }

    public void testPersistenceExplicitDiskStore() throws Throwable {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory();
                cf.setPdxPersistent(true);
                cf.setPdxDiskStore("store1");
                Cache cache = PdxSerializableDUnitTest.this.getCache(cf);
                cache.createDiskStoreFactory().setMaxOplogSize(1L).setDiskDirs(CacheTestCase.getDiskDirs()).create("store1");
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                af.setDiskStoreName("store1");
                PdxSerializableDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                return null;
            }
        };
        this.persistenceTest(createRegion);
    }

    private void persistenceTest(SerializableCallable createRegion) throws Throwable {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxSerializableDUnitTest.this.getRootRegion("testSimplePdx");
                r.put((Object)1, (Object)new SimpleClass(57, 3));
                TestCase.assertNotNull((Object)PdxSerializableDUnitTest.this.getRootRegion(PeerTypeRegistration.REGION_NAME));
                return null;
            }
        });
        SerializableCallable checkForObject = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PdxSerializableDUnitTest.this.getRootRegion("testSimplePdx");
                TestCase.assertEquals((Object)new SimpleClass(57, 3), (Object)r.get((Object)1));
                TestCase.assertNotNull((Object)PdxSerializableDUnitTest.this.getRootRegion(PeerTypeRegistration.REGION_NAME));
                return null;
            }
        };
        vm2.invoke(checkForObject);
        SerializableCallable closeCache = new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.closeCache();
                return null;
            }
        };
        vm1.invoke(closeCache);
        vm2.invoke(closeCache);
        AsyncInvocation future1 = vm1.invokeAsync(createRegion);
        AsyncInvocation future2 = vm2.invokeAsync(createRegion);
        future1.getResult();
        future2.getResult();
        vm1.invoke(checkForObject);
        vm2.invoke(checkForObject);
        vm3.invoke(createRegion);
        vm3.invoke(checkForObject);
    }
}

