/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.examples.snapshot.MyObjectPdx;
import com.examples.snapshot.MyPdxSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import java.util.Collection;

public class PdxTypeExportDUnitTest
extends CacheTestCase {
    public PdxTypeExportDUnitTest(String name) {
        super(name);
    }

    public void testNothing() {
    }

    public void xtestPeer() throws Exception {
        Region r = this.getCache().getRegion("pdxtest");
        r.get((Object)1);
        TypeRegistry tr = ((GemFireCacheImpl)this.getCache()).getPdxRegistry();
        Collection types = tr.typeMap().values();
        PdxTypeExportDUnitTest.assertEquals((String)MyObjectPdx.class.getName(), (String)((PdxType)types.iterator().next()).getClassName());
        Collection enums = tr.enumMap().values();
        PdxTypeExportDUnitTest.assertEquals((String)MyObjectPdx.MyEnumPdx.const1.name(), (String)((EnumInfo)enums.iterator().next()).getEnum().name());
    }

    public void xtestClient() throws Exception {
        SerializableCallable test = new SerializableCallable(){

            public Object call() throws Exception {
                PdxTypeExportDUnitTest.this.xtestPeer();
                return null;
            }
        };
        Host.getHost(0).getVM(3).invoke(test);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loadCache();
    }

    public void loadCache() throws Exception {
        SerializableCallable peer = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer());
                Cache cache = PdxTypeExportDUnitTest.this.getCache(cf);
                Region r = cache.createRegionFactory(RegionShortcut.REPLICATE).create("pdxtest");
                r.put((Object)1, (Object)new MyObjectPdx(1L, "test", MyObjectPdx.MyEnumPdx.const1));
                return null;
            }
        };
        final Host host = Host.getHost(0);
        host.getVM(1).invoke(peer);
        SerializableCallable server = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer());
                CacheServer server = PdxTypeExportDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                Region r = PdxTypeExportDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create("pdxtest");
                return port;
            }
        };
        final int port = (Integer)host.getVM(2).invoke(server);
        SerializableCallable client = new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer()).addPoolServer(DistributedTestCase.getServerHostName(host), port);
                ClientCache cache = PdxTypeExportDUnitTest.this.getClientCache(cf);
                Region r = cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create("pdxtest");
                return null;
            }
        };
        host.getVM(3).invoke(client);
        peer.call();
    }
}

