/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import dunit.DistributedTestCase;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;

public class VersionClassLoader {
    public static ClassLoader initClassLoader(long classVersion) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        cl = ClassLoader.getSystemClassLoader();
        String alternateVersionClassPath = System.getProperty("JTESTS") + File.separator + ".." + File.separator + ".." + File.separator + "testsVersions" + File.separator + "version" + classVersion + File.separator + "classes/";
        DistributedTestCase.getLogWriter().info("Initializing the class loader :" + alternateVersionClassPath);
        URLClassLoader versionCL = null;
        try {
            versionCL = new URLClassLoader(new URL[]{new File(alternateVersionClassPath).toURI().toURL()}, cl);
            Thread.currentThread().setContextClassLoader(versionCL);
        }
        catch (Exception e) {
            DistributedTestCase.getLogWriter().info("error", (Throwable)e);
            throw new Exception("Failed to initialize the class loader. " + e.getMessage());
        }
        DistributedTestCase.getLogWriter().info("Setting/adding class loader with " + alternateVersionClassPath);
        return versionCL;
    }

    public static Object getVersionedInstance(String className, Object[] args) throws Exception {
        Object newObj = null;
        try {
            Class<?> aClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            if (args != null && args.length > 0) {
                if (className.endsWith("PdxTestObject")) {
                    Constructor<?> constructor = aClass.getConstructor(Integer.TYPE, String.class);
                    newObj = constructor.newInstance((int)((Integer)args[0]), args[1]);
                } else if (className.endsWith("PortfolioPdxVersion1")) {
                    Constructor<?> constructor = aClass.getConstructor(Integer.TYPE, Integer.TYPE);
                    newObj = constructor.newInstance((int)((Integer)args[0]), (Integer)args[1]);
                } else if (className.endsWith("PdxVersionedNewPortfolio")) {
                    Constructor<?> constructor = aClass.getConstructor(String.class, Integer.TYPE);
                    newObj = constructor.newInstance((String)args[0], (Integer)args[1]);
                } else if (className.endsWith("PdxVersionedFieldType")) {
                    Constructor<?> constructor = aClass.getConstructor(Integer.TYPE);
                    newObj = constructor.newInstance((int)((Integer)args[0]));
                }
            } else {
                Constructor<?> constructor = aClass.getConstructor(new Class[0]);
                newObj = constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            DistributedTestCase.getLogWriter().info("error", (Throwable)e);
            throw new Exception("Failed to get the class instance. ClassName: " + className + "  error: ", e);
        }
        return newObj;
    }
}

