/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.GemFireSecurityException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.IOException;
import java.util.Properties;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import security.CredentialGenerator;

public class ClientAuthenticationDUnitTest
extends DistributedTestCase {
    private VM server1 = null;
    private VM server2 = null;
    private VM client1 = null;
    private VM client2 = null;
    private static final String[] serverExpectedExceptions = new String[]{AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), GemFireSecurityException.class.getName(), ClassNotFoundException.class.getName(), IOException.class.getName(), SSLException.class.getName(), SSLHandshakeException.class.getName()};
    private static final String[] clientExpectedExceptions = new String[]{AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), SSLHandshakeException.class.getName()};

    public ClientAuthenticationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        this.server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        this.server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        this.client1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        this.client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
    }

    public static Integer createCacheServer(Object dsPort, Object locatorString, Object authenticator, Object extraProps, Object javaProps) {
        Properties authProps = extraProps == null ? new Properties() : (Properties)extraProps;
        if (authenticator != null) {
            authProps.setProperty("security-client-authenticator", authenticator.toString());
        }
        return SecurityTestUtil.createCacheServer(authProps, javaProps, (Integer)dsPort, (String)locatorString, null, new Integer(0));
    }

    public static void createCacheServer(Object dsPort, Object locatorString, Integer serverPort, Object authenticator, Object extraProps, Object javaProps) {
        Properties authProps = extraProps == null ? new Properties() : (Properties)extraProps;
        if (authenticator != null) {
            authProps.setProperty("security-client-authenticator", authenticator.toString());
        }
        SecurityTestUtil.createCacheServer(authProps, javaProps, (Integer)dsPort, (String)locatorString, serverPort, new Integer(0));
    }

    private static void createCacheClient(Object authInit, Properties authProps, Properties javaProps, Integer[] ports, Object numConnections, Boolean multiUserMode, Boolean subscriptionEnabled, Integer expectedResult) {
        String authInitStr = authInit == null ? null : authInit.toString();
        SecurityTestUtil.createCacheClient(authInitStr, authProps, javaProps, ports, (Integer)numConnections, Boolean.FALSE, multiUserMode.toString(), subscriptionEnabled, expectedResult);
    }

    public static void createCacheClient(Object authInit, Object authProps, Object javaProps, Integer[] ports, Object numConnections, Boolean multiUserMode, Integer expectedResult) {
        ClientAuthenticationDUnitTest.createCacheClient(authInit, (Properties)authProps, (Properties)javaProps, ports, numConnections, multiUserMode, Boolean.TRUE, expectedResult);
    }

    public static void createCacheClient(Object authInit, Object authProps, Object javaProps, Integer port1, Object numConnections, Integer expectedResult) {
        ClientAuthenticationDUnitTest.createCacheClient(authInit, (Properties)authProps, (Properties)javaProps, new Integer[]{port1}, numConnections, Boolean.FALSE, Boolean.TRUE, expectedResult);
    }

    public static void createCacheClient(Object authInit, Object authProps, Object javaProps, Integer port1, Integer port2, Object numConnections, Integer expectedResult) {
        ClientAuthenticationDUnitTest.createCacheClient(authInit, authProps, javaProps, port1, port2, numConnections, Boolean.FALSE, expectedResult);
    }

    public static void createCacheClient(Object authInit, Object authProps, Object javaProps, Integer port1, Integer port2, Object numConnections, Boolean multiUserMode, Integer expectedResult) {
        ClientAuthenticationDUnitTest.createCacheClient(authInit, authProps, javaProps, port1, port2, numConnections, multiUserMode, Boolean.TRUE, expectedResult);
    }

    public static void createCacheClient(Object authInit, Object authProps, Object javaProps, Integer port1, Integer port2, Object numConnections, Boolean multiUserMode, Boolean subscriptionEnabled, Integer expectedResult) {
        ClientAuthenticationDUnitTest.createCacheClient(authInit, (Properties)authProps, (Properties)javaProps, new Integer[]{port1, port2}, numConnections, multiUserMode, subscriptionEnabled, expectedResult);
    }

    public static void registerAllInterest() {
        Region region = SecurityTestUtil.getCache().getRegion("AuthRegion");
        ClientAuthenticationDUnitTest.assertNotNull((Object)region);
        region.registerInterestRegex(".*");
    }

    public void testValidCredentials() {
        this.itestValidCredentials(Boolean.FALSE);
    }

    public void itestValidCredentials(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            ClientAuthenticationDUnitTest.getLogWriter().info("testValidCredentials: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testValidCredentials: Using authenticator: " + authenticator);
            ClientAuthenticationDUnitTest.getLogWriter().info("testValidCredentials: Using authinit: " + authInit);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            Integer locPort2 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
            Integer port2 = (Integer)this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, authenticator, extraProps, javaProps});
            Properties credentials1 = gen.getValidCredentials(1);
            Properties javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testValidCredentials: For first client credentials: " + credentials1 + " : " + javaProps1);
            Properties credentials2 = gen.getValidCredentials(2);
            Properties javaProps2 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testValidCredentials: For second client credentials: " + credentials2 + " : " + javaProps2);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, null, multiUser, new Integer(0)});
            this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2)});
            this.client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(2)});
            if (!multiUser.booleanValue()) continue;
            this.client1.invoke(SecurityTestUtil.class, "doProxyCacheClose");
            this.client2.invoke(SecurityTestUtil.class, "doProxyCacheClose");
            this.client1.invoke(SecurityTestUtil.class, "doSimplePut", new Object[]{"CacheClosedException"});
            this.client2.invoke(SecurityTestUtil.class, "doSimpleGet", new Object[]{"CacheClosedException"});
        }
    }

    public void testNoCredentials() {
        this.itestNoCredentials(Boolean.FALSE);
    }

    public void itestNoCredentials(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoCredentials: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoCredentials: Using authenticator: " + authenticator);
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoCredentials: Using authinit: " + authInit);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            Integer locPort2 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
            Integer port2 = (Integer)this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, authenticator, extraProps, javaProps});
            Properties credentials1 = gen.getValidCredentials(1);
            Properties javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoCredentials: For first client credentials: " + credentials1 + " : " + javaProps1);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
            this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2)});
            if (gen.classCode().equals(CredentialGenerator.ClassCode.SSL)) {
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, null, null, port1, port2, null, multiUser, new Integer(0)});
                this.client2.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2), new Integer(5)});
                continue;
            }
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, null, null, port1, port2, null, multiUser, new Integer(1)});
        }
    }

    public void testInvalidCredentials() {
        this.itestInvalidCredentials(Boolean.FALSE);
    }

    public void itestInvalidCredentials(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidCredentials: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidCredentials: Using authenticator: " + authenticator);
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidCredentials: Using authinit: " + authInit);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            Integer locPort2 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
            Integer port2 = (Integer)this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, authenticator, extraProps, javaProps});
            Properties credentials1 = gen.getValidCredentials(1);
            Properties javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidCredentials: For first client credentials: " + credentials1 + " : " + javaProps1);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
            this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2)});
            Properties credentials2 = gen.getInvalidCredentials(1);
            Properties javaProps2 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidCredentials: For second client credentials: " + credentials2 + " : " + javaProps2);
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, null, multiUser, new Integer(2)});
        }
    }

    public void testInvalidAuthInit() {
        this.itestInvalidAuthInit(Boolean.FALSE);
    }

    public void itestInvalidAuthInit(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthInit: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthInit: Using authenticator: " + authenticator);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
            Properties credentials = gen.getValidCredentials(1);
            javaProps = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthInit: For first client credentials: " + credentials + " : " + javaProps);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{"com.gemstone.none", credentials, javaProps, new Integer[]{port1}, null, multiUser, 1});
        }
    }

    public void testNoAuthInitWithCredentials() {
        this.itestNoAuthInitWithCredentials(Boolean.FALSE);
    }

    public void itestNoAuthInitWithCredentials(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            if (authInit == null || authInit.length() == 0) {
                ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthInitWithCredentials: Skipping scheme [" + gen.classCode() + "] which has no authInit");
                continue;
            }
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthInitWithCredentials: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthInitWithCredentials: Using authenticator: " + authenticator);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            Integer locPort2 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
            Integer port2 = (Integer)this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, authenticator, extraProps, javaProps});
            Properties credentials1 = gen.getValidCredentials(1);
            Properties javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthInitWithCredentials: For first client credentials: " + credentials1 + " : " + javaProps1);
            Properties credentials2 = gen.getValidCredentials(2);
            Properties javaProps2 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthInitWithCredentials: For second client credentials: " + credentials2 + " : " + javaProps2);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(1)});
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, credentials2, javaProps2, port1, port2, null, multiUser, new Integer(1)});
            this.client2.invoke(SecurityTestUtil.class, "closeCache");
            credentials2 = gen.getInvalidCredentials(5);
            javaProps2 = gen.getJavaProperties();
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, credentials2, javaProps2, port1, port2, null, multiUser, new Integer(1)});
        }
    }

    public void testInvalidAuthenticator() {
        this.itestInvalidAuthenticator(Boolean.FALSE);
    }

    public void itestInvalidAuthenticator(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authInit = gen.getAuthInit();
            if (authInit == null || authInit.length() == 0) {
                ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthenticator: Skipping scheme [" + gen.classCode() + "] which has no authInit");
                continue;
            }
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthenticator: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthenticator: Using authinit: " + authInit);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, "com.gemstone.gemfire.none", extraProps, javaProps});
            Properties credentials = gen.getValidCredentials(1);
            javaProps = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthenticator: For first client credentials: " + credentials + " : " + javaProps);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials, javaProps, port1, null, new Integer(2)});
            this.client1.invoke(SecurityTestUtil.class, "closeCache");
            credentials = gen.getInvalidCredentials(1);
            javaProps = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testInvalidAuthenticator: For first client credentials: " + credentials + " : " + javaProps);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials, javaProps, port1, null, new Integer(2)});
        }
    }

    public void testNoAuthenticatorWithCredentials() {
        this.itestNoAuthenticatorWithCredentials(Boolean.FALSE);
    }

    public void itestNoAuthenticatorWithCredentials(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            if (authenticator == null || authenticator.length() == 0) {
                ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthenticatorWithCredentials: Skipping scheme [" + gen.classCode() + "] which has no authenticator");
                continue;
            }
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthenticatorWithCredentials: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthenticatorWithCredentials: Using authinit: " + authInit);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            Integer locPort2 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, null, extraProps, javaProps});
            Integer port2 = (Integer)this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, null, extraProps, javaProps});
            Properties credentials1 = gen.getValidCredentials(3);
            Properties javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthenticatorWithCredentials: For first client credentials: " + credentials1 + " : " + javaProps1);
            Properties credentials2 = gen.getInvalidCredentials(5);
            Properties javaProps2 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testNoAuthenticatorWithCredentials: For second client credentials: " + credentials2 + " : " + javaProps2);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, null, multiUser, new Integer(0)});
            this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2)});
            this.client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(2)});
        }
    }

    public void testCredentialsWithFailover() {
        this.itestCredentialsWithFailover(Boolean.FALSE);
    }

    public void itestCredentialsWithFailover(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsWithFailover: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsWithFailover: Using authenticator: " + authenticator);
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsWithFailover: Using authinit: " + authInit);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            Integer locPort2 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
            Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            Properties credentials1 = gen.getValidCredentials(5);
            Properties javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsWithFailover: For first client credentials: " + credentials1 + " : " + javaProps1);
            Properties credentials2 = gen.getValidCredentials(6);
            Properties javaProps2 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsWithFailover: For second client credentials: " + credentials2 + " : " + javaProps2);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, null, multiUser, new Integer(0)});
            this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2)});
            this.client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(2)});
            this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, port2, authenticator, extraProps, javaProps});
            this.server1.invoke(SecurityTestUtil.class, "closeCache");
            this.client1.invoke(SecurityTestUtil.class, "doNPuts", new Object[]{new Integer(4)});
            this.client2.invoke(SecurityTestUtil.class, "doNGets", new Object[]{new Integer(4)});
            if (gen.classCode().equals(CredentialGenerator.ClassCode.SSL)) {
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, null, null, port1, port2, null, multiUser, new Integer(16)});
                this.client2.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2), new Integer(5)});
            } else {
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, null, null, port1, port2, null, multiUser, new Integer(1)});
            }
            credentials1 = gen.getInvalidCredentials(7);
            javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsWithFailover: For first client invalid credentials: " + credentials1 + " : " + javaProps1);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(2)});
            if (!multiUser.booleanValue()) continue;
            this.client1.invoke(SecurityTestUtil.class, "doProxyCacheClose");
            this.client2.invoke(SecurityTestUtil.class, "doProxyCacheClose");
            this.client1.invoke(SecurityTestUtil.class, "doSimplePut", new Object[]{"CacheClosedException"});
            this.client2.invoke(SecurityTestUtil.class, "doSimpleGet", new Object[]{"CacheClosedException"});
        }
    }

    public void testCredentialsForNotifications() {
        this.itestCredentialsForNotifications(Boolean.FALSE);
    }

    public void itestCredentialsForNotifications(Boolean multiUser) {
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties extraProps = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: Using scheme: " + gen.classCode());
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: Using authenticator: " + authenticator);
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: Using authinit: " + authInit);
            Integer locPort1 = SecurityTestUtil.getLocatorPort();
            Integer locPort2 = SecurityTestUtil.getLocatorPort();
            String locString = SecurityTestUtil.getLocatorString();
            Integer port1 = (Integer)this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, authenticator, extraProps, javaProps});
            Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            Properties credentials1 = gen.getValidCredentials(3);
            Properties javaProps1 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: For first client credentials: " + credentials1 + " : " + javaProps1);
            Properties credentials2 = gen.getValidCredentials(4);
            Properties javaProps2 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: For second client credentials: " + credentials2 + " : " + javaProps2);
            this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
            Integer zeroConns = new Integer(0);
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, zeroConns, multiUser, new Integer(0)});
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "registerAllInterest");
            this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2)});
            this.client2.invoke(SecurityTestUtil.class, "doLocalGets", new Object[]{new Integer(2)});
            this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, port2, authenticator, extraProps, javaProps});
            this.server1.invoke(SecurityTestUtil.class, "closeCache");
            ClientAuthenticationDUnitTest.pause(500);
            this.client1.invoke(SecurityTestUtil.class, "doNPuts", new Object[]{new Integer(4)});
            this.client2.invoke(SecurityTestUtil.class, "doNLocalGets", new Object[]{new Integer(4)});
            this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, port1, authenticator, extraProps, javaProps});
            if (gen.classCode().equals(CredentialGenerator.ClassCode.SSL)) {
                this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, null, null, port1, port2, zeroConns, multiUser, new Integer(16)});
                this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2), new Integer(5)});
            } else {
                this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, null, null, port1, port2, zeroConns, multiUser, new Integer(1)});
            }
            credentials2 = gen.getInvalidCredentials(3);
            javaProps2 = gen.getJavaProperties();
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: For second client invalid credentials: " + credentials2 + " : " + javaProps2);
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, zeroConns, multiUser, new Integer(2)});
            this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{"com.gemstone.none", credentials1, javaProps1, port1, port2, zeroConns, multiUser, new Integer(1)});
            if (authInit != null && authInit.length() > 0) {
                this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, port1, "com.gemstone.gemfire.none", extraProps, javaProps});
                this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, port2, "com.gemstone.gemfire.none", extraProps, javaProps});
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, zeroConns, multiUser, new Integer(2)});
                this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, zeroConns, multiUser, new Integer(2)});
            } else {
                ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: Skipping invalid authenticator for scheme [" + gen.classCode() + "] which has no authInit");
            }
            if (authInit != null && authInit.length() > 0) {
                this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, port1, authenticator, extraProps, javaProps});
                this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, port2, authenticator, extraProps, javaProps});
                this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(1)});
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, credentials2, javaProps2, port1, port2, zeroConns, multiUser, new Integer(1)});
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{null, credentials2, javaProps2, port1, port2, zeroConns, multiUser, new Integer(1)});
            } else {
                ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: Skipping null authInit for scheme [" + gen.classCode() + "] which has no authInit");
            }
            if (authenticator != null && authenticator.length() > 0) {
                this.server1.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort1, locString, port1, null, extraProps, javaProps});
                this.server2.invoke(ClientAuthenticationDUnitTest.class, "createCacheServer", new Object[]{locPort2, locString, port2, null, extraProps, javaProps});
                this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, null, multiUser, new Integer(0)});
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, zeroConns, multiUser, new Integer(0)});
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "registerAllInterest");
                this.client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(4)});
                this.client2.invoke(SecurityTestUtil.class, "doLocalGets", new Object[]{new Integer(4)});
                this.client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials2, javaProps2, port1, port2, null, multiUser, new Integer(0)});
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, credentials1, javaProps1, port1, port2, zeroConns, multiUser, new Integer(0)});
                this.client2.invoke(ClientAuthenticationDUnitTest.class, "registerAllInterest");
                this.client1.invoke(SecurityTestUtil.class, "doNPuts", new Object[]{new Integer(4)});
                this.client2.invoke(SecurityTestUtil.class, "doNLocalGets", new Object[]{new Integer(4)});
                continue;
            }
            ClientAuthenticationDUnitTest.getLogWriter().info("testCredentialsForNotifications: Skipping scheme [" + gen.classCode() + "] which has no authenticator");
        }
    }

    public void xtestValidCredentialsForMultipleUsers() {
        this.itestValidCredentials(Boolean.TRUE);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.client1.invoke(SecurityTestUtil.class, "closeCache");
        this.client2.invoke(SecurityTestUtil.class, "closeCache");
        this.server1.invoke(SecurityTestUtil.class, "closeCache");
        this.server2.invoke(SecurityTestUtil.class, "closeCache");
    }
}

