/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.ClientAuthenticationDUnitTest;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;
import security.DummyCredentialGenerator;
import security.XmlAuthzCredentialGenerator;

public class ClientAuthorizationDUnitTest
extends ClientAuthorizationTestBase {
    public ClientAuthorizationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
    }

    private Properties getUserPassword(String userName) {
        Properties props = new Properties();
        props.setProperty("security-username", userName);
        props.setProperty("security-password", userName);
        return props;
    }

    private void executeRIOpBlock(List opBlock, Integer port1, Integer port2, String authInit, Properties extraAuthProps, Properties extraAuthzProps, Properties javaProps) {
        for (ClientAuthorizationTestBase.OperationWithAction currentOp : opBlock) {
            OperationContext.OperationCode opCode = currentOp.getOperationCode();
            int opFlags = currentOp.getFlags();
            int clientNum = currentOp.getClientNum();
            VM clientVM = null;
            boolean useThisVM = false;
            switch (clientNum) {
                case 1: {
                    clientVM = client1;
                    break;
                }
                case 2: {
                    clientVM = client2;
                    break;
                }
                case 3: {
                    useThisVM = true;
                    break;
                }
                default: {
                    ClientAuthorizationDUnitTest.fail((String)("executeRIOpBlock: Unknown client number " + clientNum));
                }
            }
            ClientAuthorizationDUnitTest.getLogWriter().info("executeRIOpBlock: performing operation number [" + currentOp.getOpNum() + "]: " + currentOp);
            if ((opFlags & 0x1000) == 0) {
                String credentialsTypeStr;
                Properties opCredentials = null;
                String currentRegionName = "/AuthRegion";
                if ((opFlags & 0x400) > 0) {
                    currentRegionName = currentRegionName + "/AuthSubregion";
                }
                OperationContext.OperationCode authOpCode = currentOp.getAuthzOperationCode();
                if ((opFlags & 2) > 0 || (opFlags & 0x2000) > 0 || !authOpCode.equals(opCode)) {
                    credentialsTypeStr = " unauthorized " + authOpCode;
                    if (authOpCode.isRegisterInterest()) {
                        opCredentials = this.getUserPassword("reader7");
                    } else if (authOpCode.isUnregisterInterest()) {
                        opCredentials = this.getUserPassword("reader6");
                    } else {
                        ClientAuthorizationDUnitTest.fail((String)("executeRIOpBlock: cannot determine credentials for" + credentialsTypeStr));
                    }
                } else {
                    credentialsTypeStr = " authorized " + authOpCode;
                    if (authOpCode.isRegisterInterest() || authOpCode.isUnregisterInterest()) {
                        opCredentials = this.getUserPassword("reader5");
                    } else if (authOpCode.isPut()) {
                        opCredentials = this.getUserPassword("writer1");
                    } else if (authOpCode.isGet()) {
                        opCredentials = this.getUserPassword("reader1");
                    } else {
                        ClientAuthorizationDUnitTest.fail((String)("executeRIOpBlock: cannot determine credentials for" + credentialsTypeStr));
                    }
                }
                Properties clientProps = SecurityTestUtil.concatProperties(new Properties[]{opCredentials, extraAuthProps, extraAuthzProps});
                ClientAuthorizationDUnitTest.getLogWriter().info("executeRIOpBlock: For client" + clientNum + credentialsTypeStr + " credentials: " + opCredentials);
                if (useThisVM) {
                    ClientAuthorizationDUnitTest.createCacheClient(authInit, clientProps, javaProps, new Integer[]{port1, port2}, null, false, new Integer(0));
                } else {
                    clientVM.invoke(ClientAuthorizationTestBase.class, "createCacheClient", new Object[]{authInit, clientProps, javaProps, new Integer[]{port1, port2}, null, false, new Integer(0)});
                }
            }
            int expectedResult = (opFlags & 2) > 0 ? 4 : ((opFlags & 8) > 0 ? 5 : 0);
            if (useThisVM) {
                ClientAuthorizationDUnitTest.doOp(new Byte(opCode.toOrdinal()), currentOp.getIndices(), new Integer(opFlags), new Integer(expectedResult));
                continue;
            }
            clientVM.invoke(ClientAuthorizationTestBase.class, "doOp", new Object[]{new Byte(opCode.toOrdinal()), currentOp.getIndices(), new Integer(opFlags), new Integer(expectedResult)});
        }
    }

    public void testAllowPutsGets() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: Using authinit: " + authInit);
            ClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: Using authenticator: " + authenticator);
            ClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: Using accessor: " + accessor);
            Properties serverProps = ClientAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Integer port1 = (Integer)server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            Integer port2 = (Integer)server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            javaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: For first client credentials: " + createCredentials);
            client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, createCredentials, javaProps, port1, port2, null, new Integer(0)});
            Properties getCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, 2);
            javaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: For second client credentials: " + getCredentials);
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, javaProps, port1, port2, null, new Integer(0)});
            client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(2), new Integer(0)});
        }
    }

    public void testDisallowPutsGets() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientAuthorizationDUnitTest.getLogWriter().info("testDisallowPutsGets: Using authinit: " + authInit);
            ClientAuthorizationDUnitTest.getLogWriter().info("testDisallowPutsGets: Using authenticator: " + authenticator);
            ClientAuthorizationDUnitTest.getLogWriter().info("testDisallowPutsGets: Using accessor: " + accessor);
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            Properties createJavaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testDisallowPutsGets: For first client credentials: " + createCredentials);
            Properties getCredentials = gen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, 2);
            Properties getJavaProps = cGen.getJavaProperties();
            if (getCredentials == null || getCredentials.size() == 0) {
                ClientAuthorizationDUnitTest.getLogWriter().info("testDisallowPutsGets: Unable to obtain valid credentials with no GET permission; skipping this combination.");
                continue;
            }
            ClientAuthorizationDUnitTest.getLogWriter().info("testDisallowPutsGets: For second client disallowed GET credentials: " + getCredentials);
            Properties serverProps = ClientAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Integer port1 = (Integer)server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            Integer port2 = (Integer)server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, createCredentials, createJavaProps, port1, port2, null, new Integer(0)});
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, getJavaProps, port1, port2, null, new Integer(0)});
            client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(2), new Integer(4)});
            getCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, 5);
            getJavaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testDisallowPutsGets: For second client with GET credentials: " + getCredentials);
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, getJavaProps, port1, port2, null, new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(2), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doNPuts", new Object[]{new Integer(2), new Integer(4)});
        }
    }

    public void testInvalidAccessor() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientAuthorizationDUnitTest.getLogWriter().info("testInvalidAccessor: Using authinit: " + authInit);
            ClientAuthorizationDUnitTest.getLogWriter().info("testInvalidAccessor: Using authenticator: " + authenticator);
            Properties serverProps = ClientAuthorizationDUnitTest.buildProperties(authenticator, "com.gemstone.none", false, extraAuthProps, extraAuthzProps);
            Integer port1 = (Integer)server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 3);
            Properties createJavaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testInvalidAccessor: For first client CREATE credentials: " + createCredentials);
            Properties getCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, 7);
            Properties getJavaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testInvalidAccessor: For second client GET credentials: " + getCredentials);
            client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, createCredentials, createJavaProps, port1, port2, null, Boolean.FALSE, Boolean.FALSE, 0});
            client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(1), new Integer(2)});
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, getJavaProps, port1, port2, null, Boolean.FALSE, Boolean.FALSE, 0});
            client2.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(1), new Integer(2)});
            ClientAuthorizationDUnitTest.getLogWriter().info("testInvalidAccessor: Using accessor: " + accessor);
            serverProps = ClientAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
            server1.invoke(SecurityTestUtil.class, "closeCache");
            client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, createCredentials, createJavaProps, port1, port2, null, new Integer(0)});
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, getJavaProps, port1, port2, null, new Integer(0)});
            client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(4), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(4), new Integer(0)});
        }
    }

    public void testPutsGetsWithFailover() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientAuthorizationDUnitTest.getLogWriter().info("testPutsGetsWithFailover: Using authinit: " + authInit);
            ClientAuthorizationDUnitTest.getLogWriter().info("testPutsGetsWithFailover: Using authenticator: " + authenticator);
            ClientAuthorizationDUnitTest.getLogWriter().info("testPutsGetsWithFailover: Using accessor: " + accessor);
            Properties serverProps = ClientAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Integer port1 = (Integer)server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            Properties createJavaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testPutsGetsWithFailover: For first client credentials: " + createCredentials);
            client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, createCredentials, createJavaProps, port1, port2, null, new Integer(0)});
            Properties getCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, 5);
            Properties getJavaProps = cGen.getJavaProperties();
            ClientAuthorizationDUnitTest.getLogWriter().info("testPutsGetsWithFailover: For second client credentials: " + getCredentials);
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, getJavaProps, port1, port2, null, new Integer(0)});
            client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(2), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(2), new Integer(0)});
            server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
            server1.invoke(SecurityTestUtil.class, "closeCache");
            client1.invoke(SecurityTestUtil.class, "doNPuts", new Object[]{new Integer(4), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doNGets", new Object[]{new Integer(4), new Integer(0)});
            Properties noGetCredentials = gen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, 9);
            getJavaProps = cGen.getJavaProperties();
            if (noGetCredentials == null || noGetCredentials.size() == 0) {
                ClientAuthorizationDUnitTest.getLogWriter().info("testPutsGetsWithFailover: Unable to obtain valid credentials with no GET permission; skipping this combination.");
                continue;
            }
            ClientAuthorizationDUnitTest.getLogWriter().info("testPutsGetsWithFailover: For second client disallowed GET credentials: " + noGetCredentials);
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, noGetCredentials, getJavaProps, port1, port2, null, new Integer(0)});
            client1.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(4), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doGets", new Object[]{new Integer(4), new Integer(4)});
            server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
            server2.invoke(SecurityTestUtil.class, "closeCache");
            client1.invoke(SecurityTestUtil.class, "doNPuts", new Object[]{new Integer(4), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doNGets", new Object[]{new Integer(4), new Integer(4)});
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, getJavaProps, port1, port2, null, new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doNGets", new Object[]{new Integer(4), new Integer(0)});
            client2.invoke(SecurityTestUtil.class, "doPuts", new Object[]{new Integer(4), new Integer(4)});
        }
    }

    public void testUnregisterInterestWithFailover() {
        ClientAuthorizationTestBase.OperationWithAction[] unregisterOps = new ClientAuthorizationTestBase.OperationWithAction[]{new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.UNREGISTER_INTEREST, 3, 0, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 2), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.UNREGISTER_INTEREST, 3, 4098, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.UNREGISTER_INTEREST, 2, 4096, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.UNREGISTER_INTEREST, 3, 128, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 1, 128, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 2), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 1, 4352, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.UNREGISTER_INTEREST, 3, 4226, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.UNREGISTER_INTEREST, 1, 4224, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 2, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 1, 4352, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.UNREGISTER_INTEREST, 3, 64, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 2, 64, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.UNREGISTER_INTEREST, 3, 4162, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.UNREGISTER_INTEREST, 2, 4160, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END};
        XmlAuthzCredentialGenerator gen = new XmlAuthzCredentialGenerator();
        DummyCredentialGenerator cGen = new DummyCredentialGenerator();
        cGen.init();
        gen.init(cGen);
        Properties extraAuthProps = cGen.getSystemProperties();
        Properties javaProps = cGen.getJavaProperties();
        Properties extraAuthzProps = gen.getSystemProperties();
        String authenticator = ((CredentialGenerator)cGen).getAuthenticator();
        String authInit = ((CredentialGenerator)cGen).getAuthInit();
        String accessor = ((AuthzCredentialGenerator)gen).getAuthorizationCallback();
        ClientAuthorizationDUnitTest.getLogWriter().info("testAllOpsWithFailover: Using authinit: " + authInit);
        ClientAuthorizationDUnitTest.getLogWriter().info("testAllOpsWithFailover: Using authenticator: " + authenticator);
        ClientAuthorizationDUnitTest.getLogWriter().info("testAllOpsWithFailover: Using accessor: " + accessor);
        Properties serverProps = ClientAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
        Integer port1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        ArrayList<ClientAuthorizationTestBase.OperationWithAction> opBlock = new ArrayList<ClientAuthorizationTestBase.OperationWithAction>();
        for (int opNum = 0; opNum < unregisterOps.length; ++opNum) {
            ClientAuthorizationTestBase.OperationWithAction currentOp = unregisterOps[opNum];
            if (currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END) || currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                if (opBlock.size() <= 0) continue;
                server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
                server2.invoke(SecurityTestUtil.class, "closeCache");
                this.executeRIOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, javaProps);
                if (!currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                    server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
                    server1.invoke(SecurityTestUtil.class, "closeCache");
                    this.executeRIOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, javaProps);
                }
                opBlock.clear();
                continue;
            }
            currentOp.setOpNum(opNum);
            opBlock.add(currentOp);
        }
    }

    public void testAllOpsWithFailover() {
        ClientAuthorizationTestBase.OperationWithAction[] allOps = new ClientAuthorizationTestBase.OperationWithAction[]{new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 2, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 514, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 512, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUTALL, 3, 18, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUTALL, 1, 16, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4112, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 18, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 16, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4112, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.DESTROY, 3, 18, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.DESTROY), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4097, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 16, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CONTAINS_KEY, 3, 2, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CONTAINS_KEY), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.DESTROY, 2), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CONTAINS_KEY, 3, 3, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CONTAINS_KEY, 1, 4097, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.KEY_SET, 3, 2, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.KEY_SET, 2), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY, 3, 2, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 3, 2, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 2), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.UNREGISTER_INTEREST, 2, 4096, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END};
        this.runOpsWithFailover(allOps, "testAllOpsWithFailover");
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(SecurityTestUtil.class, "closeCache");
        client2.invoke(SecurityTestUtil.class, "closeCache");
        SecurityTestUtil.closeCache();
        server1.invoke(SecurityTestUtil.class, "closeCache");
        server2.invoke(SecurityTestUtil.class, "closeCache");
    }
}

