/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.security.ObjectWithAuthz;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import security.CredentialGenerator;
import security.DummyAuthzCredentialGenerator;
import security.LdapUserCredentialGenerator;

public class ClientAuthzObjectModDUnitTest
extends ClientAuthorizationTestBase {
    private static final String preAccessor = "com.gemstone.gemfire.internal.security.FilterPreAuthorization.create";
    private static final String postAccessor = "com.gemstone.gemfire.internal.security.FilterPostAuthorization.create";

    public ClientAuthzObjectModDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
        SerializableRunnable registerInstantiator = new SerializableRunnable(){

            @Override
            public void run() {
                Instantiator.register((Instantiator)new MyInstantiator(), (boolean)false);
            }
        };
        server1.invoke(registerInstantiator);
        server2.invoke(registerInstantiator);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DistributedTestCase.cleanupAllVms();
    }

    private static Properties buildProperties(String authenticator, Properties extraProps, String preAccessor, String postAccessor) {
        Properties authProps = new Properties();
        if (authenticator != null) {
            authProps.setProperty("security-client-authenticator", authenticator);
        }
        if (preAccessor != null) {
            authProps.setProperty("security-client-accessor", preAccessor);
        }
        if (postAccessor != null) {
            authProps.setProperty("security-client-accessor-pp", postAccessor);
        }
        if (extraProps != null) {
            authProps.putAll((Map<?, ?>)extraProps);
        }
        return authProps;
    }

    public static Integer createCacheServer(Integer mcastPort, Properties authProps) {
        if (mcastPort == null) {
            mcastPort = new Integer(AvailablePort.getRandomAvailablePort((int)1));
        }
        return SecurityTestUtil.createCacheServer(authProps, null, mcastPort, null, null, Boolean.FALSE, new Integer(0));
    }

    public static void createCacheServer(Integer mcastPort, Integer serverPort, Properties authProps) {
        if (mcastPort == null) {
            mcastPort = new Integer(AvailablePort.getRandomAvailablePort((int)1));
        }
        SecurityTestUtil.createCacheServer(authProps, null, mcastPort, null, serverPort, Boolean.FALSE, new Integer(0));
    }

    public void testAllOpsObjectModWithFailover() {
        ClientAuthorizationTestBase.OperationWithAction[] allOps = new ClientAuthorizationTestBase.OperationWithAction[]{new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 0, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 512, new int[]{1, 3, 5, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4610, new int[]{0, 2, 4, 6}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 512, new int[]{2, 5}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4610, new int[]{0, 1, 3, 4, 6, 7}), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4112, new int[]{1, 3, 5, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4626, new int[]{0, 2, 4, 6}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4112, new int[]{2, 5}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4626, new int[]{0, 1, 3, 4, 6, 7}), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4144, new int[]{1, 3, 5, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4657, new int[]{0, 2, 4, 6}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4144, new int[]{2, 5}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4657, new int[]{0, 1, 3, 4, 6, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.DESTROY, 1, 4352, 8), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUTALL, 1, 4112, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4112, new int[]{1, 3, 5, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4626, new int[]{0, 2, 4, 6}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4112, new int[]{2, 5}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4626, new int[]{0, 1, 3, 4, 6, 7}), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4096, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY, 2, 4096, new int[]{1, 3, 5, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY, 2, 4097, new int[]{0, 2, 4, 6}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY, 3, 4096, new int[]{2, 5}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY, 3, 4097, new int[]{0, 1, 3, 4, 6, 7}), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.EXECUTE_CQ, 2, 4112, new int[]{1, 3, 5, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CLOSE_CQ, 2, 4096, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.EXECUTE_CQ, 2, 4113, new int[]{0, 2, 4, 6}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CLOSE_CQ, 2, 4096, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.EXECUTE_CQ, 3, 4112, new int[]{2, 5}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CLOSE_CQ, 3, 4096, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.EXECUTE_CQ, 3, 4113, new int[]{0, 1, 3, 4, 6, 7}), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.CLOSE_CQ, 3, 4096, 1), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END};
        TestPostCredentialGenerator tgen = new TestPostCredentialGenerator();
        LdapUserCredentialGenerator gen = new LdapUserCredentialGenerator();
        gen.init();
        Properties extraProps = gen.getSystemProperties();
        Properties javaProps = gen.getJavaProperties();
        String authInit = ((CredentialGenerator)gen).getAuthInit();
        String authenticator = ((CredentialGenerator)gen).getAuthenticator();
        ClientAuthzObjectModDUnitTest.getLogWriter().info("testPutsGetsObjectModWithFailover: Using authinit: " + authInit);
        ClientAuthzObjectModDUnitTest.getLogWriter().info("testPutsGetsObjectModWithFailover: Using authenticator: " + authenticator);
        ClientAuthzObjectModDUnitTest.getLogWriter().info("testPutsGetsObjectModWithFailover: Using pre-operation accessor: com.gemstone.gemfire.internal.security.FilterPreAuthorization.create");
        ClientAuthzObjectModDUnitTest.getLogWriter().info("testPutsGetsObjectModWithFailover: Using post-operation accessor: com.gemstone.gemfire.internal.security.FilterPostAuthorization.create");
        Properties serverProps = ClientAuthzObjectModDUnitTest.buildProperties(authenticator, extraProps, preAccessor, postAccessor);
        Integer port1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        ArrayList<ClientAuthorizationTestBase.OperationWithAction> opBlock = new ArrayList<ClientAuthorizationTestBase.OperationWithAction>();
        Random rnd = new Random();
        for (int opNum = 0; opNum < allOps.length; ++opNum) {
            ClientAuthorizationTestBase.OperationWithAction currentOp = allOps[opNum];
            if (currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END) || currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                if (opBlock.size() <= 0) continue;
                server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
                server2.invoke(SecurityTestUtil.class, "closeCache");
                this.executeOpBlock(opBlock, port1, port2, authInit, extraProps, null, tgen, rnd);
                if (!currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                    server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
                    server1.invoke(SecurityTestUtil.class, "closeCache");
                    this.executeOpBlock(opBlock, port1, port2, authInit, extraProps, null, tgen, rnd);
                }
                opBlock.clear();
                continue;
            }
            currentOp.setOpNum(opNum);
            opBlock.add(currentOp);
        }
    }

    private static class MyInstantiator
    extends Instantiator {
        public MyInstantiator(Class clazz, int classId) {
            super(clazz, classId);
        }

        public MyInstantiator() {
            this(ObjectWithAuthz.class, 57);
        }

        public DataSerializable newInstance() {
            return new ObjectWithAuthz();
        }
    }

    private static class TestPostCredentialGenerator
    implements ClientAuthorizationTestBase.TestCredentialGenerator {
        @Override
        public Properties getAllowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int[] keyIndices, int num) {
            int userIndex = 1;
            byte role = DummyAuthzCredentialGenerator.getRequiredRole(opCodes);
            if (role == 1) {
                userIndex = keyIndices[0] + 1;
            }
            Properties props = new Properties();
            props.setProperty("security-username", "gemfire" + userIndex);
            props.setProperty("security-password", "gemfire" + userIndex);
            return props;
        }

        @Override
        public Properties getDisallowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int[] keyIndices, int num) {
            int userIndex = 0;
            for (int index = 0; index < keyIndices.length; ++index) {
                if (keyIndices[index] == index) continue;
                userIndex = index + 1;
                break;
            }
            Properties props = new Properties();
            props.setProperty("security-username", "gemfire" + userIndex);
            props.setProperty("security-password", "gemfire" + userIndex);
            return props;
        }

        @Override
        public CredentialGenerator getCredentialGenerator() {
            return null;
        }
    }
}

