/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.Host;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class ClientPostAuthorizationDUnitTest
extends ClientAuthorizationTestBase {
    public ClientPostAuthorizationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
    }

    public void testAllPostOps() {
        ClientAuthorizationTestBase.OperationWithAction[] allOps = new ClientAuthorizationTestBase.OperationWithAction[]{new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 512, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 514, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4626, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4096, 6), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.KEY_SET, 2, 0, 6), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.KEY_SET, 3, 2, 6), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 7), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY, 2, 16, 7), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.QUERY, 3, 18, 7), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4096, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.EXECUTE_CQ, 2, 0, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.EXECUTE_CQ, 3, 2, 8), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END};
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientAuthorizationTestBase.TestAuthzCredentialGenerator tgen = new ClientAuthorizationTestBase.TestAuthzCredentialGenerator(gen);
            ClientPostAuthorizationDUnitTest.getLogWriter().info("testAllPostOps: Using authinit: " + authInit);
            ClientPostAuthorizationDUnitTest.getLogWriter().info("testAllPostOps: Using authenticator: " + authenticator);
            ClientPostAuthorizationDUnitTest.getLogWriter().info("testAllPostOps: Using accessor: " + accessor);
            Properties serverProps = ClientPostAuthorizationDUnitTest.buildProperties(authenticator, accessor, true, extraAuthProps, extraAuthzProps);
            Integer port1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            server1.invoke(SecurityTestUtil.class, "closeCache");
            server2.invoke(SecurityTestUtil.class, "closeCache");
            ArrayList<ClientAuthorizationTestBase.OperationWithAction> opBlock = new ArrayList<ClientAuthorizationTestBase.OperationWithAction>();
            Random rnd = new Random();
            for (int opNum = 0; opNum < allOps.length; ++opNum) {
                ClientAuthorizationTestBase.OperationWithAction currentOp = allOps[opNum];
                if (currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END) || currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                    if (opBlock.size() <= 0) continue;
                    server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
                    server2.invoke(SecurityTestUtil.class, "closeCache");
                    this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    if (!currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                        server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
                        server1.invoke(SecurityTestUtil.class, "closeCache");
                        this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    }
                    opBlock.clear();
                    continue;
                }
                currentOp.setOpNum(opNum);
                opBlock.add(currentOp);
            }
        }
    }

    public void testAllOpsNotifications() {
        ClientAuthorizationTestBase.OperationWithAction[] allOps = new ClientAuthorizationTestBase.OperationWithAction[]{new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 32832, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 3, 41024, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4353, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 32832, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 3, 41024, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4368, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4369, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 0, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 64, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 3, 36928, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 4096, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.DESTROY, 1, 4096, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4353, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4352, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4096, 8), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 0, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 32, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 3, 36896, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 4096, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGION_CLEAR, 1, 4096, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4353, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4352, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4096, 8), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 16416, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 3, 57376, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGION_CREATE, 1, 16384, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 5120, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 7424, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 7428, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGION_DESTROY, 1, 5120, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 7428, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 5640, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 7428, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 5640, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 0, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 32, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, 3, 36896, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 3, 4096, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGION_DESTROY, 1, 0, 1), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4356, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4352, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER};
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            ClientPostAuthorizationDUnitTest.getLogWriter().info("Executing opblocks with credential generator " + gen);
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientAuthorizationTestBase.TestAuthzCredentialGenerator tgen = new ClientAuthorizationTestBase.TestAuthzCredentialGenerator(gen);
            ClientPostAuthorizationDUnitTest.getLogWriter().info("testAllOpsNotifications: Using authinit: " + authInit);
            ClientPostAuthorizationDUnitTest.getLogWriter().info("testAllOpsNotifications: Using authenticator: " + authenticator);
            ClientPostAuthorizationDUnitTest.getLogWriter().info("testAllOpsNotifications: Using accessor: " + accessor);
            Properties serverProps = ClientPostAuthorizationDUnitTest.buildProperties(authenticator, accessor, true, extraAuthProps, extraAuthzProps);
            Integer port1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            ArrayList<ClientAuthorizationTestBase.OperationWithAction> opBlock = new ArrayList<ClientAuthorizationTestBase.OperationWithAction>();
            Random rnd = new Random();
            for (int opNum = 0; opNum < allOps.length; ++opNum) {
                ClientAuthorizationTestBase.OperationWithAction currentOp = allOps[opNum];
                if (currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END) || currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                    if (opBlock.size() <= 0) continue;
                    server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
                    server2.invoke(SecurityTestUtil.class, "closeCache");
                    this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    if (!currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                        server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
                        server1.invoke(SecurityTestUtil.class, "closeCache");
                        this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    }
                    opBlock.clear();
                    continue;
                }
                currentOp.setOpNum(opNum);
                opBlock.add(currentOp);
            }
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(SecurityTestUtil.class, "closeCache");
        client2.invoke(SecurityTestUtil.class, "closeCache");
        SecurityTestUtil.closeCache();
        server1.invoke(SecurityTestUtil.class, "closeCache");
        server2.invoke(SecurityTestUtil.class, "closeCache");
    }
}

