/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.NoAvailableServersException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.ClientAuthenticationDUnitTest;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.NotAuthorizedException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.Host;
import java.util.Properties;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class DeltaClientAuthorizationDUnitTest
extends ClientAuthorizationTestBase {
    protected static final DeltaTestImpl[] deltas = new DeltaTestImpl[8];

    public DeltaClientAuthorizationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(SecurityTestUtil.class, "closeCache");
        client2.invoke(SecurityTestUtil.class, "closeCache");
        SecurityTestUtil.closeCache();
        server1.invoke(SecurityTestUtil.class, "closeCache");
        server2.invoke(SecurityTestUtil.class, "closeCache");
    }

    public void testAllowPutsGets() throws Exception {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            DeltaClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: Using authinit: " + authInit);
            DeltaClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: Using authenticator: " + authenticator);
            DeltaClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: Using accessor: " + accessor);
            Properties serverProps = DeltaClientAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Integer port1 = (Integer)server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            Integer port2 = (Integer)server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), serverProps, javaProps});
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            javaProps = cGen.getJavaProperties();
            DeltaClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: For first client credentials: " + createCredentials);
            client1.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, createCredentials, javaProps, port1, port2, null, new Integer(0)});
            Properties getCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, 2);
            javaProps = cGen.getJavaProperties();
            DeltaClientAuthorizationDUnitTest.getLogWriter().info("testAllowPutsGets: For second client credentials: " + getCredentials);
            client2.invoke(ClientAuthenticationDUnitTest.class, "createCacheClient", new Object[]{authInit, getCredentials, javaProps, port1, port2, null, new Integer(0)});
            client1.invoke(DeltaClientAuthorizationDUnitTest.class, "doPuts", new Object[]{new Integer(2), new Integer(0), Boolean.FALSE});
            Thread.sleep(5000L);
            DeltaClientAuthorizationDUnitTest.assertTrue((String)"Delta feature NOT used", (boolean)((Boolean)client1.invoke(DeltaTestImpl.class, "toDeltaFeatureUsed")));
            client2.invoke(DeltaClientAuthorizationDUnitTest.class, "doGets", new Object[]{new Integer(2), new Integer(0), Boolean.FALSE});
        }
    }

    public static void doPuts(Integer num, Integer expectedResult, boolean newVals) {
        int index;
        DeltaClientAuthorizationDUnitTest.assertTrue((num <= SecurityTestUtil.keys.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = SecurityTestUtil.getCache().getRegion("AuthRegion");
            DeltaClientAuthorizationDUnitTest.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected exception when doing puts: " + ex);
            }
            DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing puts", ex);
        }
        for (index = 0; index < num; ++index) {
            region.put((Object)SecurityTestUtil.keys[index], (Object)deltas[0]);
        }
        for (index = 0; index < num; ++index) {
            try {
                region.put((Object)SecurityTestUtil.keys[index], (Object)deltas[index]);
                if (expectedResult == 0) continue;
                DeltaClientAuthorizationDUnitTest.fail((String)"Expected a NotAuthorizedException while doing puts");
                continue;
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected NoAvailableServers when doing puts: " + ex.getCause());
                    continue;
                }
                DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing puts", ex);
                continue;
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected NotAuthorizedException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 1 && ex.getCause() instanceof AuthenticationRequiredException) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected AuthenticationRequiredException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 2 && ex.getCause() instanceof AuthenticationFailedException) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected AuthenticationFailedException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected exception when doing puts: " + (Object)((Object)ex));
                    continue;
                }
                DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing puts", ex);
                continue;
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected exception when doing puts: " + ex);
                    continue;
                }
                DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing puts", ex);
            }
        }
    }

    public static void doGets(Integer num, Integer expectedResult, boolean newVals) {
        DeltaClientAuthorizationDUnitTest.assertTrue((num <= SecurityTestUtil.keys.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = SecurityTestUtil.getCache().getRegion("AuthRegion");
            DeltaClientAuthorizationDUnitTest.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected exception when doing gets: " + ex);
            }
            DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing gets", ex);
        }
        for (int index = 0; index < num; ++index) {
            Object value = null;
            try {
                try {
                    region.localInvalidate((Object)SecurityTestUtil.keys[index]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                value = region.get((Object)SecurityTestUtil.keys[index]);
                if (expectedResult != 0) {
                    DeltaClientAuthorizationDUnitTest.fail((String)"Expected a NotAuthorizedException while doing gets");
                }
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected NoAvailableServers when doing puts: " + ex.getCause());
                    continue;
                }
                DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing puts", ex);
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected NotAuthorizedException when doing gets: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected exception when doing gets: " + (Object)((Object)ex));
                } else {
                    DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing gets", ex);
                }
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    DeltaClientAuthorizationDUnitTest.getLogWriter().info("Got expected exception when doing gets: " + ex);
                }
                DeltaClientAuthorizationDUnitTest.fail("Got unexpected exception when doing gets", ex);
            }
            DeltaClientAuthorizationDUnitTest.assertNotNull((Object)value);
            DeltaClientAuthorizationDUnitTest.assertEquals((Object)deltas[index], (Object)value);
        }
    }

    static {
        for (int i = 0; i < 8; ++i) {
            DeltaClientAuthorizationDUnitTest.deltas[i] = new DeltaTestImpl(0, "0", new Double(0.0), new byte[0], new DeltaTestImpl.TestObject1("0", 0));
        }
        deltas[1].setIntVar(5);
        deltas[2].setIntVar(5);
        deltas[3].setIntVar(5);
        deltas[4].setIntVar(5);
        deltas[5].setIntVar(5);
        deltas[6].setIntVar(5);
        deltas[7].setIntVar(5);
        deltas[2].resetDeltaStatus();
        deltas[2].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltas[3].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltas[4].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltas[5].setByteArr(new byte[]{1, 2, 3, 4, 5});
        deltas[3].resetDeltaStatus();
        deltas[3].setDoubleVar(new Double(5.0));
        deltas[4].setDoubleVar(new Double(5.0));
        deltas[5].setDoubleVar(new Double(5.0));
        deltas[6].setDoubleVar(new Double(5.0));
        deltas[7].setDoubleVar(new Double(5.0));
        deltas[4].resetDeltaStatus();
        deltas[4].setStr("str changed");
        deltas[5].setStr("str changed");
        deltas[6].setStr("str changed");
        deltas[5].resetDeltaStatus();
        deltas[5].setIntVar(100);
        deltas[5].setTestObj(new DeltaTestImpl.TestObject1("CHANGED", 100));
        deltas[6].setTestObj(new DeltaTestImpl.TestObject1("CHANGED", 100));
        deltas[7].setTestObj(new DeltaTestImpl.TestObject1("CHANGED", 100));
        deltas[6].resetDeltaStatus();
        deltas[6].setByteArr(new byte[]{1, 2, 3});
        deltas[7].setByteArr(new byte[]{1, 2, 3});
        deltas[7].resetDeltaStatus();
        deltas[7].setStr("delta string");
    }
}

