/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.DeltaClientAuthorizationDUnitTest;
import com.gemstone.gemfire.security.NotAuthorizedException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class DeltaClientPostAuthorizationDUnitTest
extends ClientAuthorizationTestBase {
    private static final int PAUSE = 5000;

    public DeltaClientPostAuthorizationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(SecurityTestUtil.class, "closeCache");
        client2.invoke(SecurityTestUtil.class, "closeCache");
        SecurityTestUtil.closeCache();
        server1.invoke(SecurityTestUtil.class, "closeCache");
        server2.invoke(SecurityTestUtil.class, "closeCache");
    }

    public void testPutPostOpNotifications() throws Exception {
        ClientAuthorizationTestBase.OperationWithAction[] allOps = new ClientAuthorizationTestBase.OperationWithAction[]{new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 32832, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 3, 41024, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4352, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4353, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END, new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 2, 32832, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.GET, 3, 41024, 8), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.PUT, 1, 4112, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 2, 4368, 4), new ClientAuthorizationTestBase.OperationWithAction(OperationContext.OperationCode.GET, 3, 4369, 4), ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END};
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            ClientAuthorizationTestBase.TestAuthzCredentialGenerator tgen = new ClientAuthorizationTestBase.TestAuthzCredentialGenerator(gen);
            DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("testAllOpsNotifications: Using authinit: " + authInit);
            DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("testAllOpsNotifications: Using authenticator: " + authenticator);
            DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("testAllOpsNotifications: Using accessor: " + accessor);
            Properties serverProps = DeltaClientPostAuthorizationDUnitTest.buildProperties(authenticator, accessor, true, extraAuthProps, extraAuthzProps);
            Integer port1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
            ArrayList<ClientAuthorizationTestBase.OperationWithAction> opBlock = new ArrayList<ClientAuthorizationTestBase.OperationWithAction>();
            Random rnd = new Random();
            for (int opNum = 0; opNum < allOps.length; ++opNum) {
                ClientAuthorizationTestBase.OperationWithAction currentOp = allOps[opNum];
                if (currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_END) || currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                    if (opBlock.size() <= 0) continue;
                    server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
                    server2.invoke(SecurityTestUtil.class, "closeCache");
                    this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    if (!currentOp.equals(ClientAuthorizationTestBase.OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                        server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
                        server1.invoke(SecurityTestUtil.class, "closeCache");
                        this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    }
                    opBlock.clear();
                    continue;
                }
                currentOp.setOpNum(opNum);
                opBlock.add(currentOp);
            }
        }
    }

    @Override
    protected void executeOpBlock(List opBlock, Integer port1, Integer port2, String authInit, Properties extraAuthProps, Properties extraAuthzProps, ClientAuthorizationTestBase.TestCredentialGenerator gen, Random rnd) {
        for (ClientAuthorizationTestBase.OperationWithAction currentOp : opBlock) {
            OperationContext.OperationCode opCode = currentOp.getOperationCode();
            int opFlags = currentOp.getFlags();
            int clientNum = currentOp.getClientNum();
            VM clientVM = null;
            boolean useThisVM = false;
            switch (clientNum) {
                case 1: {
                    clientVM = client1;
                    break;
                }
                case 2: {
                    clientVM = client2;
                    break;
                }
                case 3: {
                    useThisVM = true;
                    break;
                }
                default: {
                    DeltaClientPostAuthorizationDUnitTest.fail((String)("executeOpBlock: Unknown client number " + clientNum));
                }
            }
            DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("executeOpBlock: performing operation number [" + currentOp.getOpNum() + "]: " + currentOp);
            if ((opFlags & 0x1000) == 0) {
                boolean setupDynamicRegionFactory;
                String credentialsTypeStr;
                Properties opCredentials;
                int newRnd = rnd.nextInt(100) + 1;
                String currentRegionName = "/AuthRegion";
                if ((opFlags & 0x400) > 0) {
                    currentRegionName = currentRegionName + "/AuthSubregion";
                }
                OperationContext.OperationCode authOpCode = currentOp.getAuthzOperationCode();
                int[] indices = currentOp.getIndices();
                CredentialGenerator cGen = gen.getCredentialGenerator();
                Properties javaProps = null;
                if ((opFlags & 2) > 0 || (opFlags & 0x2000) > 0) {
                    opCredentials = gen.getDisallowedCredentials(new OperationContext.OperationCode[]{authOpCode}, new String[]{currentRegionName}, indices, newRnd);
                    credentialsTypeStr = " unauthorized " + authOpCode;
                } else {
                    opCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{opCode, authOpCode}, new String[]{currentRegionName}, indices, newRnd);
                    credentialsTypeStr = " authorized " + authOpCode;
                }
                if (cGen != null) {
                    javaProps = cGen.getJavaProperties();
                }
                Properties clientProps = SecurityTestUtil.concatProperties(new Properties[]{opCredentials, extraAuthProps, extraAuthzProps});
                DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("executeOpBlock: For client" + clientNum + credentialsTypeStr + " credentials: " + opCredentials);
                boolean bl = setupDynamicRegionFactory = (opFlags & 0x4000) > 0;
                if (useThisVM) {
                    DeltaClientPostAuthorizationDUnitTest.createCacheClient(authInit, clientProps, javaProps, new Integer[]{port1, port2}, null, setupDynamicRegionFactory, new Integer(0));
                } else {
                    clientVM.invoke(ClientAuthorizationTestBase.class, "createCacheClient", new Object[]{authInit, clientProps, javaProps, new Integer[]{port1, port2}, null, setupDynamicRegionFactory, new Integer(0)});
                }
            }
            int expectedResult = (opFlags & 2) > 0 ? 4 : ((opFlags & 8) > 0 ? 5 : 0);
            if (useThisVM) {
                DeltaClientPostAuthorizationDUnitTest.doOp(new Byte(opCode.toOrdinal()), currentOp.getIndices(), new Integer(opFlags), new Integer(expectedResult));
                continue;
            }
            clientVM.invoke(DeltaClientPostAuthorizationDUnitTest.class, "doOp", new Object[]{new Byte(opCode.toOrdinal()), currentOp.getIndices(), new Integer(opFlags), new Integer(expectedResult)});
        }
    }

    private static Region createSubregion(Region region) {
        Region subregion = DeltaClientPostAuthorizationDUnitTest.getSubregion();
        if (subregion == null) {
            subregion = region.createSubregion("AuthSubregion", region.getAttributes());
        }
        return subregion;
    }

    public static void doOp(Byte opCode, int[] indices, Integer flagsI, Integer expectedResult) {
        OperationContext.OperationCode op = OperationContext.OperationCode.fromOrdinal((byte)opCode);
        boolean operationOmitted = false;
        final int flags = flagsI;
        Region region = DeltaClientPostAuthorizationDUnitTest.getRegion();
        if ((flags & 0x400) > 0) {
            DeltaClientPostAuthorizationDUnitTest.assertNotNull((Object)region);
            Region subregion = null;
            if ((flags & 0x800) > 0) {
                if ((flags & 4) > 0) {
                    SecurityTestUtil.waitForCondition(new Callable(){

                        public Object call() throws Exception {
                            return ClientAuthorizationTestBase.getSubregion() == null;
                        }
                    });
                    subregion = DeltaClientPostAuthorizationDUnitTest.getSubregion();
                    DeltaClientPostAuthorizationDUnitTest.assertNull((Object)subregion);
                    return;
                }
                SecurityTestUtil.waitForCondition(new Callable(){

                    public Object call() throws Exception {
                        return ClientAuthorizationTestBase.getSubregion() != null;
                    }
                });
                subregion = DeltaClientPostAuthorizationDUnitTest.getSubregion();
                DeltaClientPostAuthorizationDUnitTest.assertNotNull((Object)subregion);
            } else {
                subregion = DeltaClientPostAuthorizationDUnitTest.createSubregion(region);
            }
            DeltaClientPostAuthorizationDUnitTest.assertNotNull((Object)subregion);
            region = subregion;
        } else {
            if ((flags & 4) > 0) {
                SecurityTestUtil.waitForCondition(new Callable(){

                    public Object call() throws Exception {
                        return ClientAuthorizationTestBase.getRegion() == null;
                    }
                });
                region = DeltaClientPostAuthorizationDUnitTest.getRegion();
                DeltaClientPostAuthorizationDUnitTest.assertNull((Object)region);
                return;
            }
            DeltaClientPostAuthorizationDUnitTest.assertNotNull((Object)region);
        }
        String[] keys = SecurityTestUtil.keys;
        DeltaTestImpl[] vals = (flags & 0x10) > 0 ? DeltaClientAuthorizationDUnitTest.deltas : DeltaClientAuthorizationDUnitTest.deltas;
        InterestResultPolicy policy = InterestResultPolicy.KEYS_VALUES;
        if ((flags & 0x8000) > 0) {
            policy = InterestResultPolicy.NONE;
        }
        int numOps = indices.length;
        DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("Got doOp for op: " + op.toString() + ", numOps: " + numOps + ", indices: " + DeltaClientPostAuthorizationDUnitTest.indicesToString(indices) + ", expect: " + expectedResult);
        boolean exceptionOccured = false;
        boolean breakLoop = false;
        if (op.isGet()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                DeltaClientPostAuthorizationDUnitTest.fail((String)"interrupted");
            }
        }
        for (int indexIndex = 0; indexIndex < numOps && !breakLoop; ++indexIndex) {
            int index = indices[indexIndex];
            try {
                final String key = keys[index];
                final DeltaTestImpl expectedVal = vals[index];
                if (op.isGet()) {
                    Object value = null;
                    if ((flags & 0x20) > 0) {
                        String searchKey;
                        breakLoop = true;
                        ArrayList<String> keyList = new ArrayList<String>(numOps);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            searchKey = keys[keyNum];
                            keyList.add(searchKey);
                            if ((flags & 0x200) > 0) {
                                DeltaClientPostAuthorizationDUnitTest.assertFalse((boolean)region.containsKey((Object)searchKey));
                                continue;
                            }
                            if (keyNumIndex % 2 != 1) continue;
                            DeltaClientPostAuthorizationDUnitTest.assertTrue((boolean)region.containsKey((Object)searchKey));
                            region.localInvalidate((Object)searchKey);
                        }
                        Map entries = region.getAll(keyList);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            searchKey = keys[keyNum];
                            if ((flags & 1) > 0) {
                                DeltaClientPostAuthorizationDUnitTest.assertFalse((boolean)entries.containsKey(searchKey));
                                continue;
                            }
                            DeltaClientPostAuthorizationDUnitTest.assertTrue((boolean)entries.containsKey(searchKey));
                            value = entries.get(searchKey);
                            DeltaClientPostAuthorizationDUnitTest.assertEquals((Object)vals[keyNum], (Object)value);
                        }
                        break;
                    }
                    if ((flags & 0x100) > 0) {
                        Callable cond = new Callable(){
                            private Region region;

                            public Object call() throws Exception {
                                Object value = SecurityTestUtil.getLocalValue(this.region, key);
                                return (flags & 1) > 0 ? !expectedVal.equals(value) : expectedVal.equals(value);
                            }

                            public Callable init(Region region) {
                                this.region = region;
                                return this;
                            }
                        }.init(region);
                        SecurityTestUtil.waitForCondition(cond);
                        value = SecurityTestUtil.getLocalValue(region, key);
                    } else {
                        if ((flags & 0x200) > 0) {
                            DeltaClientPostAuthorizationDUnitTest.assertFalse((boolean)region.containsKey((Object)key));
                        } else {
                            DeltaClientPostAuthorizationDUnitTest.assertTrue((boolean)region.containsKey((Object)key));
                            region.localInvalidate((Object)key);
                        }
                        value = region.get((Object)key);
                    }
                    if ((flags & 1) > 0) {
                        DeltaClientPostAuthorizationDUnitTest.assertFalse((boolean)expectedVal.equals(value));
                    } else {
                        DeltaClientPostAuthorizationDUnitTest.assertNotNull((Object)value);
                        DeltaClientPostAuthorizationDUnitTest.assertEquals((Object)expectedVal, (Object)value);
                    }
                } else if (op.isPut()) {
                    region.put((Object)key, (Object)expectedVal);
                } else if (op.isRegisterInterest()) {
                    if ((flags & 0x80) > 0) {
                        breakLoop = true;
                        ArrayList<String> keyList = new ArrayList<String>(numOps);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            keyList.add(keys[keyNum]);
                        }
                        region.registerInterest(keyList, policy);
                    } else if ((flags & 0x40) > 0) {
                        breakLoop = true;
                        region.registerInterestRegex("key[1-" + numOps + ']', policy);
                    } else if ((flags & 0x20) > 0) {
                        breakLoop = true;
                        region.registerInterest((Object)"ALL_KEYS", policy);
                    } else {
                        region.registerInterest((Object)key, policy);
                    }
                } else {
                    DeltaClientPostAuthorizationDUnitTest.fail((String)("doOp: Unhandled operation " + op));
                }
                if (expectedResult == 0 || operationOmitted || op.isUnregisterInterest()) continue;
                DeltaClientPostAuthorizationDUnitTest.fail((String)("Expected an exception while performing operation op =" + op + "flags = " + ClientAuthorizationTestBase.OpFlags.description(flags)));
                continue;
            }
            catch (Exception ex) {
                exceptionOccured = true;
                if ((ex instanceof ServerConnectivityException || ex instanceof QueryInvocationTargetException || ex instanceof CqException) && expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("doOp: Got expected NotAuthorizedException when doing operation [" + op + "] with flags " + ClientAuthorizationTestBase.OpFlags.description(flags) + ": " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    DeltaClientPostAuthorizationDUnitTest.getLogWriter().info("doOp: Got expected exception when doing operation: " + ex.toString());
                    continue;
                }
                DeltaClientPostAuthorizationDUnitTest.fail("doOp: Got unexpected exception when doing operation. Policy = " + policy + " flags = " + ClientAuthorizationTestBase.OpFlags.description(flags), ex);
            }
        }
        if (!exceptionOccured && !operationOmitted && expectedResult != 0) {
            DeltaClientPostAuthorizationDUnitTest.fail((String)("Expected an exception while performing operation: " + op + " flags = " + ClientAuthorizationTestBase.OpFlags.description(flags)));
        }
    }
}

