/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class MultiuserDurableCQAuthzDUnitTest
extends ClientAuthorizationTestBase {
    public static final Map<String, String> cqNameToQueryStrings = new HashMap<String, String>();

    public MultiuserDurableCQAuthzDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        MultiuserDurableCQAuthzDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                MultiuserDurableCQAuthzDUnitTest.this.getSystem();
            }
        });
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
    }

    public void testCQForDurableClientsWithDefaultClose() throws Exception {
        Integer numOfUsers = 2;
        Integer numOfPuts = 5;
        Boolean[] postAuthzAllowed = new Boolean[]{Boolean.TRUE, Boolean.TRUE};
        Iterator iter = this.getAllGeneratorCombos().iterator();
        while (iter.hasNext()) {
            this.doTest(numOfUsers, numOfPuts, postAuthzAllowed, (AuthzCredentialGenerator)iter.next(), null);
        }
    }

    public void testCQForDurableClientsWithCloseKeepAliveTrue() throws Exception {
        Integer numOfUsers = 2;
        Integer numOfPuts = 5;
        Boolean[] postAuthzAllowed = new Boolean[]{Boolean.TRUE, Boolean.TRUE};
        Iterator iter = this.getAllGeneratorCombos().iterator();
        while (iter.hasNext()) {
            this.doTest(numOfUsers, numOfPuts, postAuthzAllowed, (AuthzCredentialGenerator)iter.next(), Boolean.TRUE);
        }
    }

    public void testCQForDurableClientsWithCloseKeepAliveFalse() throws Exception {
        Integer numOfUsers = 2;
        Integer numOfPuts = 5;
        Boolean[] postAuthzAllowed = new Boolean[]{Boolean.TRUE, Boolean.TRUE};
        Iterator iter = this.getAllGeneratorCombos().iterator();
        while (iter.hasNext()) {
            this.doTest(numOfUsers, numOfPuts, postAuthzAllowed, (AuthzCredentialGenerator)iter.next(), Boolean.FALSE);
        }
    }

    private void doTest(Integer numOfUsers, Integer numOfPuts, Boolean[] postAuthzAllowed, AuthzCredentialGenerator gen, Boolean keepAlive) throws Exception {
        CredentialGenerator cGen = gen.getCredentialGenerator();
        Properties extraAuthProps = cGen.getSystemProperties();
        Properties javaProps = cGen.getJavaProperties();
        Properties extraAuthzProps = gen.getSystemProperties();
        String authenticator = cGen.getAuthenticator();
        String accessor = gen.getAuthorizationCallback();
        String authInit = cGen.getAuthInit();
        ClientAuthorizationTestBase.TestAuthzCredentialGenerator tgen = new ClientAuthorizationTestBase.TestAuthzCredentialGenerator(gen);
        Properties serverProps = MultiuserDurableCQAuthzDUnitTest.buildProperties(authenticator, accessor, true, extraAuthProps, extraAuthzProps);
        cGen = tgen.getCredentialGenerator();
        Properties javaProps2 = null;
        if (cGen != null) {
            javaProps2 = cGen.getJavaProperties();
        }
        int[] indices = new int[numOfPuts.intValue()];
        for (int index = 0; index < numOfPuts; ++index) {
            indices[index] = index;
        }
        Random rnd = new Random();
        Properties[] authProps = new Properties[numOfUsers.intValue()];
        String durableClientId = "multiuser_durable_client_1";
        Properties client2Credentials = null;
        for (int i = 0; i < numOfUsers; ++i) {
            int rand = rnd.nextInt(100) + 1;
            Properties opCredentials = postAuthzAllowed[i] != false ? tgen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.EXECUTE_CQ, OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, indices, rand) : tgen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, indices, rand);
            authProps[i] = SecurityTestUtil.concatProperties(new Properties[]{opCredentials, extraAuthProps, extraAuthzProps});
            if (client2Credentials != null) continue;
            client2Credentials = tgen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, indices, rand);
        }
        Integer port1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        Integer port2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        Integer mcastPort = new Integer(AvailablePort.getRandomAvailablePort((int)1));
        server1.invoke(SecurityTestUtil.class, "closeCache");
        server2.invoke(SecurityTestUtil.class, "closeCache");
        server1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "createServerCache", new Object[]{serverProps, javaProps, mcastPort, port1});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "createClientCache", new Object[]{javaProps2, authInit, authProps, new Integer[]{port1, port2}, numOfUsers, durableClientId, postAuthzAllowed});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "createCQ", new Object[]{numOfUsers, Boolean.TRUE});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "executeCQ", new Object[]{numOfUsers, new Boolean[]{false, false}, numOfPuts, new String[numOfUsers.intValue()]});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "readyForEvents");
        if (keepAlive == null) {
            client1.invoke(SecurityTestUtil.class, "closeCache");
        } else {
            client1.invoke(SecurityTestUtil.class, "closeCache", new Object[]{keepAlive});
        }
        server1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "doPuts", new Object[]{numOfPuts, Boolean.TRUE});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "createClientCache", new Object[]{javaProps2, authInit, authProps, new Integer[]{port1, port2}, numOfUsers, durableClientId, postAuthzAllowed});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "createCQ", new Object[]{numOfUsers, Boolean.TRUE});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "executeCQ", new Object[]{numOfUsers, new Boolean[]{false, false}, numOfPuts, new String[numOfUsers.intValue()]});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "readyForEvents");
        if (!postAuthzAllowed[0].booleanValue() || keepAlive == null || !keepAlive.booleanValue()) {
            Thread.sleep(1000L);
        } else {
            client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "waitForLastKey", new Object[]{0, Boolean.TRUE});
        }
        Integer numOfCreates = keepAlive == null ? 0 : (keepAlive != false ? numOfPuts + 1 : 0);
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "checkCQListeners", new Object[]{numOfUsers, postAuthzAllowed, numOfCreates, 0});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "proxyCacheClose", new Object[]{new Integer[]{0, 1}, keepAlive});
        client1.invoke(SecurityTestUtil.class, "createProxyCache", new Object[]{new Integer[]{0, 1}, authProps});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "createCQ", new Object[]{numOfUsers, Boolean.TRUE});
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "executeCQ", new Object[]{numOfUsers, new Boolean[]{false, false}, numOfPuts, new String[numOfUsers.intValue()]});
        server1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "doPuts", new Object[]{numOfPuts, Boolean.TRUE});
        if (!postAuthzAllowed[0].booleanValue() || keepAlive == null || !keepAlive.booleanValue()) {
            Thread.sleep(1000L);
        } else {
            client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "waitForLastKey", new Object[]{0, Boolean.FALSE});
        }
        Integer numOfUpdates = numOfPuts + 1;
        client1.invoke(MultiuserDurableCQAuthzDUnitTest.class, "checkCQListeners", new Object[]{numOfUsers, postAuthzAllowed, 0, numOfUpdates});
    }

    public static void createServerCache(Properties serverProps, Properties javaProps, Integer mcastPort, Integer serverPort) {
        SecurityTestUtil.createCacheServer(serverProps, javaProps, mcastPort, null, serverPort, Boolean.TRUE, new Integer(0));
    }

    public static void createClientCache(Properties javaProps, String authInit, Properties[] authProps, Integer[] ports, Integer numOfUsers, Boolean[] postAuthzAllowed) {
        SecurityTestUtil.createCacheClientForMultiUserMode(numOfUsers, authInit, authProps, javaProps, ports, null, Boolean.FALSE, 0);
    }

    public static void readyForEvents() {
        GemFireCacheImpl.getInstance().readyForEvents();
    }

    public static void createClientCache(Properties javaProps, String authInit, Properties[] authProps, Integer[] ports, Integer numOfUsers, String durableId, Boolean[] postAuthzAllowed) {
        SecurityTestUtil.createCacheClientForMultiUserMode(numOfUsers, authInit, authProps, javaProps, ports, null, Boolean.FALSE, durableId, 0);
    }

    public static void createCQ(Integer num) {
        MultiuserDurableCQAuthzDUnitTest.createCQ(num, false);
    }

    public static void createCQ(Integer num, Boolean isDurable) {
        for (int i = 0; i < num; ++i) {
            QueryService cqService = SecurityTestUtil.proxyCaches[i].getQueryService();
            String cqName = "CQ_" + i;
            String queryStr = cqNameToQueryStrings.get(cqName) + SecurityTestUtil.proxyCaches[i].getRegion("AuthRegion").getFullPath();
            CqAttributesFactory cqf = new CqAttributesFactory();
            CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(MultiuserDurableCQAuthzDUnitTest.getLogWriter())};
            ((CqQueryTestListener)cqListeners[0]).cqName = cqName;
            cqf.initCqListeners(cqListeners);
            CqAttributes cqa = cqf.create();
            try {
                CqQuery cq1 = cqService.newCq(cqName, queryStr, cqa, isDurable.booleanValue());
                MultiuserDurableCQAuthzDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                continue;
            }
            catch (Exception ex) {
                AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
                ((Throwable)((Object)err)).initCause(ex);
                MultiuserDurableCQAuthzDUnitTest.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
                throw err;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCQ(Integer num, Boolean[] initialResults, Integer expectedResultsSize, String[] expectedErr) {
        for (int i = 0; i < num; ++i) {
            try {
                if (expectedErr[i] != null) {
                    SecurityTestUtil.proxyCaches[i].getLogger().info("<ExpectedException action=add>" + expectedErr[i] + "</ExpectedException>");
                }
                CqQuery cq1 = null;
                String cqName = "CQ_" + i;
                String queryStr = cqNameToQueryStrings.get(cqName) + SecurityTestUtil.proxyCaches[i].getRegion("AuthRegion").getFullPath();
                QueryService cqService = SecurityTestUtil.proxyCaches[i].getQueryService();
                try {
                    cq1 = cqService.getCq(cqName);
                    if (cq1 == null) {
                        MultiuserDurableCQAuthzDUnitTest.getLogWriter().info("Failed to get CqQuery object for CQ name: " + cqName);
                        MultiuserDurableCQAuthzDUnitTest.fail((String)("Failed to get CQ " + cqName));
                    } else {
                        MultiuserDurableCQAuthzDUnitTest.getLogWriter().info("Obtained CQ, CQ name: " + cq1.getName());
                        MultiuserDurableCQAuthzDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                    }
                }
                catch (Exception ex) {
                    MultiuserDurableCQAuthzDUnitTest.getLogWriter().info("CqService is :" + cqService);
                    MultiuserDurableCQAuthzDUnitTest.getLogWriter().error((Throwable)ex);
                    AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                if (initialResults[i].booleanValue()) {
                    CqResults cqResults = null;
                    try {
                        cqResults = cq1.executeWithInitialResults();
                    }
                    catch (Exception ex) {
                        MultiuserDurableCQAuthzDUnitTest.getLogWriter().info("CqService is: " + cqService);
                        ex.printStackTrace();
                        AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                        ((Throwable)((Object)err)).initCause(ex);
                        throw err;
                    }
                    MultiuserDurableCQAuthzDUnitTest.getLogWriter().info("initial result size = " + cqResults.size());
                    MultiuserDurableCQAuthzDUnitTest.assertTrue((String)"executeWithInitialResults() state mismatch", (boolean)cq1.getState().isRunning());
                    if (expectedResultsSize < 0) continue;
                    MultiuserDurableCQAuthzDUnitTest.assertEquals((String)"unexpected results size", (int)expectedResultsSize, (int)cqResults.size());
                    continue;
                }
                try {
                    cq1.execute();
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                    ((Throwable)((Object)err)).initCause(ex);
                    if (expectedErr == null) {
                        MultiuserDurableCQAuthzDUnitTest.getLogWriter().info("CqService is: " + cqService, (Throwable)((Object)err));
                    }
                    throw err;
                }
                MultiuserDurableCQAuthzDUnitTest.assertTrue((String)"execute() state mismatch", (boolean)cq1.getState().isRunning());
                continue;
            }
            finally {
                if (expectedErr[i] != null) {
                    SecurityTestUtil.proxyCaches[i].getLogger().info("<ExpectedException action=remove>" + expectedErr[i] + "</ExpectedException>");
                }
            }
        }
    }

    public static void doPuts(Integer num, Boolean putLastKey) {
        Region region = GemFireCacheImpl.getInstance().getRegion("AuthRegion");
        for (int i = 0; i < num; ++i) {
            region.put((Object)("CQ_key" + i), (Object)("CQ_value" + i));
        }
        if (putLastKey.booleanValue()) {
            region.put((Object)"LAST_KEY", (Object)"LAST_KEY");
        }
    }

    public static void putLastKey() {
        Region region = GemFireCacheImpl.getInstance().getRegion("AuthRegion");
        region.put((Object)"LAST_KEY", (Object)"LAST_KEY");
    }

    public static void waitForLastKey(Integer cqIndex, Boolean isCreate) {
        String cqName = "CQ_" + cqIndex;
        QueryService qService = SecurityTestUtil.proxyCaches[cqIndex].getQueryService();
        CqQueryImpl cqQuery = (CqQueryImpl)qService.getCq(cqName);
        if (isCreate.booleanValue()) {
            ((CqQueryTestListener)cqQuery.getCqListeners()[cqIndex]).waitForCreated("LAST_KEY");
        } else {
            ((CqQueryTestListener)cqQuery.getCqListeners()[cqIndex]).waitForUpdated("LAST_KEY");
        }
    }

    public static void checkCQListeners(Integer numOfUsers, Boolean[] expectedListenerInvocation, Integer createEventsSize, Integer updateEventsSize) {
        for (int i = 0; i < numOfUsers; ++i) {
            String cqName = "CQ_" + i;
            QueryService qService = SecurityTestUtil.proxyCaches[i].getQueryService();
            CqQueryImpl cqQuery = (CqQueryImpl)qService.getCq(cqName);
            if (expectedListenerInvocation[i].booleanValue()) {
                for (CqListener listener : cqQuery.getCqListeners()) {
                    MultiuserDurableCQAuthzDUnitTest.assertEquals((int)createEventsSize, (int)((CqQueryTestListener)listener).getCreateEventCount());
                    MultiuserDurableCQAuthzDUnitTest.assertEquals((int)updateEventsSize, (int)((CqQueryTestListener)listener).getUpdateEventCount());
                }
                continue;
            }
            for (CqListener listener : cqQuery.getCqListeners()) {
                MultiuserDurableCQAuthzDUnitTest.assertEquals((int)0, (int)((CqQueryTestListener)listener).getTotalEventCount());
            }
        }
    }

    public static void proxyCacheClose(Integer[] userIndices) {
        MultiuserDurableCQAuthzDUnitTest.proxyCacheClose(userIndices, null);
    }

    public static void proxyCacheClose(Integer[] userIndices, Boolean keepAliveFlags) {
        if (keepAliveFlags != null) {
            Integer[] arr$ = userIndices;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                SecurityTestUtil.proxyCaches[i].close(keepAliveFlags.booleanValue());
            }
        } else {
            Integer[] arr$ = userIndices;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                SecurityTestUtil.proxyCaches[i].close();
            }
        }
    }

    static {
        cqNameToQueryStrings.put("CQ_0", "SELECT * FROM ");
        cqNameToQueryStrings.put("CQ_1", "SELECT * FROM ");
    }
}

