/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.NoAvailableServersException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.ServerRefusedConnectionException;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.PureLogWriter;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.NotAuthorizedException;
import dunit.DistributedTestCase;
import hydra.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import security.CredentialGenerator;

public class SecurityTestUtil
extends DistributedTestCase {
    private static Locator locator = null;
    private static Cache cache = null;
    private static Properties currentJavaProps = null;
    private static String locatorString = null;
    private static Integer mcastPort = null;
    public static final int NO_EXCEPTION = 0;
    public static final int AUTHREQ_EXCEPTION = 1;
    public static final int AUTHFAIL_EXCEPTION = 2;
    public static final int CONNREFUSED_EXCEPTION = 3;
    public static final int NOTAUTHZ_EXCEPTION = 4;
    public static final int OTHER_EXCEPTION = 5;
    public static final int NO_AVAILABLE_SERVERS = 6;
    public static final int NOFORCE_AUTHREQ_EXCEPTION = 16;
    protected static final String regionName = "AuthRegion";
    protected static final String[] keys = new String[]{"key1", "key2", "key3", "key4", "key5", "key6", "key7", "key8"};
    protected static final String[] values = new String[]{"value1", "value2", "value3", "value4", "value5", "value6", "value7", "value8"};
    protected static final String[] nvalues = new String[]{"nvalue1", "nvalue2", "nvalue3", "nvalue4", "nvalue5", "nvalue6", "nvalue7", "nvalue8"};
    static String[] expectedExceptions = null;
    private static Pool pool = null;
    private static boolean multiUserAuthMode = false;
    private static final int numberOfUsers = 1;
    static ProxyCache[] proxyCaches = new ProxyCache[1];
    private static Region regionRef = null;

    public SecurityTestUtil(String name) {
        super(name);
    }

    public static void addExpectedExceptions(String[] expectedExceptions, LogWriter logger) {
        if (expectedExceptions != null) {
            for (int index = 0; index < expectedExceptions.length; ++index) {
                logger.info("<ExpectedException action=add>" + expectedExceptions[index] + "</ExpectedException>");
            }
        }
    }

    public static void removeExpectedExceptions(String[] expectedExceptions, LogWriter logger) {
        if (expectedExceptions != null) {
            for (int index = 0; index < expectedExceptions.length; ++index) {
                logger.info("<ExpectedException action=remove>" + expectedExceptions[index] + "</ExpectedException>");
            }
        }
    }

    public static void setJavaProps(Properties javaProps) {
        SecurityTestUtil.removeJavaProperties(currentJavaProps);
        SecurityTestUtil.addJavaProperties(javaProps);
        currentJavaProps = javaProps;
    }

    public DistributedSystem createSystem(Properties sysProps, Properties javaProps) {
        SecurityTestUtil.closeCache();
        SecurityTestUtil.clearStaticSSLContext();
        SecurityTestUtil.setJavaProps(javaProps);
        InternalDistributedSystem dsys = this.getSystem(sysProps);
        SecurityTestUtil.assertNotNull((Object)dsys);
        SecurityTestUtil.addExpectedExceptions(expectedExceptions, system.getLogWriter());
        return dsys;
    }

    void openCache() {
        SecurityTestUtil.assertNotNull((Object)system);
        SecurityTestUtil.assertTrue((boolean)system.isConnected());
        cache = CacheFactory.create((DistributedSystem)system);
        SecurityTestUtil.assertNotNull((Object)cache);
    }

    private static void initClientDynamicRegionFactory(String poolName) {
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(null, poolName, false, true));
    }

    public static void initDynamicRegionFactory() {
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(null, null, false));
    }

    public static Integer getLocatorPort() {
        Integer locatorPort = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        String addr = DistributedTestCase.getIPLiteral();
        locatorString = locatorString == null ? addr + "[" + locatorPort + ']' : locatorString + "," + addr + "[" + locatorPort + ']';
        return locatorPort;
    }

    public static String getLocatorString() {
        String locString = locatorString;
        locatorString = null;
        return locString;
    }

    public static Integer getMcastPort() {
        if (mcastPort == null) {
            mcastPort = new Integer(AvailablePort.getRandomAvailablePort((int)1));
        }
        return mcastPort;
    }

    public static Properties concatProperties(Properties[] propsList) {
        Properties props = new Properties();
        for (int index = 0; index < propsList.length; ++index) {
            if (propsList[index] == null) continue;
            props.putAll((Map<?, ?>)propsList[index]);
        }
        return props;
    }

    public static void registerExpectedExceptions(String[] expectedExceptions) {
        SecurityTestUtil.expectedExceptions = expectedExceptions;
    }

    private static void addJavaProperties(Properties javaProps) {
        if (javaProps != null) {
            for (Map.Entry<Object, Object> entry : javaProps.entrySet()) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static void removeJavaProperties(Properties javaProps) {
        if (javaProps != null) {
            Properties props = System.getProperties();
            Iterator<Object> iter = javaProps.keySet().iterator();
            while (iter.hasNext()) {
                props.remove(iter.next());
            }
            System.setProperties(props);
        }
    }

    public static Integer createCacheServer(Properties authProps, Object javaProps, Integer dsPort, String locatorString, Integer serverPort, Integer expectedResult) {
        return SecurityTestUtil.createCacheServer(authProps, javaProps, dsPort, locatorString, serverPort, Boolean.FALSE, expectedResult);
    }

    public static Integer createCacheServer(Properties authProps, Object javaProps, Integer dsPort, String locatorString, Integer serverPort, Boolean setupDynamicRegionFactory, Integer expectedResult) {
        if (authProps == null) {
            authProps = new Properties();
        }
        if (locatorString != null && locatorString.length() > 0) {
            authProps.setProperty("mcast-port", "0");
            authProps.setProperty("locators", locatorString);
            if (dsPort != null) {
                authProps.setProperty("start-locator", DistributedTestCase.getIPLiteral() + "[" + dsPort.toString() + ']');
            }
        } else {
            authProps.setProperty("mcast-port", dsPort.toString());
            authProps.setProperty("locators", "");
        }
        authProps.setProperty("security-log-level", "finest");
        SecurityTestUtil.getLogWriter().info("Set the server properties to: " + authProps);
        SecurityTestUtil.getLogWriter().info("Set the java properties to: " + javaProps);
        SecurityTestUtil tmpInstance = new SecurityTestUtil("temp");
        try {
            tmpInstance.createSystem(authProps, (Properties)javaProps);
            if (expectedResult != 0) {
                SecurityTestUtil.fail((String)"Expected a security exception when starting peer");
            }
        }
        catch (AuthenticationRequiredException ex) {
            if (expectedResult == 1) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting peer: " + (Object)((Object)ex));
                return new Integer(0);
            }
            SecurityTestUtil.fail("Got unexpected exception when starting peer", ex);
        }
        catch (AuthenticationFailedException ex) {
            if (expectedResult == 2) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting peer: " + (Object)((Object)ex));
                return new Integer(0);
            }
            SecurityTestUtil.fail("Got unexpected exception when starting peer", ex);
        }
        catch (Exception ex) {
            SecurityTestUtil.fail("Got unexpected exception when starting peer", ex);
        }
        if (setupDynamicRegionFactory.booleanValue()) {
            SecurityTestUtil.initDynamicRegionFactory();
        }
        tmpInstance.openCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        int port = serverPort == null || serverPort <= 0 ? AvailablePort.getRandomAvailablePort((int)0) : serverPort;
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        try {
            server1.start();
        }
        catch (Exception ex) {
            SecurityTestUtil.fail("Got unexpected exception when starting BridgeServer", ex);
        }
        return new Integer(server1.getPort());
    }

    public static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, Integer[] ports, Object numConnections, Integer expectedResult) {
        SecurityTestUtil.createCacheClient(authInitModule, authProps, javaProps, ports, numConnections, "false", expectedResult);
    }

    public static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, Integer[] ports, Object numConnections, String multiUserMode, Integer expectedResult) {
        SecurityTestUtil.createCacheClient(authInitModule, authProps, javaProps, ports, (Integer)numConnections, Boolean.FALSE, multiUserMode, expectedResult);
    }

    public static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, Integer[] ports, Integer numConnections, Boolean setupDynamicRegionFactory, Integer expectedResult) {
        SecurityTestUtil.createCacheClient(authInitModule, authProps, javaProps, ports, numConnections, setupDynamicRegionFactory, "false", expectedResult);
    }

    public static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, Integer[] ports, Integer numConnections, Boolean setupDynamicRegionFactory, String multiUserMode, Integer expectedResult) {
        SecurityTestUtil.createCacheClient(authInitModule, authProps, javaProps, ports, numConnections, setupDynamicRegionFactory, multiUserMode, Boolean.TRUE, expectedResult);
    }

    public static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, Integer[] ports, Integer numConnections, Boolean setupDynamicRegionFactory, String multiUserMode, Boolean subscriptionEnabled, Integer expectedResult) {
        multiUserAuthMode = Boolean.valueOf(multiUserMode);
        if (authProps == null) {
            authProps = new Properties();
        }
        authProps.setProperty("mcast-port", "0");
        authProps.setProperty("locators", "");
        authProps.setProperty("security-log-level", "finest");
        if (authInitModule != null) {
            authProps.setProperty("security-client-auth-init", authInitModule);
        }
        SecurityTestUtil tmpInstance = new SecurityTestUtil("temp");
        tmpInstance.createSystem(authProps, javaProps);
        AttributesFactory factory = new AttributesFactory();
        int[] portsI = new int[ports.length];
        for (int z = 0; z < ports.length; ++z) {
            portsI[z] = ports[z];
        }
        try {
            PoolFactory poolFactory = PoolManager.createFactory();
            poolFactory.setRetryAttempts(200);
            if (multiUserAuthMode) {
                poolFactory.setMultiuserAuthentication(multiUserAuthMode);
            }
            pool = BridgeTestCase.configureConnectionPoolWithNameAndFactory(factory, DistributedTestCase.getIPLiteral(), portsI, subscriptionEnabled, 0, numConnections == null ? -1 : numConnections, null, null, poolFactory);
            if (setupDynamicRegionFactory.booleanValue()) {
                SecurityTestUtil.initClientDynamicRegionFactory(pool.getName());
            }
            tmpInstance.openCache();
            try {
                SecurityTestUtil.getLogWriter().info("multi-user mode " + multiUserAuthMode);
                SecurityTestUtil.proxyCaches[0] = (ProxyCache)((PoolImpl)pool).createAuthenticatedCacheView(authProps);
                if (!multiUserAuthMode) {
                    SecurityTestUtil.fail((String)"Expected a UnsupportedOperationException but got none in single-user mode");
                }
            }
            catch (UnsupportedOperationException uoe) {
                if (!multiUserAuthMode) {
                    SecurityTestUtil.getLogWriter().info("Got expected UnsupportedOperationException in single-user mode");
                }
                SecurityTestUtil.fail("Got unexpected exception in multi-user mode ", uoe);
            }
            factory.setScope(Scope.LOCAL);
            if (multiUserAuthMode) {
                factory.setDataPolicy(DataPolicy.EMPTY);
            }
            RegionAttributes attrs = factory.create();
            cache.createRegion(regionName, attrs);
            if (expectedResult != 0 && expectedResult != 16 && !multiUserAuthMode) {
                SecurityTestUtil.fail((String)"Expected an exception when starting client");
            }
        }
        catch (AuthenticationRequiredException ex) {
            if (expectedResult == 1 || expectedResult == 16) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (AuthenticationFailedException ex) {
            if (expectedResult == 2) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (ServerRefusedConnectionException ex) {
            if (expectedResult == 3) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (Exception ex) {
            SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
        }
    }

    public static void createCacheClientForMultiUserMode(Integer numOfUsers, String authInitModule, Properties[] authProps, Properties javaProps, Integer[] ports, Integer numConnections, Boolean setupDynamicRegionFactory, Integer expectedResult) {
        SecurityTestUtil.createCacheClientForMultiUserMode(numOfUsers, authInitModule, authProps, javaProps, ports, numConnections, setupDynamicRegionFactory, null, expectedResult);
    }

    public static void createCacheClientForMultiUserMode(Integer numOfUsers, String authInitModule, Properties[] authProps, Properties javaProps, Integer[] ports, Integer numConnections, Boolean setupDynamicRegionFactory, String durableClientId, Integer expectedResult) {
        if (numOfUsers == null || numOfUsers < 1) {
            SecurityTestUtil.fail((String)"Number of users cannot be less than one");
        }
        multiUserAuthMode = true;
        if (numOfUsers != authProps.length) {
            SecurityTestUtil.fail((String)("Number of authProps provided does not match with numOfUsers specified, " + authProps.length));
        }
        if (authProps[0] == null) {
            authProps[0] = new Properties();
        }
        authProps[0].setProperty("mcast-port", "0");
        authProps[0].setProperty("locators", "");
        authProps[0].setProperty("security-log-level", "finest");
        Properties props = new Properties();
        if (authInitModule != null) {
            authProps[0].setProperty("security-client-auth-init", authInitModule);
            props.setProperty("security-client-auth-init", authInitModule);
        }
        if (durableClientId != null) {
            props.setProperty("durable-client-id", durableClientId);
            props.setProperty("durable-client-timeout", String.valueOf(300));
        }
        SecurityTestUtil tmpInstance = new SecurityTestUtil("temp");
        tmpInstance.createSystem(props, javaProps);
        AttributesFactory factory = new AttributesFactory();
        int[] portsI = new int[ports.length];
        for (int z = 0; z < ports.length; ++z) {
            portsI[z] = ports[z];
        }
        try {
            tmpInstance.openCache();
            PoolFactory poolFactory = PoolManager.createFactory();
            poolFactory.setRetryAttempts(200);
            poolFactory.setMultiuserAuthentication(multiUserAuthMode);
            poolFactory.setSubscriptionEnabled(true);
            pool = BridgeTestCase.configureConnectionPoolWithNameAndFactory(factory, DistributedTestCase.getIPLiteral(), portsI, true, 1, numConnections == null ? -1 : numConnections, null, null, poolFactory);
            if (setupDynamicRegionFactory.booleanValue()) {
                SecurityTestUtil.initClientDynamicRegionFactory(pool.getName());
            }
            proxyCaches = new ProxyCache[numOfUsers.intValue()];
            for (int i = 0; i < numOfUsers; ++i) {
                SecurityTestUtil.proxyCaches[i] = (ProxyCache)((PoolImpl)pool).createAuthenticatedCacheView(authProps[i]);
            }
            factory.setScope(Scope.LOCAL);
            factory.setDataPolicy(DataPolicy.EMPTY);
            RegionAttributes attrs = factory.create();
            cache.createRegion(regionName, attrs);
            if (expectedResult != 0 && expectedResult != 16 && !multiUserAuthMode) {
                SecurityTestUtil.fail((String)"Expected an exception when starting client");
            }
        }
        catch (AuthenticationRequiredException ex) {
            if (expectedResult == 1 || expectedResult == 16) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (AuthenticationFailedException ex) {
            if (expectedResult == 2) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (ServerRefusedConnectionException ex) {
            if (expectedResult == 3) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (Exception ex) {
            SecurityTestUtil.fail("Got unexpected exception when starting client", ex);
        }
    }

    public static void createProxyCache(Integer[] userIndices, Properties[] props) {
        int j = 0;
        Integer[] arr$ = userIndices;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            SecurityTestUtil.proxyCaches[i] = (ProxyCache)((PoolImpl)pool).createAuthenticatedCacheView(props[j]);
            ++j;
        }
    }

    public static void stopCacheServers() {
        Iterator iter = SecurityTestUtil.getCache().getBridgeServers().iterator();
        if (iter.hasNext()) {
            BridgeServer server = (BridgeServer)iter.next();
            server.stop();
            SecurityTestUtil.assertFalse((boolean)server.isRunning());
        }
    }

    public static void restartCacheServers() {
        Iterator iter = SecurityTestUtil.getCache().getBridgeServers().iterator();
        if (iter.hasNext()) {
            BridgeServer server = (BridgeServer)iter.next();
            try {
                server.start();
            }
            catch (Exception ex) {
                SecurityTestUtil.fail("Unexpected exception when restarting cache servers", ex);
            }
            SecurityTestUtil.assertTrue((boolean)server.isRunning());
        }
    }

    public static void startLocator(String name, Integer port, Object extraProps, Object javaProps, String[] expectedExceptions) {
        File logFile = new File(name + "-locator" + port + ".log");
        try {
            Properties authProps = new Properties();
            if (extraProps != null) {
                authProps.putAll((Map<?, ?>)((Properties)extraProps));
            }
            authProps.setProperty("mcast-port", "0");
            authProps.setProperty("locators", DistributedTestCase.getIPLiteral() + "[" + port + "]");
            SecurityTestUtil.clearStaticSSLContext();
            SecurityTestUtil.setJavaProps((Properties)javaProps);
            FileOutputStream logOut = new FileOutputStream(logFile);
            PrintStream logStream = new PrintStream(logOut);
            PureLogWriter logger = new PureLogWriter(700, logStream);
            SecurityTestUtil.addExpectedExceptions(expectedExceptions, (LogWriter)logger);
            logStream.flush();
            locator = Locator.startLocatorAndDS((int)port, (File)logFile, null, (Properties)authProps);
        }
        catch (IOException ex) {
            SecurityTestUtil.fail("While starting locator on port " + port, ex);
        }
    }

    public static void stopLocator(Integer port, String[] expectedExceptions) {
        try {
            if (locator != null) {
                locator.stop();
                SecurityTestUtil.removeExpectedExceptions(expectedExceptions, locator.getDistributedSystem().getLogWriter());
            }
        }
        catch (Exception ex) {
            SecurityTestUtil.fail("While stopping locator on port " + port, ex);
        }
    }

    public static List getAllGenerators() {
        ArrayList<CredentialGenerator> generators = new ArrayList<CredentialGenerator>();
        Iterator codeIter = CredentialGenerator.ClassCode.getAll().iterator();
        while (codeIter.hasNext()) {
            CredentialGenerator gen = CredentialGenerator.create((CredentialGenerator.ClassCode)codeIter.next());
            if (gen == null) continue;
            gen.init();
            generators.add(gen);
        }
        return generators;
    }

    public static Cache getCache() {
        return cache;
    }

    public static void waitForCondition(Callable cond) {
        SecurityTestUtil.waitForCondition(cond, 100, 120);
    }

    public static void waitForCondition(final Callable cond, int sleepMillis, int numTries) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    return (Boolean)cond.call();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Unexpected exception", e);
                    return false;
                }
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, sleepMillis * numTries, 200L, true);
    }

    public static Object getLocalValue(Region region, Object key) {
        Region.Entry entry = region.getEntry(key);
        return entry != null ? entry.getValue() : null;
    }

    public static void doProxyCacheClose() {
        for (int i = 0; i < proxyCaches.length; ++i) {
            proxyCaches[i].close();
        }
    }

    private static void doPutsP(Integer num, Integer expectedResult, boolean newVals) {
        SecurityTestUtil.doPutsP(num, 0, expectedResult, newVals);
    }

    private static void doPutsP(Integer num, Integer multiUserIndex, Integer expectedResult, boolean newVals) {
        SecurityTestUtil.assertTrue((num <= keys.length ? 1 : 0) != 0);
        Region region = null;
        try {
            if (multiUserAuthMode) {
                regionRef = region = proxyCaches[multiUserIndex].getRegion(regionName);
            } else {
                region = SecurityTestUtil.getCache().getRegion(regionName);
            }
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing puts: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing puts", ex);
        }
        for (int index = 0; index < num; ++index) {
            try {
                if (newVals) {
                    region.put((Object)keys[index], (Object)nvalues[index]);
                } else {
                    region.put((Object)keys[index], (Object)values[index]);
                }
                if (expectedResult == 0) continue;
                SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while doing puts");
                continue;
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing puts: " + ex.getCause());
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing puts", ex);
                continue;
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 1 && ex.getCause() instanceof AuthenticationRequiredException) {
                    SecurityTestUtil.getLogWriter().info("Got expected AuthenticationRequiredException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 2 && ex.getCause() instanceof AuthenticationFailedException) {
                    SecurityTestUtil.getLogWriter().info("Got expected AuthenticationFailedException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing puts: " + (Object)((Object)ex));
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing puts", ex);
                continue;
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing puts: " + ex);
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing puts", ex);
            }
        }
    }

    private static void doGetAllP(Integer multiUserIndex, Integer expectedResult) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing getAll: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing getAll", ex);
        }
        try {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("key1");
            keys.add("key2");
            Map entries = region.getAll(keys);
            SecurityTestUtil.assertNotNull((Object)entries);
            if (expectedResult == 4) {
                SecurityTestUtil.assertEquals((int)0, (int)entries.size());
            } else if (expectedResult == 0) {
                SecurityTestUtil.assertEquals((int)2, (int)entries.size());
                SecurityTestUtil.assertEquals((Object)"value1", entries.get("key1"));
                SecurityTestUtil.assertEquals((Object)"value2", entries.get("key2"));
            }
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing getAll: " + ex.getCause());
            } else {
                SecurityTestUtil.fail("Got unexpected exception when doing getAll", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing getAll: " + ex.getCause());
            } else if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing getAll: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when doing getAll", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing getAll: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing getAll", ex);
        }
    }

    private static void doGetsP(Integer num, Integer expectedResult, boolean newVals) {
        SecurityTestUtil.doGetsP(num, 0, expectedResult, newVals);
    }

    private static void doGetsP(Integer num, Integer multiUserIndex, Integer expectedResult, boolean newVals) {
        SecurityTestUtil.assertTrue((num <= keys.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing gets: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing gets", ex);
        }
        for (int index = 0; index < num; ++index) {
            Object value = null;
            try {
                try {
                    region.localInvalidate((Object)keys[index]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                value = region.get((Object)keys[index]);
                if (expectedResult != 0) {
                    SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while doing gets");
                }
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing gets: " + ex.getCause());
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing gets", ex);
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing gets: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing gets: " + (Object)((Object)ex));
                } else {
                    SecurityTestUtil.fail("Got unexpected exception when doing gets", ex);
                }
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing gets: " + ex);
                }
                SecurityTestUtil.fail("Got unexpected exception when doing gets", ex);
            }
            SecurityTestUtil.assertNotNull((Object)value);
            if (newVals) {
                SecurityTestUtil.assertEquals((Object)nvalues[index], (Object)value);
                continue;
            }
            SecurityTestUtil.assertEquals((Object)values[index], (Object)value);
        }
    }

    private static void doLocalGetsP(int num, boolean checkNVals) {
        int index;
        SecurityTestUtil.assertTrue((num <= keys.length ? 1 : 0) != 0);
        String[] vals = values;
        if (checkNVals) {
            vals = nvalues;
        }
        final Region region = SecurityTestUtil.getCache().getRegion(regionName);
        SecurityTestUtil.assertNotNull((Object)region);
        for (index = 0; index < num; ++index) {
            final String key = keys[index];
            final String expectedVal = vals[index];
            SecurityTestUtil.waitForCondition(new Callable(){

                public Object call() throws Exception {
                    Object value = SecurityTestUtil.getLocalValue(region, key);
                    return expectedVal.equals(value);
                }
            }, 1000, 30 / num);
        }
        for (index = 0; index < num; ++index) {
            Region.Entry entry = region.getEntry((Object)keys[index]);
            SecurityTestUtil.assertNotNull((Object)entry);
            SecurityTestUtil.assertEquals((Object)vals[index], (Object)entry.getValue());
        }
    }

    private static void doRegionDestroysP(Integer multiuserIndex, Integer expectedResult) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiuserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing region destroy: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing region destroy", ex);
        }
        try {
            region.destroyRegion();
            if (expectedResult != 0) {
                SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while doing region destroy");
            }
            region = multiUserAuthMode ? proxyCaches[multiuserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNull((Object)region);
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing region destroy: " + ex.getCause());
            } else {
                SecurityTestUtil.fail("Got unexpected exception when doing region destroy", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing region destroy: " + ex.getCause());
            } else if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing region destroy: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when doing region destroy", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing region destroy: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing region destroy", ex);
        }
    }

    private static void doDestroysP(Integer num, Integer multiUserIndex, Integer expectedResult, boolean newVals) {
        SecurityTestUtil.assertTrue((num <= keys.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing destroys: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing destroys", ex);
        }
        for (int index = 0; index < num; ++index) {
            try {
                region.destroy((Object)keys[index]);
                if (expectedResult == 0) continue;
                SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while doing destroys");
                continue;
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing destroys: " + ex.getCause());
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing destroys", ex);
                continue;
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing destroys: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing destroys: " + (Object)((Object)ex));
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing destroys", ex);
                continue;
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing destroys: " + ex);
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing destroys", ex);
            }
        }
    }

    private static void doInvalidatesP(Integer num, Integer multiUserIndex, Integer expectedResult, boolean newVals) {
        SecurityTestUtil.assertTrue((num <= keys.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing invalidates: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing invalidates", ex);
        }
        for (int index = 0; index < num; ++index) {
            try {
                region.invalidate((Object)keys[index]);
                if (expectedResult == 0) continue;
                SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while doing invalidates");
                continue;
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing invalidates: " + ex.getCause());
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing invalidates", ex);
                continue;
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing invalidates: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing invalidates: " + (Object)((Object)ex));
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing invalidates", ex);
                continue;
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing invalidates: " + ex);
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing invalidates", ex);
            }
        }
    }

    private static void doContainsKeysP(Integer num, Integer multiUserIndex, Integer expectedResult, boolean newVals, boolean expectedValue) {
        SecurityTestUtil.assertTrue((num <= keys.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing containsKey: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing containsKey", ex);
        }
        for (int index = 0; index < num; ++index) {
            boolean result = false;
            try {
                result = region.containsKeyOnServer((Object)keys[index]);
                if (expectedResult != 0) {
                    SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while doing containsKey");
                }
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing containsKey: " + ex.getCause());
                    continue;
                }
                SecurityTestUtil.fail("Got unexpected exception when doing containsKey", ex);
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing containsKey: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing containsKey: " + (Object)((Object)ex));
                } else {
                    SecurityTestUtil.fail("Got unexpected exception when doing containsKey", ex);
                }
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    SecurityTestUtil.getLogWriter().info("Got expected exception when doing containsKey: " + ex);
                }
                SecurityTestUtil.fail("Got unexpected exception when doing containsKey", ex);
            }
            SecurityTestUtil.assertEquals((boolean)expectedValue, (boolean)result);
        }
    }

    private static void doQueriesP(Integer multiUserIndex, Integer expectedResult, Integer expectedValue) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing queries: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing queries", ex);
        }
        String queryStr = "SELECT DISTINCT * FROM " + region.getFullPath();
        try {
            SelectResults queryResults = region.query(queryStr);
            Set resultSet = queryResults.asSet();
            SecurityTestUtil.assertEquals((int)expectedValue, (int)resultSet.size());
            if (expectedResult != 0) {
                SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while doing queries");
            }
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when doing queries: " + ex.getCause());
            } else {
                SecurityTestUtil.fail("Got unexpected exception when doing queries", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing queries: " + ex.getCause());
            } else if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing queries: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when doing queries", ex);
            }
        }
        catch (QueryInvocationTargetException qite) {
            if (expectedResult == 4 && qite.getCause() instanceof NotAuthorizedException) {
                SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when doing queries: " + qite.getCause());
            } else if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing queries: " + (Object)((Object)qite));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when doing queries", qite);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when doing queries: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when doing queries", ex);
        }
    }

    private static void doFunctionExecuteP(Integer multiUserIndex, Function function, Integer expectedResult, Object expectedValue, String method) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when executing function: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when executing function", ex);
        }
        try {
            FunctionService.registerFunction((Function)function);
            Execution execution = null;
            execution = "region".equals(method) ? FunctionService.onRegion((Region)region) : ("server".equals(method) ? (multiUserAuthMode ? FunctionService.onServer((RegionService)proxyCaches[multiUserIndex]) : FunctionService.onServer((Pool)pool)) : (multiUserAuthMode ? FunctionService.onServers((RegionService)proxyCaches[multiUserIndex]) : FunctionService.onServers((Pool)pool)));
            execution.execute(function.getId());
            if (expectedResult != 0) {
                SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while executing function");
            }
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when executing function: " + ex.getCause());
            } else {
                SecurityTestUtil.fail("Got unexpected exception when executing function", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when executing function: " + ex.getCause());
            } else if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when executing function: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when executing function", ex);
            }
        }
        catch (FunctionException ex) {
            if (expectedResult == 4 && (ex.getCause() instanceof NotAuthorizedException || ex.getCause() instanceof ServerOperationException && ((ServerOperationException)ex.getCause()).getCause() instanceof NotAuthorizedException)) {
                SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when executing function: " + ex.getCause());
            } else if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when executing function: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when executing function", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when executing function: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when executing function", ex);
        }
    }

    private static void doQueryExecuteP(Integer multiUserIndex, Integer expectedResult, Integer expectedValue) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(regionName) : SecurityTestUtil.getCache().getRegion(regionName);
            SecurityTestUtil.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when executing query: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when executing query", ex);
        }
        try {
            String queryString = "SELECT DISTINCT * FROM " + region.getFullPath();
            Query query = null;
            if (multiUserAuthMode) {
                query = proxyCaches[multiUserIndex].getQueryService().newQuery(queryString);
            } else {
                region.getCache().getQueryService().newQuery(queryString);
            }
            SelectResults result = (SelectResults)query.execute();
            if (expectedResult != 0) {
                SecurityTestUtil.fail((String)"Expected a NotAuthorizedException while executing function");
            }
            SecurityTestUtil.assertEquals((int)expectedValue, (int)result.asList().size());
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                SecurityTestUtil.getLogWriter().info("Got expected NoAvailableServers when executing query: " + ex.getCause());
            } else {
                SecurityTestUtil.fail("Got unexpected exception when executing query", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                SecurityTestUtil.getLogWriter().info("Got expected NotAuthorizedException when executing query: " + ex.getCause());
            } else if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when executing query: " + (Object)((Object)ex));
            } else {
                SecurityTestUtil.fail("Got unexpected exception when executing query", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                SecurityTestUtil.getLogWriter().info("Got expected exception when executing query: " + ex);
            }
            SecurityTestUtil.fail("Got unexpected exception when executing query", ex);
        }
    }

    public static void doPuts(Integer num) {
        SecurityTestUtil.doPutsP(num, new Integer(0), false);
    }

    public static void doPuts(Integer num, Integer expectedResult) {
        SecurityTestUtil.doPutsP(num, expectedResult, false);
    }

    public static void doMultiUserPuts(Integer num, Integer numOfUsers, Integer[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserPuts(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("PUT: MultiUser# " + i);
            SecurityTestUtil.doPutsP(num, i, expectedResults[i], false);
        }
    }

    public static void doGets(Integer num) {
        SecurityTestUtil.doGetsP(num, new Integer(0), false);
    }

    public static void doGets(Integer num, Integer expectedResult) {
        SecurityTestUtil.doGetsP(num, expectedResult, false);
    }

    public static void doMultiUserGetAll(Integer numOfUsers, Integer[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserGetAll(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("GET_ALL: MultiUser# " + i);
            SecurityTestUtil.doGetAllP(i, expectedResults[i]);
        }
    }

    public static void doMultiUserGets(Integer num, Integer numOfUsers, Integer[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserGets(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("GET: MultiUser# " + i);
            SecurityTestUtil.doGetsP(num, i, expectedResults[i], false);
        }
    }

    public static void doMultiUserRegionDestroys(Integer numOfUsers, Integer[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserRegionDestroys(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = numOfUsers - 1; i >= 0; --i) {
            SecurityTestUtil.getLogWriter().info("DESTROY: MultiUser# " + i);
            SecurityTestUtil.doRegionDestroysP(i, expectedResults[i]);
        }
    }

    public static void doMultiUserDestroys(Integer num, Integer numOfUsers, Integer[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserDestroys(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("DESTROY: MultiUser# " + i);
            SecurityTestUtil.doDestroysP(num, i, expectedResults[i], false);
        }
    }

    public static void doMultiUserInvalidates(Integer num, Integer numOfUsers, Integer[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserInvalidates(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("INVALIDATE: MultiUser# " + i);
            SecurityTestUtil.doInvalidatesP(num, i, expectedResults[i], false);
        }
    }

    public static void doMultiUserContainsKeys(Integer num, Integer numOfUsers, Integer[] expectedResults, Boolean[] results) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserContainsKeys(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        if (numOfUsers != results.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserContainsKeys(): numOfUsers = " + numOfUsers + ", but #expected output " + results.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("CONTAINS_KEY: MultiUser# " + i);
            SecurityTestUtil.doContainsKeysP(num, i, expectedResults[i], false, results[i]);
        }
    }

    public static void doMultiUserQueries(Integer numOfUsers, Integer[] expectedResults, Integer valueSize) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserQueries(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("QUERY: MultiUser# " + i);
            SecurityTestUtil.doQueriesP(i, expectedResults[i], valueSize);
        }
    }

    public static void doMultiUserFE(Integer numOfUsers, Function function, Integer[] expectedResults, Object[] results, Boolean isFailoverCase) {
        int i;
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserFE(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        if (numOfUsers != results.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserFE(): numOfUsers = " + numOfUsers + ", but #expected output " + results.length));
        }
        for (i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("FunctionExecute:onRegion MultiUser# " + i);
            SecurityTestUtil.doFunctionExecuteP(i, function, expectedResults[i], results[i], "region");
        }
        for (i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("FunctionExecute:onServer MultiUser# " + i);
            SecurityTestUtil.doFunctionExecuteP(i, function, expectedResults[i], results[i], "server");
        }
        if (!isFailoverCase.booleanValue()) {
            for (i = 0; i < numOfUsers; ++i) {
                SecurityTestUtil.getLogWriter().info("FunctionExecute:onServers MultiUser# " + i);
                SecurityTestUtil.doFunctionExecuteP(i, function, expectedResults[i], results[i], "servers");
            }
        }
    }

    public static void doMultiUserQueryExecute(Integer numOfUsers, Integer[] expectedResults, Integer result) {
        if (numOfUsers != expectedResults.length) {
            SecurityTestUtil.fail((String)("SecurityTestUtil.doMultiUserFE(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            SecurityTestUtil.getLogWriter().info("QueryExecute: MultiUser# " + i);
            SecurityTestUtil.doQueryExecuteP(i, expectedResults[i], result);
        }
    }

    public static void doLocalGets(Integer num) {
        SecurityTestUtil.doLocalGetsP(num, false);
    }

    public static void doNPuts(Integer num) {
        SecurityTestUtil.doPutsP(num, new Integer(0), true);
    }

    public static void doNPuts(Integer num, Integer expectedResult) {
        SecurityTestUtil.doPutsP(num, expectedResult, true);
    }

    public static void doNGets(Integer num) {
        SecurityTestUtil.doGetsP(num, new Integer(0), true);
    }

    public static void doNGets(Integer num, Integer expectedResult) {
        SecurityTestUtil.doGetsP(num, expectedResult, true);
    }

    public static void doNLocalGets(Integer num) {
        SecurityTestUtil.doLocalGetsP(num, true);
    }

    public static void doSimpleGet(String expectedResult) {
        if (regionRef != null) {
            try {
                regionRef.get((Object)"KEY");
                if (expectedResult != null && expectedResult.endsWith("Exception")) {
                    SecurityTestUtil.fail((String)("Expected " + expectedResult + " but found none in doSimpleGet()"));
                }
            }
            catch (Exception e) {
                if (!e.getClass().getSimpleName().endsWith(expectedResult)) {
                    SecurityTestUtil.fail((String)("Expected " + expectedResult + " but found " + e.getClass().getSimpleName() + " in doSimpleGet()"));
                }
                Log.getLogWriter().fine("Got expected " + e.getClass().getSimpleName() + " in doSimpleGet()");
            }
        }
    }

    public static void doSimplePut(String expectedResult) {
        if (regionRef != null) {
            try {
                regionRef.put((Object)"KEY", (Object)"VALUE");
                if (expectedResult != null && expectedResult.endsWith("Exception")) {
                    SecurityTestUtil.fail((String)("Expected " + expectedResult + " but found none in doSimplePut()"));
                }
            }
            catch (Exception e) {
                if (!e.getClass().getSimpleName().endsWith(expectedResult)) {
                    SecurityTestUtil.fail("Expected " + expectedResult + " but found " + e.getClass().getSimpleName() + " in doSimplePut()", e);
                }
                Log.getLogWriter().fine("Got expected " + e.getClass().getSimpleName() + " in doSimplePut()");
            }
        }
    }

    private static void makeNullStaticField(Class cls) {
        Field[] fields = cls.getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            try {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                if (field.getClass().equals(Boolean.TYPE)) {
                    field.setBoolean(null, false);
                    SecurityTestUtil.assertFalse((boolean)field.getBoolean(null));
                    continue;
                }
                if (!cls.isInstance(field.get(null))) continue;
                field.set(null, null);
                SecurityTestUtil.assertNull((Object)field.get(null));
                continue;
            }
            catch (IllegalAccessException ex) {
                SecurityTestUtil.getLogWriter().warning("Exception while clearing static SSL field.", (Throwable)ex);
                continue;
            }
            catch (ClassCastException ex) {
                SecurityTestUtil.getLogWriter().warning("Exception while clearing static SSL field.", (Throwable)ex);
            }
        }
    }

    private static void makeNullSSLFields(Object obj, Map fieldMap) {
        for (Map.Entry entry : fieldMap.entrySet()) {
            Field field = (Field)entry.getKey();
            Object fieldObj = entry.getValue();
            try {
                field.setAccessible(true);
                SecurityTestUtil.makeNullStaticField(fieldObj.getClass());
                field.set(obj, null);
                SecurityTestUtil.assertNull((Object)field.get(obj));
            }
            catch (IllegalAccessException ex) {
                SecurityTestUtil.getLogWriter().warning("Exception while clearing SSL fields.", (Throwable)ex);
            }
        }
    }

    private static HashMap getSSLFields(Object obj, Class[] classes) {
        HashMap<Field, Object> resultFields = new HashMap<Field, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            try {
                field.setAccessible(true);
                Object fieldObj = field.get(obj);
                boolean isInstance = false;
                for (int classIndex = 0; classIndex < classes.length && !(isInstance = classes[classIndex].isInstance(fieldObj)); ++classIndex) {
                }
                if (!isInstance) continue;
                resultFields.put(field, fieldObj);
                continue;
            }
            catch (IllegalAccessException ex) {
                SecurityTestUtil.getLogWriter().warning("Exception while getting SSL fields.", (Throwable)ex);
            }
        }
        return resultFields;
    }

    public static void clearStaticSSLContext() {
        ServerSocketFactory defaultServerFact = SSLServerSocketFactory.getDefault();
        HashMap contextMap = SecurityTestUtil.getSSLFields(defaultServerFact, new Class[]{SSLContext.class, SSLContextSpi.class});
        SecurityTestUtil.makeNullSSLFields(defaultServerFact, contextMap);
        for (Object contextObj : contextMap.values()) {
            HashMap contextObjsMap = SecurityTestUtil.getSSLFields(contextObj, new Class[]{TrustManager.class, KeyManager.class, TrustManager[].class, KeyManager[].class});
            SecurityTestUtil.makeNullSSLFields(contextObj, contextObjsMap);
        }
        SecurityTestUtil.makeNullStaticField(SSLServerSocketFactory.class);
        SocketFactory defaultFact = SSLSocketFactory.getDefault();
        contextMap = SecurityTestUtil.getSSLFields(defaultFact, new Class[]{SSLContext.class, SSLContextSpi.class});
        SecurityTestUtil.makeNullSSLFields(defaultFact, contextMap);
        for (Object contextObj : contextMap.values()) {
            HashMap contextObjsMap = SecurityTestUtil.getSSLFields(contextObj, new Class[]{TrustManager.class, KeyManager.class, TrustManager[].class, KeyManager[].class});
            SecurityTestUtil.makeNullSSLFields(contextObj, contextObjsMap);
        }
        SecurityTestUtil.makeNullStaticField(SSLSocketFactory.class);
        SecurityTestUtil.makeNullStaticField(SSLContext.class);
    }

    private static LogWriter getLogger() {
        LogWriter logger = null;
        InternalDistributedSystem dsys = system;
        if (dsys == null || !dsys.isConnected()) {
            while ((dsys = InternalDistributedSystem.getAnyInstance()) != null && !dsys.isConnected()) {
            }
        }
        if (dsys != null && dsys.isConnected()) {
            logger = dsys.getLogWriter();
        }
        return logger;
    }

    public static void closeCache() {
        LogWriter logger = SecurityTestUtil.getLogger();
        if (logger != null) {
            SecurityTestUtil.removeExpectedExceptions(expectedExceptions, logger);
        }
        if (cache != null && !cache.isClosed()) {
            DistributedSystem sys = cache.getDistributedSystem();
            cache.close();
            sys.disconnect();
            cache = null;
        }
        SecurityTestUtil.disconnectFromDS();
    }

    public static void closeCache(Boolean keepAlive) {
        LogWriter logger = SecurityTestUtil.getLogger();
        if (logger != null) {
            SecurityTestUtil.removeExpectedExceptions(expectedExceptions, logger);
        }
        if (cache != null && !cache.isClosed()) {
            DistributedSystem sys = cache.getDistributedSystem();
            cache.close(keepAlive.booleanValue());
            sys.disconnect();
            cache = null;
        }
        SecurityTestUtil.disconnectFromDS();
    }
}

