/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import security.CredentialGenerator;

public class WanAuthenticationDUnitTest
extends ClientAuthorizationTestBase {
    private static Locator locator = null;
    private static String site1 = "site1";
    private static String site2 = "site2";
    private VM locator1 = null;
    private VM server1 = null;
    private VM locator2 = null;
    private VM server2 = null;

    public WanAuthenticationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.locator1 = host.getVM(0);
        this.server1 = host.getVM(1);
        this.locator2 = host.getVM(2);
        this.server2 = host.getVM(3);
    }

    private static Properties buildProperties(String clientauthenticator, String clientAuthInit, String accessor, Properties extraAuthProps, Properties extraAuthzProps) {
        Properties authProps = new Properties();
        if (clientauthenticator != null) {
            authProps.setProperty("security-client-authenticator", clientauthenticator);
        }
        if (accessor != null) {
            authProps.setProperty("security-client-accessor", accessor);
        }
        if (clientAuthInit != null) {
            authProps.setProperty("security-client-auth-init", clientAuthInit);
        }
        if (extraAuthProps != null) {
            authProps.putAll((Map<?, ?>)extraAuthProps);
        }
        if (extraAuthzProps != null) {
            authProps.putAll((Map<?, ?>)extraAuthzProps);
        }
        return authProps;
    }

    public static void startLocator(String name, Integer port) {
        File logFile = new File(name + "-locator" + port + ".log");
        try {
            Properties props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", DistributedTestCase.getIPLiteral() + "[" + port + "]");
            locator = Locator.startLocatorAndDS((int)port, (File)logFile, null, (Properties)props);
        }
        catch (IOException ex) {
            WanAuthenticationDUnitTest.fail("While starting locator on port " + port, ex);
        }
    }

    public static void stopLocator() {
        try {
            locator.stop();
        }
        catch (Exception ex) {
            WanAuthenticationDUnitTest.fail("While stopping locator", ex);
        }
    }

    public static void setupHubAndAddGateway(String site, String hub, Integer hubEP, String gateway, Integer gatewayEP, Boolean expectException) {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            GatewayHub gatewayhub = cache.addGatewayHub(hub, hubEP.intValue());
            gatewayhub.setSocketBufferSize(25600);
            Gateway tmpgateway = gatewayhub.addGateway(gateway);
            WanAuthenticationDUnitTest.setDiskStoreForGateway(cache, gateway, tmpgateway.getQueueAttributes());
            tmpgateway.addEndpoint(site, DistributedTestCase.getIPLiteral(), gatewayEP.intValue());
            gatewayhub.start();
            tmpgateway.start();
            if (expectException.equals(Boolean.TRUE)) {
                WanAuthenticationDUnitTest.fail((String)"Exception was expected while starting the gateway hub and gateway");
            }
        }
        catch (Exception ex) {
            if (expectException.equals(Boolean.FALSE)) {
                WanAuthenticationDUnitTest.fail("While starting the gateway hub and gateway", ex);
            }
            WanAuthenticationDUnitTest.getLogWriter().info("setupHubAndAddGateway - was an expected exception, msg = " + ex.getMessage() + ", exception = " + expectException);
        }
    }

    public void testWanAuthValidCredentials() {
        WanAuthenticationDUnitTest.disconnectAllFromDS();
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        while (iter.hasNext()) {
            int mcastport1 = AvailablePort.getRandomAvailablePort((int)1);
            int mcastport2 = AvailablePort.getRandomAvailablePort((int)1);
            CredentialGenerator gen = (CredentialGenerator)iter.next();
            Properties extraProps = gen.getSystemProperties();
            String clientauthenticator = gen.getAuthenticator();
            String clientauthInit = gen.getAuthInit();
            Properties credentials1 = gen.getValidCredentials(1);
            if (extraProps != null) {
                credentials1.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps1 = gen.getJavaProperties();
            Properties credentials2 = gen.getValidCredentials(2);
            if (extraProps != null) {
                credentials2.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps2 = gen.getJavaProperties();
            Properties props1 = WanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials1, null);
            Properties props2 = WanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials2, null);
            int serverport1 = AvailablePort.getRandomAvailablePort((int)0);
            this.server1.invoke(SecurityTestUtil.class, "createCacheServer", new Object[]{props1, javaProps1, new Integer(mcastport1), "", new Integer(serverport1), new Integer(0)});
            int serverport2 = AvailablePort.getRandomAvailablePort((int)0);
            this.server2.invoke(SecurityTestUtil.class, "createCacheServer", new Object[]{props2, javaProps2, new Integer(mcastport2), "", new Integer(serverport2), new Integer(0)});
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.server1.invoke(WanAuthenticationDUnitTest.class, "setupHubAndAddGateway", new Object[]{site1, DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), Boolean.FALSE});
            this.server2.invoke(WanAuthenticationDUnitTest.class, "setupHubAndAddGateway", new Object[]{site2, DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), Boolean.FALSE});
        }
    }

    public void testWanAuthInvalidCredentials() {
        WanAuthenticationDUnitTest.disconnectAllFromDS();
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        while (iter.hasNext()) {
            int mcastport1 = AvailablePort.getRandomAvailablePort((int)1);
            int mcastport2 = AvailablePort.getRandomAvailablePort((int)1);
            CredentialGenerator gen = (CredentialGenerator)iter.next();
            Properties extraProps = gen.getSystemProperties();
            String clientauthenticator = gen.getAuthenticator();
            String clientauthInit = gen.getAuthInit();
            Properties credentials1 = gen.getInvalidCredentials(1);
            if (extraProps != null) {
                credentials1.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps1 = gen.getJavaProperties();
            Properties credentials2 = gen.getInvalidCredentials(2);
            if (extraProps != null) {
                credentials2.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps2 = gen.getJavaProperties();
            Properties props1 = WanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials1, null);
            Properties props2 = WanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials2, null);
            int serverport1 = AvailablePort.getRandomAvailablePort((int)0);
            this.server1.invoke(SecurityTestUtil.class, "createCacheServer", new Object[]{props1, javaProps1, new Integer(mcastport1), "", new Integer(serverport1), new Integer(0)});
            int serverport2 = AvailablePort.getRandomAvailablePort((int)0);
            this.server2.invoke(SecurityTestUtil.class, "createCacheServer", new Object[]{props2, javaProps2, new Integer(mcastport2), "", new Integer(serverport2), new Integer(0)});
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.server1.invoke(WanAuthenticationDUnitTest.class, "setupHubAndAddGateway", new Object[]{site1, DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), Boolean.FALSE});
            this.server2.invoke(WanAuthenticationDUnitTest.class, "setupHubAndAddGateway", new Object[]{site2, DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), Boolean.TRUE});
        }
    }

    public void testWanAuthFirstInvalidSecondValidCredentials() {
        WanAuthenticationDUnitTest.disconnectAllFromDS();
        Iterator iter = SecurityTestUtil.getAllGenerators().iterator();
        while (iter.hasNext()) {
            int mcastport1 = AvailablePort.getRandomAvailablePort((int)1);
            int mcastport2 = AvailablePort.getRandomAvailablePort((int)1);
            CredentialGenerator gen = (CredentialGenerator)iter.next();
            Properties extraProps = gen.getSystemProperties();
            String clientauthenticator = gen.getAuthenticator();
            String clientauthInit = gen.getAuthInit();
            Properties credentials1 = gen.getInvalidCredentials(1);
            if (extraProps != null) {
                credentials1.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps1 = gen.getJavaProperties();
            Properties credentials2 = gen.getValidCredentials(2);
            if (extraProps != null) {
                credentials2.putAll((Map<?, ?>)extraProps);
            }
            Properties javaProps2 = gen.getJavaProperties();
            Properties props1 = WanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials1, null);
            Properties props2 = WanAuthenticationDUnitTest.buildProperties(clientauthenticator, clientauthInit, null, credentials2, null);
            int serverport1 = AvailablePort.getRandomAvailablePort((int)0);
            this.server1.invoke(SecurityTestUtil.class, "createCacheServer", new Object[]{props1, javaProps1, new Integer(mcastport1), "", new Integer(serverport1), new Integer(0)});
            int serverport2 = AvailablePort.getRandomAvailablePort((int)0);
            this.server2.invoke(SecurityTestUtil.class, "createCacheServer", new Object[]{props2, javaProps2, new Integer(mcastport2), "", new Integer(serverport2), new Integer(0)});
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.server1.invoke(WanAuthenticationDUnitTest.class, "setupHubAndAddGateway", new Object[]{site1, DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), Boolean.FALSE});
            this.server2.invoke(WanAuthenticationDUnitTest.class, "setupHubAndAddGateway", new Object[]{site2, DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), Boolean.TRUE});
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.locator1.invoke(SecurityTestUtil.class, "closeCache");
        this.locator2.invoke(SecurityTestUtil.class, "closeCache");
        SecurityTestUtil.closeCache();
        this.server1.invoke(SecurityTestUtil.class, "closeCache");
        this.server2.invoke(SecurityTestUtil.class, "closeCache");
    }
}

