/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.NotAuthorizedException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Map;
import java.util.Properties;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class WanAuthorizationDUnitTest
extends ClientAuthorizationTestBase {
    private static Cache cache = null;
    private static DistributedSystem dsys = null;
    VM site1 = null;
    VM site2 = null;
    private static final String[] gatewayExpectedExceptions = new String[]{NotAuthorizedException.class.getName(), AuthenticationFailedException.class.getName()};

    public WanAuthorizationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        WanAuthorizationDUnitTest.disconnectAllFromDS();
        WanAuthorizationDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.site1 = host.getVM(1);
        this.site2 = host.getVM(2);
    }

    public void testOneSiteValidOtherInvalidCredentials() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            Properties props1 = WanAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            Properties javaProps1 = cGen.getJavaProperties();
            Properties invalidCreateCredentials = cGen.getInvalidCredentials(1);
            Properties javaProps2 = cGen.getJavaProperties();
            WanAuthorizationDUnitTest.getLogWriter().info("testOneSiteValidOtherInvalidCredentials: For first client credentials: " + createCredentials);
            if (authInit != null) {
                props1.setProperty("security-client-auth-init", authInit);
            }
            props1.setProperty("security-log-level", "finest");
            Properties props2 = new Properties();
            props2.putAll((Map<?, ?>)props1);
            props1.putAll((Map<?, ?>)createCredentials);
            props2.putAll((Map<?, ?>)invalidCreateCredentials);
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props1, javaProps1, "site1", DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props2, javaProps2, "site2", DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), gatewayExpectedExceptions});
            WanAuthorizationDUnitTest.pause(1000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(0)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(2)});
            WanAuthorizationDUnitTest.pause(5000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(2)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(2)});
            this.site1.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
        }
    }

    public void testBothSiteValidAuthzCredentials() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            Properties props1 = WanAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            Properties javaProps = cGen.getJavaProperties();
            WanAuthorizationDUnitTest.getLogWriter().info("testBothSiteValidAuthzCredentials: For first client credentials: " + createCredentials);
            if (authInit != null) {
                props1.setProperty("security-client-auth-init", authInit);
            }
            props1.setProperty("security-log-level", "finest");
            props1.putAll((Map<?, ?>)createCredentials);
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props1, javaProps, "site1", DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props1, javaProps, "site2", DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), gatewayExpectedExceptions});
            WanAuthorizationDUnitTest.pause(1000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(0)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(2)});
            WanAuthorizationDUnitTest.pause(5000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(4)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(4)});
            this.site1.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
        }
    }

    public void testOneSiteValidOtherInvalidAuthzCredentials() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            Properties props1 = WanAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Properties createCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            Properties javaProps1 = cGen.getJavaProperties();
            Properties invalidCreateCredentials = gen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            Properties javaProps2 = cGen.getJavaProperties();
            WanAuthorizationDUnitTest.getLogWriter().info("testOneSiteValidOtherInvalidAuthzCredentials: For first client credentials: " + createCredentials);
            if (authInit != null) {
                props1.setProperty("security-client-auth-init", authInit);
            }
            props1.setProperty("security-log-level", "finest");
            Properties props2 = new Properties();
            props2.putAll((Map<?, ?>)props1);
            props1.putAll((Map<?, ?>)createCredentials);
            props2.putAll((Map<?, ?>)invalidCreateCredentials);
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props1, javaProps1, "site1", DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props2, javaProps2, "site2", DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), gatewayExpectedExceptions});
            WanAuthorizationDUnitTest.pause(1000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(0)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(2)});
            WanAuthorizationDUnitTest.pause(5000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(2)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(4)});
            this.site1.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
        }
    }

    public void testBothSiteInvalidAuthzCredentials() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            Properties props1 = WanAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Properties javaProps1 = cGen.getJavaProperties();
            Properties invalidCreateCredentials = gen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT}, new String[]{"AuthRegion"}, 1);
            Properties javaProps2 = cGen.getJavaProperties();
            WanAuthorizationDUnitTest.getLogWriter().info("testBothSiteInvalidAuthzCredentials: For first client credentials: " + invalidCreateCredentials);
            if (authInit != null) {
                props1.setProperty("security-client-auth-init", authInit);
            }
            props1.setProperty("security-log-level", "finest");
            props1.putAll((Map<?, ?>)invalidCreateCredentials);
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props1, javaProps1, "site1", DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props1, javaProps2, "site2", DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), gatewayExpectedExceptions});
            WanAuthorizationDUnitTest.pause(1000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(0)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(2), new Integer(2)});
            WanAuthorizationDUnitTest.pause(5000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(2)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(2)});
            this.site1.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
        }
    }

    public void testValidInvalidDestroyAuthzCredentials() {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            Properties props1 = WanAuthorizationDUnitTest.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            Properties validDestroyCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.DESTROY}, new String[]{"AuthRegion"}, 1);
            Properties javaProps1 = cGen.getJavaProperties();
            Properties invalidDestroyCredentials = gen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.DESTROY}, new String[]{"AuthRegion"}, 1);
            Properties javaProps2 = cGen.getJavaProperties();
            WanAuthorizationDUnitTest.getLogWriter().info("testValidInvalidDestroyAuthzCredentials: For first client credentials: " + invalidDestroyCredentials);
            if (authInit != null) {
                props1.setProperty("security-client-auth-init", authInit);
            }
            props1.setProperty("security-log-level", "finest");
            Properties props2 = new Properties();
            props2.putAll((Map<?, ?>)props1);
            props1.putAll((Map<?, ?>)validDestroyCredentials);
            props2.putAll((Map<?, ?>)invalidDestroyCredentials);
            int hubep1 = AvailablePort.getRandomAvailablePort((int)0);
            int hubep2 = AvailablePort.getRandomAvailablePort((int)0);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props1, javaProps1, "site1", DistributedTestCase.getIPLiteral(), new Integer(hubep1), "gateway1", new Integer(hubep2), gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "createTheSite", new Object[]{props2, javaProps2, "site2", DistributedTestCase.getIPLiteral(), new Integer(hubep2), "gateway2", new Integer(hubep1), gatewayExpectedExceptions});
            WanAuthorizationDUnitTest.pause(1000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "doNPuts", new Object[]{new Integer(4), new Integer(0)});
            WanAuthorizationDUnitTest.pause(5000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "doNDestroys", new Object[]{new Integer(2), new Integer(0)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "doNDestroys", new Object[]{new Integer(2), new Integer(2)});
            WanAuthorizationDUnitTest.pause(5000);
            this.site1.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(2)});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "verifyNInCache", new Object[]{new Integer(0)});
            this.site1.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
            this.site2.invoke(WanAuthorizationDUnitTest.class, "closeTheSite", new Object[]{gatewayExpectedExceptions});
        }
    }

    public static void closeTheSite(String[] expectedExceptions) {
        LogWriter logger = dsys.getLogWriter();
        if (logger != null) {
            SecurityTestUtil.removeExpectedExceptions(expectedExceptions, logger);
        }
        cache.close();
        dsys.disconnect();
    }

    public static void createTheSite(Properties props, Object javaProps, String site, String hub, Integer hubEP, String gateway, Integer gatewayEP, String[] expectedExceptions) {
        SecurityTestUtil.clearStaticSSLContext();
        SecurityTestUtil.setJavaProps((Properties)javaProps);
        int mcastport = AvailablePort.getRandomAvailablePort((int)1);
        Integer mport = new Integer(mcastport);
        props.setProperty("mcast-port", mport.toString());
        props.setProperty("log-level", "finest");
        dsys = DistributedSystem.connect((Properties)props);
        cache = CacheFactory.create((DistributedSystem)dsys);
        SecurityTestUtil.addExpectedExceptions(expectedExceptions, dsys.getLogWriter());
        try {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            factory.setEnableGateway(true);
            RegionAttributes attrs = factory.create();
            cache.createRegion("AuthRegion", attrs);
            GatewayHub gatewayhub = cache.addGatewayHub(hub, hubEP.intValue());
            gatewayhub.setSocketBufferSize(25600);
            Gateway tmpgateway = gatewayhub.addGateway(gateway);
            WanAuthorizationDUnitTest.setDiskStoreForGateway(cache, gateway, tmpgateway.getQueueAttributes());
            tmpgateway.addEndpoint(site, DistributedTestCase.getIPLiteral(), gatewayEP.intValue());
            gatewayhub.start();
            tmpgateway.start();
        }
        catch (Exception ex) {
            WanAuthorizationDUnitTest.getLogWriter().fine("exception received while starting gateway ignorable");
        }
    }

    public static void doNPuts(Integer n, Integer offset) {
        Region reg = cache.getRegion("AuthRegion");
        for (int i = offset.intValue(); i < n + offset; ++i) {
            reg.put((Object)SecurityTestUtil.keys[i], (Object)SecurityTestUtil.values[i]);
        }
    }

    public static void doNDestroys(Integer n, Integer offset) {
        Region reg = cache.getRegion("AuthRegion");
        for (int i = offset.intValue(); i < n + offset; ++i) {
            reg.destroy((Object)SecurityTestUtil.keys[i]);
        }
    }

    public static void verifyNInCache(Integer n) {
        Region reg = cache.getRegion("AuthRegion");
        long start = System.currentTimeMillis();
        long waitTime = 60000L;
        while (n.intValue() != reg.keySet().size() && System.currentTimeMillis() - start <= waitTime) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                WanAuthorizationDUnitTest.fail((String)"interrupted");
            }
        }
        WanAuthorizationDUnitTest.assertEquals((String)"entry count mismatch", (int)n, (int)reg.keySet().size());
    }

    protected static Properties buildProperties(String authenticator, String accessor, boolean isAccessorPP, Properties extraAuthProps, Properties extraAuthzProps) {
        Properties authProps = new Properties();
        if (authenticator != null) {
            authProps.setProperty("security-client-authenticator", authenticator);
        }
        if (accessor != null) {
            if (isAccessorPP) {
                authProps.setProperty("security-client-accessor-pp", accessor);
            } else {
                authProps.setProperty("security-client-accessor", accessor);
            }
        }
        return SecurityTestUtil.concatProperties(new Properties[]{authProps, extraAuthProps, extraAuthzProps});
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.site1.invoke(this.getClass(), "closeCache");
        this.site2.invoke(this.getClass(), "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }
}

