/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.persistence.logging;

public class Level {
    public static final Level OFF = new Level("OFF", 4);
    public static final Level SEVERE = new Level("SEVERE", 3);
    public static final Level WARNING = new Level("WARNING", 2);
    public static final Level INFO = new Level("INFO", 1);
    public static final Level CONFIG = new Level("CONFIG", 0);
    public static final Level FINE = new Level("FINE", -1);
    public static final Level FINER = new Level("FINER", -2);
    public static final Level FINEST = new Level("FINEST", -3);
    public static final Level ALL = new Level("ALL", -4);
    private String name;
    private int value;

    protected Level(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public static Level parse(String name) {
        if (name.equalsIgnoreCase("OFF")) {
            return OFF;
        }
        if (name.equalsIgnoreCase("SEVERE")) {
            return SEVERE;
        }
        if (name.equalsIgnoreCase("WARNING")) {
            return WARNING;
        }
        if (name.equalsIgnoreCase("INFO")) {
            return INFO;
        }
        if (name.equalsIgnoreCase("CONFIG")) {
            return CONFIG;
        }
        if (name.equalsIgnoreCase("FINE")) {
            return FINE;
        }
        if (name.equalsIgnoreCase("FINER")) {
            return FINER;
        }
        if (name.equalsIgnoreCase("FINEST")) {
            return FINEST;
        }
        if (name.equalsIgnoreCase("ALL")) {
            return ALL;
        }
        try {
            return new Level(name, Integer.parseInt(name));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid level: " + name);
        }
    }

    public int intValue() {
        return this.value;
    }

    public String toString() {
        return "Level " + this.name + " (" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof Level) {
            Level l = (Level)o;
            if (l.value == this.value) {
                return true;
            }
        }
        return false;
    }
}

