/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.persistence.logging;

import com.gemstone.persistence.admin.Logger;
import com.gemstone.persistence.logging.Formatter;
import com.gemstone.persistence.logging.LogRecord;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;

public class SimpleFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        StringWriter sw;
        Object[] params;
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(Logger.formatDate(new Date(record.getMillis())));
        sb.append(' ');
        sb.append(Thread.currentThread().getName());
        sb.append("] ");
        sb.append(record.getMessage());
        sb.append('\n');
        if (record.getSourceClassName() != null) {
            sb.append(" In ");
            sb.append(record.getSourceClassName());
            if (record.getSourceMethodName() != null) {
                sb.append(".");
                sb.append(record.getSourceMethodName());
            }
            sb.append('\n');
        }
        if ((params = record.getParameters()) != null) {
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i]);
                sb.append('\n');
            }
        }
        if (record.getThrown() != null) {
            Throwable thr = record.getThrown();
            sw = new StringWriter();
            thr.printStackTrace(new PrintWriter((Writer)sw, true));
            sb.append(sw.toString());
            sb.append('\n');
        }
        if (STACK_TRACE) {
            Exception thr = new Exception("Stack Trace");
            sw = new StringWriter();
            thr.printStackTrace(new PrintWriter((Writer)sw, true));
            sb.append(sw.toString());
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }
}

