/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.persistence.logging;

import com.gemstone.persistence.logging.Formatter;
import com.gemstone.persistence.logging.Handler;
import com.gemstone.persistence.logging.LogRecord;
import java.io.OutputStream;
import java.io.PrintWriter;

public class StreamHandler
extends Handler {
    private PrintWriter pw;

    public StreamHandler(OutputStream stream, Formatter formatter) {
        this.pw = new PrintWriter(stream, true);
        this.setFormatter(formatter);
    }

    @Override
    public void close() {
        this.pw.close();
    }

    @Override
    public void flush() {
        this.pw.flush();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.pw == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    @Override
    public void publish(LogRecord record) {
        Formatter formatter = this.getFormatter();
        this.pw.print(formatter.format(record));
    }
}

