/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import com.gemstone.sequence.Arrow;
import com.gemstone.sequence.Lifeline;
import com.gemstone.sequence.StateColorMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;

public class LifelineState {
    private final long startTime;
    private final long endTime;
    private final String stateName;
    private int startY;
    private int height;
    private final Lifeline line;
    private final Set<Arrow> inboundArrows = new HashSet<Arrow>();
    private static final int ARC_SIZE = 10;

    public int getStartY() {
        return this.startY;
    }

    public int getHeight() {
        return this.height;
    }

    public LifelineState(Lifeline line, String stateName, long startTime, long endTime) {
        this.line = line;
        this.stateName = stateName;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void paint(Graphics2D g, StateColorMap colorMap) {
        Rectangle bounds = g.getClipBounds();
        if ((double)this.startY > bounds.getMaxY() || (double)(this.startY + this.height) < bounds.getMinY()) {
            return;
        }
        int x = this.line.getX();
        int width = this.line.getWidth();
        Color color = colorMap.getColor(this.stateName);
        g.setColor(color);
        g.fillRoundRect(x, this.startY, width, this.height, 10, 10);
        g.setColor(Color.BLACK);
    }

    public void highlight(Graphics2D g) {
        Rectangle bounds = g.getClipBounds();
        if ((double)this.startY > bounds.getMaxY() || (double)(this.startY + this.height) < bounds.getMinY()) {
            return;
        }
        int x = this.line.getX();
        int width = this.line.getWidth();
        g.drawRoundRect(x, this.startY, width, this.height, 10, 10);
    }

    public void resize(double scale, long base) {
        this.startY = (int)((double)(this.startTime - base) * scale);
        this.height = (int)((double)(this.endTime - this.startTime) * scale);
    }

    public Component getPopup() {
        return new JLabel("<html>Object: " + this.line.getDiagramName() + "<br>Member: " + this.line.getName() + "<br>State: " + this.stateName + "<br>Time:" + new Date(this.startTime) + "</html>");
    }

    public Lifeline getLine() {
        return this.line;
    }

    public void addInboundArrow(Arrow arrow) {
        this.inboundArrows.add(arrow);
    }

    public Set<Arrow> getInboundArrows() {
        return this.inboundArrows;
    }

    public String toString() {
        return this.line.getName() + "@" + this.startTime + ":" + this.stateName;
    }
}

