/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import com.gemstone.sequence.Arrow;
import com.gemstone.sequence.Lifeline;
import com.gemstone.sequence.LifelineState;
import com.gemstone.sequence.LineMapper;
import com.gemstone.sequence.StateColorMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class SequenceDiagram
extends JPanel {
    private static final Color HIGHLIGHT_COLOR = Color.RED;
    private final List<String> lineNames;
    private final Map<String, List<String>> shortLineNames;
    private final SortedMap<Comparable, SubDiagram> subDiagrams = new TreeMap<Comparable, SubDiagram>();
    private final StateColorMap colorMap = new StateColorMap();
    private final long minTime;
    private final long maxTime;
    private static int PADDING_BETWEEN_LINES = 100;
    private static int Y_PADDING = 20;
    private static final int STATE_WIDTH = 20;
    private static final int LINE_LABEL_BOUNDARY = 5;
    private static final int AXIS_SIZE = 35;
    private int lineStep;
    private int lineWidth;
    private Popup mouseover;
    private LifelineState mouseoverState;
    private LifelineState selectedState;

    public SequenceDiagram(long minTime, long maxTime, List<String> lineNames, LineMapper lineMapper) {
        this.lineNames = lineNames;
        this.shortLineNames = this.parseShortNames(lineNames, lineMapper);
        this.minTime = minTime;
        this.maxTime = maxTime;
        int width = this.getInitialWidth();
        int height = 500;
        super.setPreferredSize(new Dimension(width, height));
        this.resizeMe(width, height);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component source = (Component)e.getSource();
                SequenceDiagram.this.resizeMe(source.getWidth(), source.getHeight());
            }
        });
        this.setBackground(Color.WHITE);
    }

    private Map<String, List<String>> parseShortNames(List<String> lineNames, LineMapper lineMapper) {
        LinkedHashMap<String, List<String>> shortNames = new LinkedHashMap<String, List<String>>(lineNames.size());
        for (String name : lineNames) {
            String shortName = lineMapper.getShortNameForLine(name);
            ArrayList<String> list = (ArrayList<String>)shortNames.get(shortName);
            if (list == null) {
                list = new ArrayList<String>();
                shortNames.put(shortName, list);
            }
            list.add(name);
        }
        return shortNames;
    }

    public List<Comparable> getSubDiagramsNames() {
        return new ArrayList<Comparable>(this.subDiagrams.keySet());
    }

    public void addSubDiagram(Comparable name, Map<String, Lifeline> lines, List<Arrow> arrows) {
        this.subDiagrams.put(name, new SubDiagram(name, lines, arrows));
    }

    public void removeSubDiagram(Comparable name) {
        this.subDiagrams.remove(name);
    }

    private int getInitialWidth() {
        return this.shortLineNames.size() * PADDING_BETWEEN_LINES;
    }

    public void resizeMe(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        float xZoom = (float)width / (float)this.getInitialWidth();
        long elapsedTime = this.maxTime - this.minTime;
        double yScale = (double)height / (double)elapsedTime;
        long yBase = this.minTime;
        this.lineStep = (int)((float)PADDING_BETWEEN_LINES * xZoom);
        this.lineWidth = (int)(20.0f * xZoom);
        if (this.subDiagrams.size() <= 0) {
            return;
        }
        int sublineWidth = this.lineWidth / this.subDiagrams.size();
        int sublineIndex = 0;
        for (SubDiagram diagram : this.subDiagrams.values()) {
            int lineIndex = 0;
            for (List<String> fullNames : this.shortLineNames.values()) {
                for (String name : fullNames) {
                    Lifeline line = (Lifeline)diagram.lifelines.get(name);
                    if (line == null) continue;
                    int lineX = lineIndex * this.lineStep + sublineIndex * sublineWidth;
                    line.resize(lineX, sublineWidth, yBase, yScale);
                }
                ++lineIndex;
            }
            ++sublineIndex;
        }
    }

    public void showPopupText(int x, int y, int xOnScreen, int yOnScreen) {
        LifelineState state = this.getStateAt(x, y);
        if (state == this.mouseoverState) {
            return;
        }
        if (this.mouseover != null) {
            this.mouseover.hide();
        }
        if (state == null) {
            this.mouseover = null;
            this.mouseoverState = null;
        } else {
            Component popupContents = state.getPopup();
            this.mouseoverState = state;
            this.mouseover = PopupFactory.getSharedInstance().getPopup(this, popupContents, xOnScreen + 20, yOnScreen);
            this.mouseover.show();
        }
    }

    public void selectState(int x, int y) {
        LifelineState state = this.getStateAt(x, y);
        if (state == this.selectedState) {
            return;
        }
        if (this.selectedState != null) {
            this.fireRepaintOfDependencies(this.selectedState);
        }
        this.selectedState = state;
        if (state != null) {
            this.fireRepaintOfDependencies(state);
        }
    }

    private LifelineState getStateAt(int x, int y) {
        ArrayList<String> reverseList = new ArrayList<String>(this.lineNames);
        Collections.reverse(reverseList);
        for (SubDiagram diagram : this.subDiagrams.values()) {
            for (String name : reverseList) {
                LifelineState state;
                Lifeline line = (Lifeline)diagram.lifelines.get(name);
                if (line == null || line.getX() >= x || line.getX() + line.getWidth() <= x || (state = line.getStateAt(y)) == null) continue;
                return state;
            }
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        for (SubDiagram subDiagram : this.subDiagrams.values()) {
            subDiagram.paintStates(g2, this.colorMap);
        }
        for (SubDiagram subDiagram : this.subDiagrams.values()) {
            subDiagram.paintArrows(g2, this.colorMap);
        }
        this.paintHighlightedComponents(g2, this.selectedState, new HashSet<LifelineState>());
    }

    private void fireRepaintOfDependencies(LifelineState state) {
        this.repaint();
    }

    private void paintHighlightedComponents(Graphics2D g2, LifelineState endingState, Set<LifelineState> visited) {
        if (!visited.add(endingState)) {
            return;
        }
        g2.setColor(HIGHLIGHT_COLOR);
        if (endingState != null) {
            endingState.highlight(g2);
            for (Arrow arrow : endingState.getInboundArrows()) {
                arrow.paint(g2);
                this.paintHighlightedComponents(g2, arrow.getStartingState(), visited);
            }
        }
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public JComponent createMemberAxis() {
        return new MemberAxis();
    }

    public static class SubDiagram {
        private final Map<String, Lifeline> lifelines;
        private final List<Arrow> arrows;
        private final Comparable name;

        public SubDiagram(Comparable name, Map<String, Lifeline> lines, List<Arrow> arrows) {
            this.name = name;
            this.lifelines = lines;
            this.arrows = arrows;
        }

        public void paintStates(Graphics2D g2, StateColorMap colorMap) {
            for (Lifeline line : this.lifelines.values()) {
                line.paint(g2, colorMap);
            }
        }

        public void paintArrows(Graphics2D g2, StateColorMap colorMap) {
            Color lineColor = colorMap.getColor(this.name);
            g2.setColor(lineColor);
            for (Arrow arrow : this.arrows) {
                arrow.paint(g2);
            }
        }
    }

    private class MemberAxis
    extends JComponent {
        public MemberAxis() {
            this.setPreferredSize(new Dimension(this.getWidth(), 35));
            SequenceDiagram.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int newWidth = e.getComponent().getWidth();
                    MemberAxis.this.setPreferredSize(new Dimension(newWidth, 35));
                    MemberAxis.this.revalidate();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle bounds = g.getClipBounds();
            int index = 0;
            for (String name : SequenceDiagram.this.shortLineNames.keySet()) {
                int nameWidth = g.getFontMetrics().stringWidth(name);
                int lineX = SequenceDiagram.this.lineStep * index;
                ++index;
                if (bounds.getMaxX() < (double)lineX || bounds.getMinX() > (double)(lineX + nameWidth)) continue;
                g.setClip(lineX + 5, 0, SequenceDiagram.this.lineStep - 10, this.getHeight());
                g.drawString(name, lineX + 5, 11);
                g.setClip(null);
            }
        }
    }
}

