/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import com.gemstone.sequence.SequenceDiagram;
import com.gemstone.sequence.TimeAxis;
import com.gemstone.sequence.ZoomingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SequencePanel
extends JPanel {
    public SequencePanel(SequenceDiagram sequenceDiagram) {
        ZoomingPanel drawingPane = new ZoomingPanel();
        drawingPane.setBackground(Color.white);
        drawingPane.setSequenceDiagram(sequenceDiagram);
        final JScrollPane scroller = new JScrollPane(drawingPane);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setHorizontalScrollBarPolicy(32);
        final TimeAxis timeAxis = new TimeAxis(1, sequenceDiagram.getMinTime(), sequenceDiagram.getMaxTime());
        timeAxis.setPreferredHeight(drawingPane.getHeight());
        scroller.setRowHeaderView(timeAxis);
        scroller.setColumnHeaderView(sequenceDiagram.createMemberAxis());
        int preferredWidth = (int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - 100.0);
        int preferredHeight = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 100.0);
        scroller.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        scroller.setAutoscrolls(true);
        sequenceDiagram.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int height = e.getComponent().getHeight();
                timeAxis.setPreferredHeight(height);
                timeAxis.revalidate();
            }
        });
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)scroller, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component source = e.getComponent();
                scroller.setSize(source.getSize());
                scroller.revalidate();
            }
        });
    }
}

