/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class StateColorMap {
    private Map<Object, Color> colors = new HashMap<Object, Color>();
    private static Color[] PREDEFINED_COLORS = new Color[]{Color.BLUE, Color.BLACK, Color.PINK, Color.CYAN, Color.ORANGE, Color.GREEN};
    private ColorList colorList = new ColorList();

    public StateColorMap() {
        this.colors.put("created", Color.GREEN);
        this.colors.put("destroyed", Color.WHITE);
        this.colors.put("persisted", new Color(0, 150, 0));
    }

    public Color getColor(Object state) {
        Color color = this.colors.get(state);
        if (color == null) {
            color = this.colorList.nextColor();
            this.colors.put(state, color);
        }
        return color;
    }

    private static class ColorList {
        int colorIndex;

        private ColorList() {
        }

        public Color nextColor() {
            if (this.colorIndex < PREDEFINED_COLORS.length) {
                return PREDEFINED_COLORS[this.colorIndex++];
            }
            return Color.getHSBColor((float)Math.random(), (float)Math.random(), (float)Math.random());
        }
    }
}

