/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import com.gemstone.sequence.SequenceDiagram;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class ZoomingPanel
extends JPanel {
    private int zoomBoxStartX;
    private int zoomBoxStartY;
    private int zoomBoxWidth;
    private int zoomBoxHeight;
    private SequenceDiagram child;

    public ZoomingPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ZoomingPanel.this.startBox(e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ZoomingPanel.this.endBox(e.getX(), e.getY());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    ZoomingPanel.this.unzoom();
                } else {
                    ZoomingPanel.this.child.selectState(e.getX(), e.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
                ((JPanel)e.getSource()).scrollRectToVisible(r);
                ZoomingPanel.this.showBox(e.getX(), e.getY());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int popupX = ZoomingPanel.this.getLocationOnScreen().x + e.getX();
                int popupY = ZoomingPanel.this.getLocationOnScreen().y + e.getY();
                ZoomingPanel.this.child.showPopupText(e.getX(), e.getY(), popupX, popupY);
            }
        });
        BorderLayout layout = new BorderLayout();
        layout.setHgap(0);
        layout.setVgap(0);
        this.setLayout(layout);
    }

    private void unzoom() {
        this.resizeMe(0, 0, this.getWidth(), this.getHeight());
    }

    void resizeMe(int zoomBoxX, int zoomBoxY, int zoomBoxWidth, int zoomBoxHeight) {
        Dimension viewSize = this.getParent().getSize();
        double windowWidth = viewSize.getWidth();
        double windowHeight = viewSize.getHeight();
        double scaleX = (double)this.getWidth() / (double)zoomBoxWidth;
        double scaleY = (double)this.getHeight() / (double)zoomBoxHeight;
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        int width = (int)(scaleX * windowWidth);
        int height = (int)(scaleY * windowHeight);
        this.child.resizeMe(width, height);
        this.revalidate();
        int scrollX = (int)((double)zoomBoxX * ((double)width / (double)oldWidth));
        int scrollY = (int)((double)zoomBoxY * ((double)height / (double)oldHeight));
        int scrollWidth = (int)((double)zoomBoxWidth * ((double)width / (double)oldWidth));
        int scrollHeight = (int)((double)zoomBoxHeight * ((double)height / (double)oldHeight));
        Rectangle r = new Rectangle(scrollX, scrollY, scrollWidth, scrollHeight);
        ((JViewport)this.getParent()).scrollRectToVisible(r);
        this.repaint();
    }

    public void setSequenceDiagram(SequenceDiagram diag) {
        this.child = diag;
        this.add((Component)this.child, "Center");
    }

    private void showBox(int x, int y) {
        if (this.zoomBoxWidth != -1) {
            this.repaint(this.getBoxX(), this.getBoxY(), this.getBoxWidth(), this.getBoxHeight());
        }
        this.zoomBoxWidth = x - this.zoomBoxStartX;
        this.zoomBoxHeight = y - this.zoomBoxStartY;
        this.repaint(this.getBoxX(), this.getBoxY(), this.getBoxWidth(), this.getBoxHeight());
    }

    private void startBox(int x, int y) {
        this.zoomBoxStartX = x;
        this.zoomBoxStartY = y;
    }

    private void endBox(int x, int y) {
        if (this.zoomBoxStartX != -1 && this.zoomBoxStartY != -1 && this.zoomBoxWidth != -1 && this.zoomBoxHeight != -1 && this.zoomBoxWidth != 0 && this.zoomBoxHeight != 0) {
            this.resizeMe(this.getBoxX(), this.getBoxY(), this.getBoxWidth(), this.getBoxHeight());
            this.repaint(this.getBoxX(), this.getBoxY(), this.getBoxWidth(), this.getBoxHeight());
            this.zoomBoxStartX = -1;
            this.zoomBoxStartY = -1;
            this.zoomBoxWidth = -1;
            this.zoomBoxHeight = -1;
        }
    }

    public int getBoxX() {
        return this.zoomBoxWidth >= 0 ? this.zoomBoxStartX : this.zoomBoxStartX + this.zoomBoxWidth;
    }

    public int getBoxY() {
        return this.zoomBoxHeight >= 0 ? this.zoomBoxStartY : this.zoomBoxStartY + this.zoomBoxHeight;
    }

    public int getBoxHeight() {
        return this.zoomBoxHeight >= 0 ? this.zoomBoxHeight : -this.zoomBoxHeight;
    }

    public int getBoxWidth() {
        return this.zoomBoxWidth >= 0 ? this.zoomBoxWidth : -this.zoomBoxWidth;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.zoomBoxStartX != -1 && this.zoomBoxStartY != -1 && this.zoomBoxWidth != -1 && this.zoomBoxHeight != -1) {
            Graphics2D g2 = (Graphics2D)g.create();
            Composite old = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.setColor(Color.BLUE);
            g2.fillRect(this.getBoxX(), this.getBoxY(), this.getBoxWidth(), this.getBoxHeight());
            g2.setComposite(old);
        }
    }
}

