/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence.gemfire;

import com.gemstone.gemfire.internal.sequencelog.model.GraphID;
import com.gemstone.gemfire.internal.sequencelog.model.GraphSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SelectGraphDialog
extends JDialog {
    private List<GraphID> selectedIds = new ArrayList<GraphID>();
    private Set<SelectionListener> listeners = new HashSet<SelectionListener>();

    public SelectGraphDialog(GraphSet graphs) {
        ArrayList ids = new ArrayList(graphs.getMap().keySet());
        Collections.sort(ids);
        final FilterableListModel listModel = new FilterableListModel(ids);
        final JList list = new JList(listModel);
        JScrollPane selectGraphPane = new JScrollPane(list);
        selectGraphPane.setPreferredSize(new Dimension(500, 500));
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectGraphDialog.this.selectedIds = Arrays.asList(list.getSelectedValues());
                SelectGraphDialog.this.fireSelectionChanged();
                SelectGraphDialog.this.setVisible(false);
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectGraphDialog.this.setVisible(false);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(apply);
        buttonPane.add(cancel);
        final JTextField searchField = new JTextField(10);
        searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            private void doUpdate() {
                listModel.updateFilter(searchField.getText());
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.add((Component)searchField, "First");
        contentPane.add((Component)selectGraphPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
    }

    private void fireSelectionChanged() {
        for (SelectionListener listener : this.listeners) {
            listener.selectionChanged(this.selectedIds);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    private static class FilterableListModel
    extends AbstractListModel {
        private final List<?> allElements;
        private List<Object> filteredElements;

        public FilterableListModel(List<?> elements) {
            this.allElements = elements;
            this.filteredElements = new ArrayList(elements);
        }

        @Override
        public int getSize() {
            return this.filteredElements.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.filteredElements.get(index);
        }

        public void updateFilter(String filter) {
            Pattern pattern = Pattern.compile(filter);
            this.filteredElements = new ArrayList<Object>();
            for (Object element : this.allElements) {
                if (!pattern.matcher(element.toString()).find()) continue;
                this.filteredElements.add(element);
            }
            this.fireContentsChanged(this, 0, this.filteredElements.size());
        }
    }

    public static interface SelectionListener {
        public void selectionChanged(List<GraphID> var1);
    }
}

