/*
 * Decompiled with CFR 0.152.
 */
package conflation;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.InternalInstantiator;
import conflation.ConflationBlackboard;
import conflation.ConflationPrms;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.GatewayHubHelper;
import hydra.GatewayPrms;
import hydra.GatewaySenderPrms;
import hydra.HydraRuntimeException;
import hydra.HydraThreadGroup;
import hydra.HydraThreadSubgroup;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import objects.ObjectHelper;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import util.TestHelper;

public class ConflationClient
extends CachePerfClient {
    public static void createGatewayHubTask() {
        GatewayHubHelper.createGatewayHub("hub");
    }

    public static void startGatewayHubTask() {
        GatewayHubHelper.addGateways("gateway");
        GatewayHubHelper.startGatewayHub();
    }

    public static void registerInterestTask() {
        ConflationClient c = new ConflationClient();
        c.initialize();
        c.registerInterest();
    }

    private void registerInterest() {
        int interestTotalSize = ConflationPrms.getInterestTotalSize();
        int interestBatchSize = ConflationPrms.getInterestBatchSize();
        Region region = ((GemFireCacheTestImpl)this.cache).getRegion();
        ArrayList<Object> interestList = new ArrayList<Object>();
        try {
            for (int i = 0; i <= interestTotalSize; ++i) {
                int name = this.getNextKey();
                Object key = ObjectHelper.createName(name);
                interestList.add(key);
                if (interestList.size() % interestBatchSize == 0) {
                    region.registerInterest(interestList);
                    Log.getLogWriter().info("Registering " + interestList);
                    interestList = new ArrayList();
                }
                ++this.count;
                ++this.keyCount;
            }
            if (interestList.size() != 0) {
                region.registerInterest(interestList);
                Log.getLogWriter().info("Registering " + interestList);
            }
        }
        catch (CacheWriterException e) {
            String s = "Failed to register interest in " + interestList;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    public static void feedDataTask() {
        ConflationClient c = new ConflationClient();
        c.initialize(3);
        c.feedData();
    }

    private void feedData() {
        String objectType = CachePerfPrms.getObjectType();
        boolean feedMonotonically = ConflationPrms.feedMonotonically();
        int destroyPercentage = ConflationPrms.getDestroyPercentage();
        long endTime = System.currentTimeMillis() + ConflationPrms.getTaskGranularityMs();
        int puts = 0;
        do {
            Object val;
            int name = this.getNextKey();
            Object key = ObjectHelper.createName(name);
            int n = this.rng.nextInt(1, 100);
            if (n < destroyPercentage && this.cache.get(key) != null) {
                this.destroy(key);
                if (feedMonotonically) {
                    name = 0;
                }
                val = ObjectHelper.createObject(objectType, name);
                this.create(key, val);
            } else {
                if (feedMonotonically) {
                    Object oldVal = this.cache.get(key);
                    name = oldVal == null ? 0 : ObjectHelper.getIndex(oldVal) + 1;
                }
                val = ObjectHelper.createObject(objectType, name);
                this.put(key, val);
                ++puts;
            }
            if (!feedMonotonically) continue;
            TestHelper.checkForEventError(ConflationBlackboard.getInstance());
        } while (System.currentTimeMillis() < endTime);
        ConflationBlackboard.getInstance().getSharedCounters().add(ConflationBlackboard.Puts, puts);
    }

    private void put(Object key, Object val) {
        long start = this.statistics.startPut();
        this.cache.put(key, val);
        this.statistics.endPut(start, this.isMainWorkload, this.histogram);
        ++this.count;
        ++this.keyCount;
    }

    private void create(Object key, Object val) {
        long start = this.statistics.startCreate();
        this.cache.create(key, val);
        this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
        ++this.count;
        ++this.keyCount;
    }

    private void destroy(Object key) {
        long start = this.statistics.startDestroy();
        this.cache.destroy(key);
        this.statistics.endDestroy(start, this.isMainWorkload, this.histogram);
        ++this.count;
        ++this.keyCount;
    }

    public static void waitForCreateEventsTask() {
        ConflationClient c = new ConflationClient();
        c.waitForCreateEvents();
    }

    private void waitForCreateEvents() {
        String status;
        String target;
        int numVMs = this.numVMsInThreadGroup();
        long lastReceived = -1L;
        int maxEventWaitMs = ConflationPrms.getMaxEventWaitSec() * 1000;
        long endTime = System.currentTimeMillis() + (long)maxEventWaitMs;
        while (true) {
            long creates = this.getStatTotalCount("cacheperf.CachePerfStats", "creates");
            long createEvents = this.getStatTotalCount("cacheperf.CachePerfStats", "createEvents");
            long expected = creates * (long)numVMs;
            long received = createEvents;
            target = ": expected " + expected + " (as " + creates + " creates * " + numVMs + " vms)";
            status = ", received " + received + " (as " + createEvents + " create events)";
            if (received == expected) {
                ConflationClient.log().info("Did" + target + status);
                return;
            }
            if (received != lastReceived) {
                ConflationClient.log().info("Waiting for" + target + status);
                lastReceived = received;
                MasterController.sleepForMs(5000);
                endTime = System.currentTimeMillis() + (long)maxEventWaitMs;
                continue;
            }
            if (System.currentTimeMillis() > endTime) break;
        }
        throw new HydraRuntimeException("Timed out" + target + status);
    }

    public static void waitForConflatedUpdateEventsTask() {
        ConflationClient c = new ConflationClient();
        c.waitForConflatedUpdateEvents();
    }

    private void waitForConflatedUpdateEvents() {
        String status;
        String target;
        int numVMs = this.numVMsInThreadGroup();
        long lastReceived = -1L;
        long puts = ConflationBlackboard.getInstance().getSharedCounters().read(ConflationBlackboard.Puts);
        String client = RemoteTestModule.getMyClientName();
        int clientVmsPerSite = TestConfig.getInstance().getClientDescription(client).getVmQuantity();
        int maxEventWaitMs = ConflationPrms.getMaxEventWaitSec() * 1000;
        long endTime = System.currentTimeMillis() + (long)maxEventWaitMs;
        while (true) {
            long eventsConflated = 0L;
            long eventsRemoved = 0L;
            long eventsTaken = 0L;
            long eventsExpired = 0L;
            long eventsRemovedByQrm = 0L;
            long wanconflations = 0L;
            long updateEvents = 0L;
            long creates = 0L;
            long destroys = 0L;
            long expectedMarkerMessages = 0L;
            if (TestConfig.tab().booleanAt(RegionPrms.enableGateway, false) || TestConfig.tab().stringAt(RegionPrms.gatewaySenderNames, null) != null) {
                updateEvents = this.getStatTotalCount("cacheperf.CachePerfStats", "updateEvents");
                if (TestConfig.tab().booleanAt(GatewayPrms.batchConflation, false)) {
                    wanconflations = this.getStatTotalCount("GatewayStatistics", "eventsNotQueuedConflated");
                } else if (TestConfig.tab().booleanAt(GatewaySenderPrms.batchConflationEnabled, false)) {
                    wanconflations = this.getStatTotalCount("GatewaySenderStatistics", "eventsNotQueuedConflated");
                }
            } else {
                creates = this.getStatTotalCount("cacheperf.CachePerfStats", "creates");
                destroys = this.getStatTotalCount("cacheperf.CachePerfStats", "destroys");
                eventsConflated = this.getStatTotalCount("ClientSubscriptionStats", "eventsConflated");
                eventsRemoved = this.getStatTotalCount("ClientSubscriptionStats", "eventsRemoved");
                eventsTaken = this.getStatTotalCount("ClientSubscriptionStats", "eventsTaken");
                eventsExpired = this.getStatTotalCount("ClientSubscriptionStats", "eventsExpired");
                eventsRemovedByQrm = this.getStatTotalCount("ClientSubscriptionStats", "eventsRemovedByQrm");
                expectedMarkerMessages = clientVmsPerSite;
            }
            long instantiatorsCnt = InternalInstantiator.getInstantiators().length;
            long expected = (creates + puts + destroys) * (long)numVMs + instantiatorsCnt * (long)clientVmsPerSite + expectedMarkerMessages;
            long received = updateEvents + eventsConflated + eventsRemoved + eventsTaken + eventsExpired + eventsRemovedByQrm + wanconflations * (long)clientVmsPerSite;
            target = ": expected " + expected + " as (" + creates + " creates plus " + puts + " puts plus " + destroys + " destroys )" + " * " + numVMs + " vms";
            status = ", received " + received + " (as " + updateEvents + " updateEvents plus " + eventsConflated + " eventsConflated plus " + eventsRemoved + " eventsRemoved plus " + eventsTaken + " eventsTaken plus " + eventsExpired + " eventsExpired plus " + eventsRemovedByQrm + " eventsRemovedByQrm plus " + wanconflations + " total wan conflations * " + clientVmsPerSite + " clientVmsPerSite plus " + expectedMarkerMessages + " durableClient Marker messages)";
            if (received == expected) {
                ConflationClient.log().info("Did" + target + status);
                return;
            }
            if (received != lastReceived) {
                ConflationClient.log().info("Waiting for" + target + status);
                lastReceived = received;
                MasterController.sleepForMs(5000);
                endTime = System.currentTimeMillis() + (long)maxEventWaitMs;
                continue;
            }
            if (System.currentTimeMillis() > endTime) break;
        }
        throw new HydraRuntimeException("Timed out" + target + status);
    }

    private int numVMsInThreadGroup() {
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        HydraThreadGroup tg = TestConfig.getInstance().getThreadGroup(tgname);
        Vector tsgs = tg.getSubgroups();
        int numvms = 0;
        for (HydraThreadSubgroup tsg : tsgs) {
            numvms += tsg.getTotalVMs();
        }
        return numvms;
    }

    public static void validateConflationStatsTask() {
        ConflationClient c = new ConflationClient();
        c.validateConflationStats();
    }

    private void validateConflationStats() {
        String type = ConflationPrms.getConflationStatType();
        String stat = ConflationPrms.getConflationStat();
        boolean expectConflation = ConflationPrms.expectNonZeroConflationStat();
        long conflations = this.getStatTotalCount(type, stat);
        String s = type + "." + stat + " = " + conflations;
        if (expectConflation) {
            if (conflations <= 0L) {
                throw new HydraRuntimeException("No messages were conflated: " + s);
            }
            ConflationClient.log().info(s);
        } else {
            if (conflations > 0L) {
                throw new HydraRuntimeException("Messages were conflated: " + s);
            }
            ConflationClient.log().info(s);
        }
    }

    private long getStatTotalCount(String type, String stat) {
        String spec = "* " + type + " " + "* " + stat + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "combineAcrossArchives" + " " + "ops" + "=" + "max";
        List psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            Log.getLogWriter().warning("No stats found for " + spec);
            return 0L;
        }
        double total = 0.0;
        for (int i = 0; i < psvs.size(); ++i) {
            PerfStatValue psv = (PerfStatValue)psvs.get(i);
            total += psv.getMax();
        }
        return (long)total;
    }
}

