/*
 * Decompiled with CFR 0.152.
 */
package conflation;

import cacheperf.CachePerfStats;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import conflation.ConflationBlackboard;
import conflation.ConflationPrms;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import java.util.HashMap;
import java.util.Map;
import objects.ObjectHelper;
import objects.TimestampedObject;
import util.TestHelper;

public class ConflationListener
implements CacheListener {
    boolean validateMonotonic = ConflationPrms.validateMonotonic();
    boolean validateStrict = ConflationPrms.validateStrict();
    CachePerfStats statistics;
    LogWriter log;
    Map timestamps;
    Map values;

    public ConflationListener() {
        if (this.validateMonotonic || this.validateStrict) {
            this.timestamps = new HashMap();
            this.values = new HashMap();
        }
        this.statistics = CachePerfStats.getInstance();
        this.log = Log.getLogWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(EntryEvent event) {
        Object key = event.getKey();
        Object value = event.getNewValue();
        Class<ConflationListener> clazz = ConflationListener.class;
        synchronized (ConflationListener.class) {
            this.statistics.incCreateEvents(1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.log.fineEnabled()) {
                this.log.fine("Got create event on key " + key + "=" + value);
            }
            if (this.validateMonotonic || this.validateStrict) {
                Integer oldIndex = (Integer)this.values.get(key);
                Integer newIndex = new Integer(ObjectHelper.getIndex(value));
                this.values.put(key, newIndex);
                Long oldTimestamp = (Long)this.timestamps.get(key);
                Long newTimestamp = new Long(ObjectHelper.getTimestamp(value));
                this.timestamps.put(key, newTimestamp);
                if (oldIndex != null && newIndex < oldIndex && newTimestamp <= oldTimestamp) {
                    String s = "Received create on key " + key + " with timestamp " + newTimestamp + " and index " + newIndex + " after timestamp " + oldTimestamp + " and index " + oldIndex;
                    ConflationBlackboard.getInstance().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, s);
                    throw new HydraRuntimeException(s);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdate(EntryEvent event) {
        Object key = event.getKey();
        Object value = event.getNewValue();
        long elapsed = System.currentTimeMillis() - ((TimestampedObject)value).getTimestamp();
        Class<ConflationListener> clazz = ConflationListener.class;
        synchronized (ConflationListener.class) {
            int sleepMs;
            this.statistics.incUpdateLatency(elapsed);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (this.log.fineEnabled()) {
                this.log.fine("Got update event on key " + key + "=" + value);
            }
            if (this.validateMonotonic || this.validateStrict) {
                Integer oldIndex = (Integer)this.values.get(key);
                Integer newIndex = new Integer(ObjectHelper.getIndex(value));
                this.values.put(key, newIndex);
                Long oldTimestamp = (Long)this.timestamps.get(key);
                Long newTimestamp = new Long(ObjectHelper.getTimestamp(value));
                this.timestamps.put(key, newTimestamp);
                if (oldIndex != null) {
                    if (newTimestamp <= oldTimestamp && newIndex < oldIndex) {
                        String s = "Received obsolete update on key " + key + " with timestamp " + newTimestamp + " and index " + newIndex + " after timestamp " + oldTimestamp + " and index " + oldIndex;
                        ConflationBlackboard.getInstance().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, s);
                        throw new HydraRuntimeException(s);
                    }
                    if (newTimestamp.longValue() == oldTimestamp.longValue() && newIndex.intValue() == oldIndex.intValue()) {
                        String s = "Received duplicate update on key " + key + " with timestamp " + newTimestamp + " and index " + newIndex + " after timestamp " + oldTimestamp + " and index " + oldIndex;
                        ConflationBlackboard.getInstance().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, s);
                        throw new HydraRuntimeException(s);
                    }
                    if (this.validateStrict && newIndex != oldIndex + 1) {
                        String s = "Missing update on key " + key + " with timestamp " + newTimestamp + " and index " + newIndex + " after timestamp " + oldTimestamp + " and index " + oldIndex;
                        ConflationBlackboard.getInstance().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, s);
                        throw new HydraRuntimeException(s);
                    }
                }
            }
            if ((sleepMs = ConflationPrms.getListenerSleepMs()) > 0) {
                MasterController.sleepForMs(sleepMs);
            }
            return;
        }
    }

    public void afterInvalidate(EntryEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDestroy(EntryEvent event) {
        Object key = event.getKey();
        Object value = event.getNewValue();
        Class<ConflationListener> clazz = ConflationListener.class;
        synchronized (ConflationListener.class) {
            this.statistics.incDestroyEvents(1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.log.fineEnabled()) {
                this.log.fine("Got destroy event on key " + key + "=" + value);
            }
            if (this.validateMonotonic || this.validateStrict) {
                Integer oldIndex = (Integer)this.values.get(key);
                Object newIndex = null;
                this.values.put(key, newIndex);
                Long oldTimestamp = (Long)this.timestamps.get(key);
                Object newTimestamp = null;
                this.timestamps.put(key, newTimestamp);
                if (oldIndex == null) {
                    String s = "Received destroy on key " + key + " when index is already null";
                    ConflationBlackboard.getInstance().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, s);
                    throw new HydraRuntimeException(s);
                }
            }
            return;
        }
    }

    public void afterRegionClear(RegionEvent event) {
    }

    public void afterRegionCreate(RegionEvent event) {
    }

    public void afterRegionLive(RegionEvent event) {
    }

    public void afterRegionInvalidate(RegionEvent event) {
    }

    public void afterRegionDestroy(RegionEvent event) {
    }

    public void close() {
    }
}

