/*
 * Decompiled with CFR 0.152.
 */
package conflation;

import hydra.BasePrms;
import hydra.HydraConfigException;

public class ConflationPrms
extends BasePrms {
    public static Long interestTotalSize;
    public static Long interestBatchSize;
    public static Long destroyPercentage;
    public static Long taskGranularityMs;
    public static Long sleepMs;
    public static Long listenerSleepMs;
    public static Long feedMonotonically;
    public static Long validateMonotonic;
    public static Long validateStrict;
    public static Long conflationStatType;
    public static Long conflationStat;
    public static Long expectNonZeroConflationStat;
    public static Long maxEventWaitSec;

    public static int getInterestTotalSize() {
        Long key = interestTotalSize;
        int val = ConflationPrms.tab().intAt(key);
        if (val < 0) {
            String s = BasePrms.nameForKey(key) + " must be non-negative";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getInterestBatchSize() {
        Long key = interestBatchSize;
        int val = ConflationPrms.tab().intAt(key, 1);
        if (val <= 0) {
            String s = BasePrms.nameForKey(key) + " must be greater than 0";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getDestroyPercentage() {
        Long key = destroyPercentage;
        int val = ConflationPrms.tab().intAt(key, 0);
        if (val < 0 || val > 100) {
            String s = BasePrms.nameForKey(key) + " must be between 0 and 100";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static long getTaskGranularityMs() {
        Long key = taskGranularityMs;
        long val = ConflationPrms.tab().longAt(key, 60000L);
        if (val <= 0L) {
            String s = BasePrms.nameForKey(key) + " must be greater than 0";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getSleepMs() {
        Long key = sleepMs;
        int val = ConflationPrms.tab().intAt(key, 0);
        if (val < 0) {
            String s = BasePrms.nameForKey(key) + " must be non-negative";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getListenerSleepMs() {
        Long key = listenerSleepMs;
        int val = ConflationPrms.tab().intAt(key, 0);
        if (val < 0) {
            String s = BasePrms.nameForKey(key) + " must be non-negative";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static boolean feedMonotonically() {
        Long key = feedMonotonically;
        return ConflationPrms.tasktab().booleanAt(key, ConflationPrms.tab().booleanAt(key, false));
    }

    public static boolean validateMonotonic() {
        Long key = validateMonotonic;
        return ConflationPrms.tasktab().booleanAt(key, ConflationPrms.tab().booleanAt(key, false));
    }

    public static boolean validateStrict() {
        Long key = validateStrict;
        return ConflationPrms.tasktab().booleanAt(key, ConflationPrms.tab().booleanAt(key, false));
    }

    public static String getConflationStatType() {
        Long key = conflationStatType;
        String val = ConflationPrms.tasktab().stringAt(key, ConflationPrms.tab().stringAt(key, null));
        if (val == null) {
            throw new HydraConfigException(ConflationPrms.nameForKey(key) + " is not specified");
        }
        return val;
    }

    public static String getConflationStat() {
        Long key = conflationStat;
        String val = ConflationPrms.tasktab().stringAt(key, ConflationPrms.tab().stringAt(key, null));
        if (val == null) {
            throw new HydraConfigException(ConflationPrms.nameForKey(key) + " is not specified");
        }
        return val;
    }

    public static boolean expectNonZeroConflationStat() {
        Long key = expectNonZeroConflationStat;
        return ConflationPrms.tasktab().booleanAt(key, ConflationPrms.tab().booleanAt(key, false));
    }

    public static int getMaxEventWaitSec() {
        Long key = maxEventWaitSec;
        int val = ConflationPrms.tab().intAt(key, 60);
        if (val < 0) {
            String s = BasePrms.nameForKey(key) + " must be non-negative";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static void main(String[] args) {
        ConflationPrms.dumpKeys();
    }

    static {
        ConflationPrms.setValues(ConflationPrms.class);
    }
}

