/*
 * Decompiled with CFR 0.152.
 */
package container;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import container.ContainerTestCase;
import container.app.phonedirectory.domain.Address;
import container.app.phonedirectory.domain.Person;
import container.app.phonedirectory.domain.PhoneDirectoryEntry;
import container.app.phonedirectory.domain.PhoneNumber;
import container.app.phonedirectory.service.PhoneDirectoryService;
import container.app.util.Assert;
import container.app.util.ComposableFilter;
import container.app.util.DefaultFilter;
import container.app.util.Filter;
import container.app.util.Sys;
import java.rmi.Naming;
import junit.extensions.TestSetup;
import junit.framework.Test;

public abstract class AbstractPhoneDirectoryServiceTestCase
extends ContainerTestCase {
    protected static final String CACHE_XML_FILE = "/container/phoneDirectoryCache.xml";
    protected static final String PHONE_DIRECTORY_CACHE_NAME = "PhoneDirectoryServiceTest";
    protected static final String PHONE_DIRECTORY_REGION_PATH = "/phoneDirectory";
    private static PhoneDirectoryService service;
    private static Region<String, PhoneDirectoryEntry> region;

    protected static Filter<Object> getSystemPropertyFilter() {
        ContainerTestCase.SystemPropertyFilter filter = new ContainerTestCase.SystemPropertyFilter();
        return ComposableFilter.composeAnd(filter, new DefaultFilter(true));
    }

    public AbstractPhoneDirectoryServiceTestCase(String testName) {
        super(testName);
    }

    protected static PhoneDirectoryService getPhoneDirectoryService() {
        Assert.state(service != null, "The Phone Directory Service was not properly initialized!", new Object[0]);
        return service;
    }

    protected static Region<String, PhoneDirectoryEntry> getRegion() {
        Assert.state(region != null, "The ({0}) Region reference was not properly initialized!", PHONE_DIRECTORY_REGION_PATH);
        return region;
    }

    protected static void assertEquals(PhoneDirectoryEntry expected, PhoneDirectoryEntry actual) {
        junit.framework.Assert.assertEquals((Object)expected.getPerson(), (Object)actual.getPerson());
        junit.framework.Assert.assertEquals((Object)expected.getAddress(), (Object)actual.getAddress());
        junit.framework.Assert.assertEquals((Object)expected.getPhoneNumber(), (Object)actual.getPhoneNumber());
    }

    protected Address createAddress(String street1, String city, String state, String zipCode) {
        return new Address(street1, city, state, zipCode);
    }

    protected Person createPerson(String firstName, String lastName) {
        return new Person(firstName, lastName);
    }

    protected PhoneNumber createPhoneNumber(String areaCode, String prefix, String suffix) {
        return new PhoneNumber(areaCode, prefix, suffix);
    }

    protected PhoneDirectoryEntry createPhoneDirectoryEntry(Person person, Address address, PhoneNumber phoneNumber) {
        return new PhoneDirectoryEntry(person, address, phoneNumber);
    }

    protected static class PhoneDirectoryServiceClientCacheTestSetup
    extends AbstractPhoneDirectoryServiceTestSetup {
        private ClientCache clientCache;

        public PhoneDirectoryServiceClientCacheTestSetup(Test test) {
            super(test);
        }

        @Override
        protected void setUp() throws Exception {
            super.setUp();
            this.clientCache = ContainerTestCase.createClientCache();
            region = this.clientCache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(AbstractPhoneDirectoryServiceTestCase.PHONE_DIRECTORY_REGION_PATH.substring(1));
        }

        @Override
        protected void tearDown() throws Exception {
            super.tearDown();
            ContainerTestCase.closeClientCache(this.clientCache);
        }
    }

    protected static class PhoneDirectoryServiceCacheTestSetup
    extends AbstractPhoneDirectoryServiceTestSetup {
        private Cache cache;

        public PhoneDirectoryServiceCacheTestSetup(Test test) {
            super(test);
        }

        @Override
        protected void setUp() throws Exception {
            super.setUp();
            this.cache = ContainerTestCase.createCache(AbstractPhoneDirectoryServiceTestCase.PHONE_DIRECTORY_CACHE_NAME, AbstractPhoneDirectoryServiceTestCase.CACHE_XML_FILE, null);
            region = this.cache.getRegion(AbstractPhoneDirectoryServiceTestCase.PHONE_DIRECTORY_REGION_PATH);
        }

        @Override
        protected void tearDown() throws Exception {
            super.tearDown();
            ContainerTestCase.closeCache(this.cache);
        }
    }

    protected static abstract class AbstractPhoneDirectoryServiceTestSetup
    extends TestSetup {
        public AbstractPhoneDirectoryServiceTestSetup(Test test) {
            super(test);
        }

        protected String getRmiRegistryPort() {
            return System.getProperty("gemfire.container-tests.rmi-registry.port", String.valueOf(1099));
        }

        protected String getServiceUrl() {
            StringBuilder buffer = new StringBuilder("//");
            buffer.append("localhost");
            buffer.append(":");
            buffer.append(this.getRmiRegistryPort());
            buffer.append("/");
            buffer.append("phoneDirectoryService");
            return buffer.toString();
        }

        protected void setUp() throws Exception {
            super.setUp();
            ContainerTestCase.showSystemState(AbstractPhoneDirectoryServiceTestCase.getSystemPropertyFilter());
            String serviceUrl = this.getServiceUrl();
            Sys.out("Phone Directory Service URL ({0})", serviceUrl);
            service = (PhoneDirectoryService)Naming.lookup(serviceUrl);
        }

        protected void tearDown() throws Exception {
            service = null;
        }
    }
}

