/*
 * Decompiled with CFR 0.152.
 */
package container;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.LocalLogWriter;
import container.app.util.Assert;
import container.app.util.Filter;
import container.app.util.StringUtils;
import container.app.util.Sys;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class ContainerTestCase
extends TestCase {
    private static final LogWriter logWriter = new LocalLogWriter(800);
    private static final String DEFAULT_GEMFIRE_MCAST_PORT = "56123";

    public ContainerTestCase(String name) {
        super(name);
    }

    protected static LogWriter getLogWriter() {
        return logWriter;
    }

    protected static String getRandomAvailableMCastPortString() {
        return String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
    }

    protected static void closeCache(Cache cache) {
        cache.close();
    }

    protected static void closeClientCache(ClientCache cache) {
        cache.close(true);
    }

    protected static Cache createCache(String cacheName, String cacheXmlFile, Properties gemfireProperties) {
        return new CacheFactory(gemfireProperties).set("name", cacheName).set("cache-xml-file", cacheXmlFile).create();
    }

    protected static ClientCache createClientCache() {
        return new ClientCacheFactory().addPoolServer("localhost", Integer.parseInt(DEFAULT_GEMFIRE_MCAST_PORT)).setPoolSubscriptionEnabled(true).setPoolSubscriptionRedundancy(1).create();
    }

    protected static void showGemFireState(Filter<Object> propertyFilter) {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    protected static void showSystemState(Filter<Object> systemPropertyFilter) {
        Assert.notNull(systemPropertyFilter, "The object used to filter the System properties cannot be null!", new Object[0]);
        for (Object property : System.getProperties().keySet()) {
            if (!systemPropertyFilter.accept(property)) continue;
            Sys.out("{0} = {1}", property, System.getProperty(property.toString()));
        }
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            ContainerTestCase.getLogWriter().info("Unexpected interrupt during sleep");
        }
    }

    protected static class SystemPropertyFilter
    implements Filter<Object> {
        private static final List<String> systemProperties = new ArrayList<String>();

        @Override
        public boolean accept(Object obj) {
            return systemProperties.contains(obj);
        }

        public boolean add(String systemProperty) {
            return StringUtils.hasValue(systemProperty) && systemProperties.add(systemProperty);
        }

        public boolean remove(String systemProperty) {
            return systemProperties.remove(systemProperty);
        }
    }
}

