/*
 * Decompiled with CFR 0.152.
 */
package container.app.lang.support;

import container.app.lang.EventSource;
import container.app.util.Assert;
import container.app.util.ClassUtils;
import container.app.util.SystemUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public class EventSourceSupport<L extends EventListener>
implements EventSource<L>,
Iterable<L> {
    private final List<L> eventListeners = new ArrayList<L>(19);
    private final Object eventSource;

    public EventSourceSupport(Object source) {
        Assert.notNull(source, "The source object for the events generated cannot be null!", new Object[0]);
        this.eventSource = source;
    }

    public <T> T getSource() {
        return (T)this.eventSource;
    }

    @Override
    public boolean addEventListener(L eventListener) {
        Assert.notNull(eventListener, "The EventListener to add to the event source ({0}) cannot be null!", ClassUtils.getClassName(this.getSource()));
        return this.eventListeners.add(eventListener);
    }

    public void fireEvent(String eventHandlerMethodName, EventObject event) {
        Assert.hasValue(eventHandlerMethodName, "The name of the event handler method must be specified!", new Object[0]);
        Assert.notNull(event, MessageFormat.format("The event to fire from event source ({0}) should not be null!", ClassUtils.getClassName(this.getSource())), new Object[0]);
        EventListener currentEventListener = null;
        if (!this.eventListeners.isEmpty()) {
            try {
                currentEventListener = (EventListener)this.eventListeners.get(0);
                Method eventHandlerMethod = currentEventListener.getClass().getMethod(eventHandlerMethodName, event.getClass());
                Iterator<L> i$ = this.eventListeners.iterator();
                while (i$.hasNext()) {
                    EventListener eventListener;
                    currentEventListener = eventListener = (EventListener)i$.next();
                    eventHandlerMethod.invoke((Object)eventListener, event);
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(MessageFormat.format("No event handler method with signature {0}({1}) exists on EventListener class ({2})!", eventHandlerMethodName, ClassUtils.getClassName(event), ClassUtils.getClassName(currentEventListener)), e);
            }
            catch (InvocationTargetException e) {
                SystemUtils.printToStandardError("An error occurred while invoking event handler method ({0}) of EventListener ({1}): {2}", eventHandlerMethodName, ClassUtils.getClassName(currentEventListener), e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(MessageFormat.format("Failed to notify listeners of event ({0}) generated by event source ({1})!", event, ClassUtils.getClassName(this.getSource())), e);
            }
        }
    }

    @Override
    public Iterator<L> iterator() {
        return Collections.unmodifiableList(this.eventListeners).iterator();
    }

    @Override
    public boolean removeEventListener(L eventListener) {
        return this.eventListeners.remove(eventListener);
    }
}

