/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.dao;

import container.app.dao.support.DataAccessEvent;
import container.app.dao.support.DataAccessListener;
import container.app.lang.AbstractEventSource;
import container.app.lang.Visitor;
import container.app.phonedirectory.dao.PhoneDirectoryDao;
import container.app.phonedirectory.domain.Person;
import container.app.phonedirectory.domain.PhoneDirectoryEntry;
import container.app.phonedirectory.support.PhoneDirectoryEntryNotFoundException;
import container.app.util.Assert;
import java.text.MessageFormat;
import java.util.Collection;

public abstract class AbstractPhoneDirectoryDao
extends AbstractEventSource<DataAccessListener>
implements PhoneDirectoryDao {
    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public PhoneDirectoryEntry find(Person person) {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    @Override
    public PhoneDirectoryEntry load(Person person) {
        PhoneDirectoryEntry entry = this.find(person);
        Assert.notNull(entry, (RuntimeException)((Object)new PhoneDirectoryEntryNotFoundException(MessageFormat.format("Failed to find Phone Directory Entry for Person ({0})!", person))));
        return entry;
    }

    @Override
    public Collection<PhoneDirectoryEntry> loadAll() {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    @Override
    public PhoneDirectoryEntry remove(Person person) {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    @Override
    public PhoneDirectoryEntry save(PhoneDirectoryEntry entry) {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    protected void fireBeforeCreate(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.beforeCreate(event);
        }
    }

    protected void fireAfterCreate(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.afterCreate(event);
        }
    }

    protected void fireBeforeRetrieve(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.beforeRetrieve(event);
        }
    }

    protected void fireAfterRetrieve(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.afterRetrieve(event);
        }
    }

    protected void fireBeforeUpdate(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.beforeUpdate(event);
        }
    }

    protected void fireAfterUpdate(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.afterUpdate(event);
        }
    }

    protected void fireBeforeDelete(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.beforeDelete(event);
        }
    }

    protected void fireAfterDelete(DataAccessEvent event) {
        for (DataAccessListener listener : this) {
            listener.afterDelete(event);
        }
    }
}

