/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.dao.provider;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import container.app.lang.Configurable;
import container.app.lang.Destroyable;
import container.app.lang.Initable;
import container.app.phonedirectory.dao.AbstractPhoneDirectoryDao;
import container.app.phonedirectory.domain.Person;
import container.app.phonedirectory.domain.PhoneDirectoryEntry;
import container.app.util.Assert;
import container.app.util.IOUtils;
import container.app.util.StringUtils;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class CachingPhoneDirectoryDao
extends AbstractPhoneDirectoryDao
implements Initable,
Configurable<Properties>,
Destroyable {
    protected static final boolean DEFAULT_LAZY_INITIALIZE = false;
    private static Properties props;
    public static final String DEFAULT_GEMFIRE_CACHE_XML_FILE = "/container/app/phonedirectory/dao/provider/phoneDirectoryCache.xml";
    public static final String DEFAULT_GEMFIRE_CONFIGURATION_FILE = "/container/app/phonedirectory/dao/provider/gemfire.properties";
    public static final String DEFAULT_GEMFIRE_LOG_LEVEL = "warning";
    public static final String DEFAULT_GEMFIRE_MCAST_PORT = "56123";
    public static final String PHONE_DIRECTORY_CACHE_NAME = "CachingPhoneDirectoryDao";
    public static final String PHONE_DIRECTORY_REGION_PATH = "/phoneDirectory";
    private boolean configured = false;
    private boolean destroyed = false;
    private boolean initialized = false;
    private Cache phoneDirectoryCache;
    private Region<String, PhoneDirectoryEntry> phoneDirectoryRegion;

    public static InputStream getCacheConfiguration() {
        return IOUtils.open(CachingPhoneDirectoryDao.class.getResource(DEFAULT_GEMFIRE_CACHE_XML_FILE));
    }

    public static synchronized Properties getGemFireConfiguration() {
        if (props == null) {
            props = new Properties();
            try {
                props.load(CachingPhoneDirectoryDao.class.getResourceAsStream(DEFAULT_GEMFIRE_CONFIGURATION_FILE));
            }
            catch (Exception e) {
                props.setProperty("log-level", DEFAULT_GEMFIRE_LOG_LEVEL);
                props.setProperty("mcast-port", DEFAULT_GEMFIRE_MCAST_PORT);
            }
        }
        return props;
    }

    public CachingPhoneDirectoryDao() {
        this(false);
    }

    public CachingPhoneDirectoryDao(boolean lazyInitialize) {
        if (!lazyInitialize) {
            this.init();
        }
    }

    @Override
    public Properties getConfiguration() {
        return CachingPhoneDirectoryDao.getGemFireConfiguration();
    }

    @Override
    public synchronized boolean isConfigured() {
        return this.configured;
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void configure(Properties configuration) {
        CachingPhoneDirectoryDao.getGemFireConfiguration().putAll((Map<?, ?>)configuration);
        this.configured = true;
    }

    @Override
    public synchronized void destroy() {
        Assert.state(this.isInitialized(), "The Phone Directory DAO ({0}) is not currently initialized!", this.getClass().getName());
        this.phoneDirectoryCache.close();
        this.phoneDirectoryCache = null;
        this.phoneDirectoryRegion = null;
        this.configured = false;
        this.destroyed = true;
        this.initialized = false;
    }

    @Override
    public synchronized void init() {
        Assert.state(!this.isInitialized(), "The Phone Directory DAO ({0}) has been already been initialized!", this.getClass().getName());
        this.phoneDirectoryCache = new CacheFactory(CachingPhoneDirectoryDao.getGemFireConfiguration()).set("name", PHONE_DIRECTORY_CACHE_NAME).create();
        this.phoneDirectoryCache.loadCacheXml(CachingPhoneDirectoryDao.getCacheConfiguration());
        this.phoneDirectoryRegion = this.phoneDirectoryCache.getRegion(PHONE_DIRECTORY_REGION_PATH);
        this.configured = false;
        this.destroyed = false;
        this.initialized = true;
    }

    protected Cache getCache() {
        Assert.state(this.isInitialized(), "The Phone Directory DAO ({0}) is not initialized!", this.getClass().getName());
        return this.phoneDirectoryCache;
    }

    protected String getKey(PhoneDirectoryEntry entry) {
        Assert.notNull(entry, "The Phone Directory Entry used to construct a Region key cannot be null!", new Object[0]);
        return this.getKey(entry.getPerson());
    }

    protected String getKey(Person person) {
        Assert.notNull(person, "The Person used to construct a Region key cannot be null!", new Object[0]);
        String personsName = StringUtils.toLowerCase(person.getFullName());
        Assert.hasValue(personsName, "The Person's full name must be specified!", new Object[0]);
        return personsName;
    }

    protected Region<String, PhoneDirectoryEntry> getRegion() {
        Assert.state(this.isInitialized(), "The Phone Directory DAO ({0}) is not initialized!", this.getClass().getName());
        return this.phoneDirectoryRegion;
    }

    @Override
    public PhoneDirectoryEntry find(Person person) {
        return (PhoneDirectoryEntry)this.getRegion().get((Object)this.getKey(person));
    }

    @Override
    public Collection<PhoneDirectoryEntry> loadAll() {
        return this.getRegion().values();
    }

    @Override
    public PhoneDirectoryEntry remove(Person person) {
        return (PhoneDirectoryEntry)this.getRegion().destroy((Object)this.getKey(person));
    }

    @Override
    public PhoneDirectoryEntry save(PhoneDirectoryEntry entry) {
        this.getRegion().put((Object)this.getKey(entry), (Object)entry);
        return entry;
    }

    public String toString() {
        return "Caching Phone Directory DAO";
    }
}

