/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.domain;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import container.app.domain.AbstractDomainObject;
import container.app.util.Assert;
import container.app.util.DateTimeFormatUtils;
import container.app.util.DateTimeUtils;
import container.app.util.ObjectUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;

public class Person
extends AbstractDomainObject
implements DataSerializable {
    private static final long serialVersionUID = 112358L;
    private Calendar birthDate;
    private String firstName;
    private String lastName;

    public Person() {
    }

    public Person(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public Calendar getBirthDate() {
        return DateTimeUtils.copy(this.birthDate);
    }

    public void setBirthDate(Calendar birthDate) {
        this.birthDate = DateTimeUtils.copy(birthDate);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public final void setFirstName(String firstName) {
        Assert.hasValue(firstName, "The Person's first name must be specified!", new Object[0]);
        this.firstName = firstName;
    }

    public String getFullName() {
        StringBuilder buffer = new StringBuilder(this.getFirstName());
        buffer.append(" ");
        buffer.append(this.getLastName());
        return buffer.toString();
    }

    public String getLastName() {
        return this.lastName;
    }

    public final void setLastName(String lastName) {
        Assert.hasValue(lastName, "The Person's last name must be specified!", new Object[0]);
        this.lastName = lastName;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeLong((Long)DateTimeUtils.toMilliseconds(this.getBirthDate()), (DataOutput)out);
        DataSerializer.writeString((String)this.getFirstName(), (DataOutput)out);
        DataSerializer.writeString((String)this.getLastName(), (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        Long milliseconds = DataSerializer.readLong((DataInput)in);
        if (milliseconds != 0L) {
            this.birthDate = DateTimeUtils.fromMilliseconds(milliseconds);
        }
        this.firstName = DataSerializer.readString((DataInput)in);
        this.lastName = DataSerializer.readString((DataInput)in);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Person)) {
            return false;
        }
        Person that = (Person)obj;
        return ObjectUtils.equalsOrNull(this.getBirthDate(), that.getBirthDate()) && ObjectUtils.equalsOrNull(this.getFirstName(), that.getFirstName()) && ObjectUtils.equalsOrNull(this.getLastName(), that.getLastName());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getBirthDate());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getFirstName());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getLastName());
        return hashValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append("{birthDate = ").append(DateTimeFormatUtils.format(this.getBirthDate()));
        buffer.append(", firstName = ").append(this.getFirstName());
        buffer.append(", lastName = ").append(this.getLastName());
        buffer.append("}");
        return buffer.toString();
    }
}

