/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.service.provider;

import container.app.dao.support.DataAccessEvent;
import container.app.dao.support.DataAccessListenerAdapter;
import container.app.phonedirectory.dao.factory.PhoneDirectoryDaoFactory;
import container.app.phonedirectory.domain.Person;
import container.app.phonedirectory.domain.PhoneDirectoryEntry;
import container.app.phonedirectory.service.AbstractPhoneDirectoryService;
import container.app.util.Assert;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.Stack;

public class PhoneDirectoryServiceImpl
extends AbstractPhoneDirectoryService {
    private final Stack<DataAccessEvent> eventStack = new Stack();

    public PhoneDirectoryServiceImpl() {
        this.setDao(PhoneDirectoryDaoFactory.getPhoneDirectoryDao());
        this.getDao().addEventListener(new DataAccessEventTracker());
    }

    protected void assertValidEntry(PhoneDirectoryEntry entry) {
        Assert.notNull(entry, "The Phone Directory Entry to add or update cannot be null!", new Object[0]);
        Assert.notNull(entry.getPerson(), "The Phone Directory Entry must specify a Person with some contact information!", new Object[0]);
        boolean addressNotNull = entry.getAddress() != null;
        boolean phoneNumberNotNull = entry.getPhoneNumber() != null;
        Assert.state(addressNotNull || phoneNumberNotNull, MessageFormat.format("The Phone Directory Entry must specify either an Address or Phone Number with Person ({0})!", entry.getPerson()), new Object[0]);
    }

    @Override
    protected void addInternal(PhoneDirectoryEntry entry) {
        this.assertValidEntry(entry);
        this.getDao().save(entry);
    }

    @Override
    public <E extends EventObject> E consumePersistentEvent() throws RemoteException {
        return (E)(this.eventStack.isEmpty() ? null : this.eventStack.pop());
    }

    @Override
    public PhoneDirectoryEntry getEntry(Person person) throws RemoteException {
        return this.getDao().load(person);
    }

    @Override
    public Collection<PhoneDirectoryEntry> getEntries() throws RemoteException {
        return this.getDao().loadAll();
    }

    @Override
    public void remove(Person person) throws RemoteException {
        this.getDao().remove(person);
    }

    public String toString() {
        return "Phone Directory Service";
    }

    protected class DataAccessEventTracker
    extends DataAccessListenerAdapter {
        protected DataAccessEventTracker() {
        }

        @Override
        public void afterCreate(DataAccessEvent event) {
            PhoneDirectoryServiceImpl.this.eventStack.push(event);
        }

        @Override
        public void afterRetrieve(DataAccessEvent event) {
            PhoneDirectoryServiceImpl.this.eventStack.push(event);
        }

        @Override
        public void afterUpdate(DataAccessEvent event) {
            PhoneDirectoryServiceImpl.this.eventStack.push(event);
        }

        @Override
        public void afterDelete(DataAccessEvent event) {
            PhoneDirectoryServiceImpl.this.eventStack.push(event);
        }
    }
}

