/*
 * Decompiled with CFR 0.152.
 */
package container.app.remoting.rmi;

import container.app.util.Assert;
import container.app.util.ComposableFilter;
import container.app.util.DefaultFilter;
import container.app.util.Filter;
import container.app.util.StringUtils;
import container.app.util.Sys;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractRmiServiceExporter
implements Runnable {
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    public static final String DEFAULT_REGISTRY_HOST = "localhost";
    private boolean remoteObjectIsBound = false;
    private boolean running = false;
    private volatile Registry registry;
    private volatile Remote remoteObject;

    protected static synchronized void setSecurityManager() {
        if (System.getSecurityManager() == null) {
            Sys.out("Setting the RMISecurityManager on System...", new Object[0]);
            System.setSecurityManager(new RMISecurityManager());
        }
    }

    protected Registry getRegistry() throws RemoteException {
        if (this.registry == null) {
            try {
                Sys.out("Locating an RMI Registry running on ({0}) listening to port ({1})...", this.getRegistryHost(), this.getRegistryPort());
                this.registry = LocateRegistry.getRegistry(this.getRegistryHost(), this.getRegistryPort());
                this.registry.list();
            }
            catch (RemoteException e) {
                Sys.err("Could not find an RMI Registry running on ({0}) listening to port ({1}): {2}", this.getRegistryHost(), this.getRegistryPort(), e.getMessage());
                Sys.out("Attempting to create an RMI Registry on localhost listening to port ({0})...", this.getRegistryPort());
                this.registry = LocateRegistry.createRegistry(this.getRegistryPort());
            }
        }
        return this.registry;
    }

    protected String getRegistryHost() {
        return DEFAULT_REGISTRY_HOST;
    }

    protected int getRegistryPort() {
        return 1099;
    }

    protected <T extends Remote> T getRemoteObject() {
        Assert.state(this.remoteObject != null, "The remote object has not been exported, which occurs only during run!", new Object[0]);
        return (T)this.remoteObject;
    }

    private void setRemoteObject(Remote object) {
        this.remoteObject = object;
    }

    protected synchronized boolean isRemoteObjectBound() {
        return this.remoteObjectIsBound;
    }

    protected synchronized boolean isRunning() {
        return this.running;
    }

    protected abstract String getServiceNameForBinding();

    protected Filter<Object> getSystemPropertyFilter() {
        return ComposableFilter.composeAnd(new DefaultFilter(true), null);
    }

    protected abstract Remote exportRemoteObject() throws RemoteException;

    @Override
    public synchronized void run() {
        Assert.state(!this.isRunning(), "The remote object service ({0}) is already running!", this.getServiceNameForBinding());
        try {
            AbstractRmiServiceExporter.setSecurityManager();
            this.setRemoteObject(this.exportRemoteObject());
            this.getRegistry().rebind(this.getServiceNameForBinding(), (Remote)this.getRemoteObject());
            this.remoteObjectIsBound = true;
            this.running = true;
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format("Failed to run remote object service ({0})!", this.getServiceNameForBinding()), e);
        }
    }

    public void showAvailableServices() throws RemoteException {
        Sys.out("Available Remote Object Services: {0}", Arrays.asList(this.getRegistry().list()));
    }

    public void showGemFireState(Filter<Object> propertyFilter) {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    public void showSystemState(Filter<Object> systemPropertyFilter) {
        Assert.notNull(systemPropertyFilter, "The object used to filter the System properties cannot be null!", new Object[0]);
        for (Object property : System.getProperties().keySet()) {
            if (!systemPropertyFilter.accept(property)) continue;
            Sys.out("{0} = {1}", property, System.getProperty(property.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        try {
            if (this.running) {
                this.unbindRemoteObjectFromRegistry();
                this.unexportRemoteObject();
                this.setRemoteObject(null);
                this.stopRegistry();
            }
        }
        finally {
            this.running = false;
        }
    }

    protected void stopRegistry() {
        try {
            if (this.registry != null) {
                int serviceCount = this.registry.list().length;
                Sys.out("The number of services in the registry is {0}.", serviceCount);
                if (serviceCount == 0) {
                    if (UnicastRemoteObject.unexportObject(this.registry, true)) {
                        this.stopNonDaemonRmiThreads();
                        this.registry = null;
                        Sys.out("The Registry was successfully unexported.", new Object[0]);
                    } else {
                        Sys.out("The Registry could not be unexported due to unknown reasons.", new Object[0]);
                    }
                } else {
                    Sys.out("Warning, the registry was found with services still bound.", new Object[0]);
                }
            }
        }
        catch (NoSuchObjectException e) {
            Sys.err("The RMI Registry is not currently exported: {0}", e.getMessage());
        }
        catch (RemoteException e) {
            Sys.err("Failed to find an RMI Registry on host ({0}) listening to port ({1}): {2}", this.getRegistryHost(), this.getRegistryPort(), e.getMessage());
        }
    }

    private void stopNonDaemonRmiThreads() {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!"RMI Reaper".equals(t.getName())) continue;
            t.interrupt();
        }
    }

    protected void unbindRemoteObjectFromRegistry() throws RemoteException {
        if (this.remoteObjectIsBound) {
            try {
                Sys.out("Unbinding remote object from service name ({0}) in registry...", this.getServiceNameForBinding());
                this.getRegistry().unbind(this.getServiceNameForBinding());
                this.remoteObjectIsBound = false;
            }
            catch (NotBoundException e) {
                Sys.err("No remote object was bound to service name ({0}) in registry: {1}", this.getServiceNameForBinding(), e.getMessage());
                this.remoteObjectIsBound = false;
            }
        }
    }

    protected void unexportRemoteObject() throws RemoteException {
        try {
            UnicastRemoteObject.unexportObject(this.getRemoteObject(), true);
        }
        catch (NoSuchObjectException e) {
            Sys.err("The remote object ({0}) is not currently exported: {1}", this.getServiceNameForBinding(), e.getMessage());
        }
    }

    protected static class SystemPropertyFilter
    implements Filter<Object> {
        private static final List<String> systemProperties = new ArrayList<String>();

        @Override
        public boolean accept(Object obj) {
            return systemProperties.contains(obj);
        }

        public boolean add(String systemProperty) {
            return StringUtils.hasValue(systemProperty) && systemProperties.add(systemProperty);
        }

        public boolean remove(String systemProperty) {
            return systemProperties.remove(systemProperty);
        }
    }
}

