/*
 * Decompiled with CFR 0.152.
 */
package container.app.util;

import container.app.util.Assert;
import container.app.util.Filter;

public abstract class ComposableFilter<T>
implements Filter<T> {
    private final Filter<T> leftFilter;
    private final Filter<T> rightFilter;

    protected ComposableFilter(Filter<T> leftFilter, Filter<T> rightFilter) {
        this.leftFilter = leftFilter;
        this.rightFilter = rightFilter;
    }

    public static <T> Filter<T> composeAnd(Filter<T> leftFilter, Filter<T> rightFilter) {
        return ComposableFilter.compose(leftFilter, rightFilter, new AndFilter<T>(leftFilter, rightFilter));
    }

    public static <T> Filter<T> composeOr(Filter<T> leftFilter, Filter<T> rightFilter) {
        return ComposableFilter.compose(leftFilter, rightFilter, new OrFilter<T>(leftFilter, rightFilter));
    }

    protected static <T> Filter<T> compose(Filter<T> leftFilter, Filter<T> rightFilter, ComposableFilter<T> composedFilter) {
        return leftFilter == null ? rightFilter : (rightFilter == null ? leftFilter : composedFilter);
    }

    protected Filter<T> getLeftFilter() {
        Assert.state(this.leftFilter != null, "The left Filter object was not properly set!", new Object[0]);
        return this.leftFilter;
    }

    protected Filter<T> getRightFilter() {
        Assert.state(this.rightFilter != null, "The right Filter object was not properly set!", new Object[0]);
        return this.rightFilter;
    }

    protected static final class OrFilter<T>
    extends ComposableFilter<T> {
        public OrFilter(Filter<T> leftFilter, Filter<T> rightFilter) {
            super(leftFilter, rightFilter);
        }

        @Override
        public boolean accept(T obj) {
            return this.getLeftFilter().accept(obj) || this.getRightFilter().accept(obj);
        }
    }

    protected static final class AndFilter<T>
    extends ComposableFilter<T> {
        public AndFilter(Filter<T> leftFilter, Filter<T> rightFilter) {
            super(leftFilter, rightFilter);
        }

        @Override
        public boolean accept(T obj) {
            return this.getLeftFilter().accept(obj) && this.getRightFilter().accept(obj);
        }
    }
}

