/*
 * Decompiled with CFR 0.152.
 */
package container.app.util;

import java.text.StringCharacterIterator;

public final class StringUtils {
    public static final String NOT_IMPLEMENTED = "Not Implemented!";
    public static final String OPERATION_NOT_SUPPORTED = "Operation Not Supported!";

    public static String defaultIfNoValue(String value, String defaultValue) {
        return StringUtils.hasValue(value) ? value : defaultValue;
    }

    public static boolean hasValue(String value) {
        return !StringUtils.isWorthless(value);
    }

    public static boolean isBlank(String value) {
        return StringUtils.length(value) > 0 && "".equals(StringUtils.trim(value));
    }

    public static boolean isEmpty(String value) {
        return "".equals(value);
    }

    public static boolean isWorthless(String value) {
        return value == null || StringUtils.isEmpty(value) || StringUtils.isBlank(value);
    }

    public static int length(String value) {
        return value == null ? 0 : value.length();
    }

    public static String reverse(String value) {
        if (value != null) {
            StringCharacterIterator it = new StringCharacterIterator(value);
            StringBuilder buffer = new StringBuilder();
            char c = it.last();
            while (c != '\uffff') {
                buffer.append(c);
                c = it.previous();
            }
            return buffer.toString();
        }
        return value;
    }

    public static String[] split(String value) {
        return StringUtils.split(value, "\\s");
    }

    public static String[] split(String value, String regex) {
        return value != null ? value.split(regex) : new String[]{};
    }

    public static String toLowerCase(String value) {
        return value == null ? null : value.toLowerCase();
    }

    public static String toUpperCase(String value) {
        return value == null ? null : value.toUpperCase();
    }

    public static String trim(String value) {
        return value == null ? null : value.trim();
    }
}

