/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import cq.CQHistory;
import cq.CQTest;
import cq.CQUtilBB;
import hydra.Log;
import hydra.ProcessMgr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import util.AbstractListener;
import util.QueryObject;
import util.TestException;

public class CQHistoryListener
extends AbstractListener
implements CqListener {
    private static Map globalHistoryMap = Collections.synchronizedMap(new HashMap());
    private static final String ErrorKey = "ErrorKey";

    public static CQHistory getCQHistory(String cqName) {
        return (CQHistory)globalHistoryMap.get(cqName);
    }

    public static void recordHistory(CQHistory history) {
        Object anObj = globalHistoryMap.get(history.getCqName());
        if (anObj != null) {
            throw new TestException("Test problem; history already exists for " + history.getCqName());
        }
        globalHistoryMap.put(history.getCqName(), history);
    }

    public static void checkForError() {
        String errStr = (String)CQUtilBB.getBB().getSharedMap().get(ErrorKey);
        if (errStr != null) {
            throw new TestException("Error occurred in CQHistoryListener: " + errStr);
        }
    }

    public void onError(CqEvent aCqEvent) {
        String listenerStr = this.toString("onError", aCqEvent);
        Log.getLogWriter().info(listenerStr);
        CQUtilBB.getBB().getSharedMap().put(ErrorKey, listenerStr);
    }

    public void onEvent(CqEvent event) {
        String eventStr = this.logCQEventAsSummary("onEvent", event);
        String cqName = event.getCq().getName();
        String queryStr = event.getCq().getQueryString();
        CQHistory history = (CQHistory)globalHistoryMap.get(cqName);
        history.addEvent(event);
        boolean newValueShouldSatisfyQuery = true;
        Operation op = event.getQueryOperation();
        if (op.equals(Operation.CREATE)) {
            newValueShouldSatisfyQuery = true;
        } else if (op.equals(Operation.DESTROY)) {
            newValueShouldSatisfyQuery = false;
        } else if (op.equals(Operation.INVALIDATE)) {
            newValueShouldSatisfyQuery = true;
        } else if (op.equals(Operation.UPDATE)) {
            newValueShouldSatisfyQuery = true;
        }
        QueryObject qo = (QueryObject)event.getNewValue();
        boolean satisfied = CQTest.satisfiesQuery(queryStr, qo);
        if (newValueShouldSatisfyQuery) {
            if (!satisfied) {
                String errStr = "Validation failure in pid " + ProcessMgr.getProcessId() + " CQHistoryListener, " + eventStr + ", query " + cqName + ", " + CQTest.getReadableQueryString(queryStr) + " is not satisfied by " + qo.toStringFull();
                Log.getLogWriter().info(errStr);
                CQUtilBB.getBB().getSharedMap().put(ErrorKey, errStr);
            }
        } else if (satisfied) {
            String errStr = "Validation failure in pid " + ProcessMgr.getProcessId() + " CQHistoryListener, " + eventStr + ", query " + cqName + ", " + CQTest.getReadableQueryString(queryStr) + " is satisfied by " + qo.toStringFull() + " but it should not be";
            Log.getLogWriter().info(errStr);
            CQUtilBB.getBB().getSharedMap().put(ErrorKey, errStr);
        }
    }

    public void close() {
        Log.getLogWriter().info("Invoked CQHistoryListener.close()");
    }
}

