/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.pdx.PdxInstance;
import cq.CQGatherListener;
import cq.CQTest;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import getInitialImage.InitImagePrms;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientCachePrms;
import hydra.DiskStoreDescription;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolHelper;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import util.CacheUtil;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class CQTestVersionHelper {
    protected CQTest testInstance;
    protected boolean isClientCache = false;

    public CQTestVersionHelper(CQTest testInstance) {
        this.testInstance = testInstance;
    }

    public static void setTxMgr() {
        if (InitImagePrms.useTransactions()) {
            TxHelper.setTransactionManager();
        }
    }

    public GemFireCache getCache() {
        ClientCache cache = this.isClientCache ? ClientCacheHelper.getCache() : CacheHelper.getCache();
        return cache;
    }

    public void closeCache() {
        if (this.isClientCache) {
            ClientCacheHelper.closeCache();
        } else {
            CacheHelper.closeCache();
        }
    }

    public Region initializeRegion(String regDescriptName) {
        String key;
        String xmlFile;
        File aFile;
        boolean isBridgeConfiguration;
        HydraVector clientCacheNames = TestConfig.tab().vecAt(ClientCachePrms.names, null);
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        boolean bl = isBridgeConfiguration = bridgeNames != null;
        if (isBridgeConfiguration && regDescriptName.toLowerCase().startsWith("client") && clientCacheNames != null) {
            this.isClientCache = true;
        }
        if (!(aFile = new File(xmlFile = (key = "VmId_" + RemoteTestModule.getMyVmid()) + ".xml")).exists()) {
            if (this.isClientCache) {
                ClientCacheHelper.createCache("clientCache");
                ClientCacheHelper.generateCacheXmlFile("clientCache", regDescriptName, xmlFile);
            } else {
                DiskStoreDescription dsd = RegionHelper.getRegionDescription(regDescriptName).getDiskStoreDescription();
                String diskStoreName = null;
                if (dsd != null) {
                    diskStoreName = dsd.getName();
                }
                Log.getLogWriter().info("About to generate xml, diskStoreName is " + diskStoreName);
                CacheHelper.createCache("cache1");
                CacheHelper.generateCacheXmlFile("cache1", null, regDescriptName, null, null, null, diskStoreName, null, xmlFile);
            }
        }
        Region aRegion = null;
        aRegion = this.isClientCache ? CacheUtil.createClientRegion("clientCache", regDescriptName, xmlFile) : CacheUtil.createRegion("cache1", regDescriptName, xmlFile);
        Log.getLogWriter().info("After creating " + aRegion.getFullPath() + ", region is size " + aRegion.size());
        return aRegion;
    }

    public void initializeQueryService() {
        try {
            String usingPool = TestConfig.tab().stringAt(CQUtilPrms.QueryServiceUsingPool, "false");
            boolean queryServiceUsingPool = Boolean.valueOf(usingPool);
            if (this.isClientCache) {
                Pool pool = PoolHelper.createPool(CQUtilPrms.getQueryServicePoolName());
                this.testInstance.qService = ClientCacheHelper.getCache().getQueryService(pool.getName());
                Log.getLogWriter().info("Initializing QueryService using ClientCache and Pool: " + pool.getName());
            } else if (queryServiceUsingPool) {
                Pool pool = PoolHelper.createPool(CQUtilPrms.getQueryServicePoolName());
                this.testInstance.qService = pool.getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Pool. PoolName: " + pool.getName());
            } else {
                this.testInstance.qService = CacheHelper.getCache().getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Cache.");
            }
            Log.getLogWriter().info("Done creating QueryService");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void doEntryOperations(Region aRegion) {
        Log.getLogWriter().info("In doEntryOperations with " + aRegion.getFullPath());
        int numOpsPerTask = TestConfig.tab().intAt(CQUtilPrms.numOpsPerTask, Integer.MAX_VALUE);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        long minTaskGranularityMS = minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : minTaskGranularitySec * 1000L;
        boolean isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        boolean highAvailability = TestConfig.tab().booleanAt(CQUtilPrms.highAvailability, false);
        boolean isBridgeClient = aRegion.getAttributes().getPoolName() != null;
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        boolean useTransactions = InitImagePrms.useTransactions();
        if (!useTransactions || !highAvailability || isBridgeClient) {
            // empty if block
        }
        do {
            boolean rolledback = false;
            if (useTransactions) {
                TxHelper.begin();
                if (isBridgeClient && isSerialExecution) {
                    this.testInstance.saveRegionSnapshot();
                }
            }
            try {
                this.testInstance.doRandomOp(aRegion);
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions || useTransactions && !highAvailability) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + ", " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with HA, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (TransactionDataRebalancedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + ". " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    if (!highAvailability) {
                        throw new TestException("Unexpected Exception " + (Object)((Object)e) + ", " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + " on commit.  Expected with HA, continuing test.");
                    if (isSerialExecution && isBridgeClient) {
                        this.testInstance.restoreRegionSnapshot();
                    }
                }
                catch (TransactionDataRebalancedException e) {
                    if (highAvailability) {
                        Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with HA, continuing test.");
                        if (isSerialExecution && isBridgeClient) {
                            this.testInstance.restoreRegionSnapshot();
                        }
                    }
                }
                catch (TransactionInDoubtException e) {
                    if (!highAvailability) {
                        Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
                    } else {
                        Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + " on commit.  Expected with concurrent execution, continuing test.");
                        if (isSerialExecution && isBridgeClient) {
                            this.testInstance.restoreRegionSnapshot();
                        }
                        this.recordFailedOps(CQUtilBB.INDOUBT_TXOPS);
                    }
                }
                catch (CommitConflictException e) {
                    if (isSerialExecution) {
                        throw new TestException("Unexpected " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + " on commit. Expected with concurrent execution, continuing test.");
                }
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task, region size is " + aRegion.size());
            CQGatherListener.checkForError();
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS && numOps < numOpsPerTask);
        Log.getLogWriter().info("Done in doEntryOperations with " + aRegion.getFullPath() + ", completed " + numOps + " ops in " + (System.currentTimeMillis() - startTime) + " millis");
    }

    protected void recordFailedOps(String sharedMapKey) {
    }

    public static void putSnapshot(Map snapshot) {
        HashMap alteredSnapshot = new HashMap();
        for (Object key : snapshot.keySet()) {
            Object value = snapshot.get(key);
            if (value == null) {
                alteredSnapshot.put(key, value);
                continue;
            }
            if (value instanceof PdxInstance) {
                alteredSnapshot.put(key, PdxTestVersionHelper.toBaseObject(value));
                continue;
            }
            String className = value.getClass().getName();
            if (className.equals("util.PdxVersionedQueryObject") || className.equals("util.VersionedQueryObject")) {
                Map<String, Object> fieldMap = PdxTest.getFieldMap(value);
                alteredSnapshot.put(key, fieldMap);
                continue;
            }
            alteredSnapshot.put(key, value);
        }
        CQUtilBB.getBB().getSharedMap().put("RegionSnapshot", alteredSnapshot);
    }
}

