/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.SelectResults;
import cq.CQUtil;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import cq.ConcCQBB;
import cq.ConcCQMultRegionsClient;
import cq.ConcCQTest;
import cq.IndexTest;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mapregion.MapPrms;
import parReg.query.Position;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class ConcCQAndOpsTest
extends ConcCQTest {
    protected static ConcCQAndOpsTest concCQAndOpsTest;
    protected int sleepMS = 10000;
    private boolean edgePutAndVerify;
    protected static CQUtilBB cqBB;
    protected boolean createIndex = false;
    protected boolean createPrimaryIndex = TestConfig.tab().booleanAt(CQUtilPrms.createPrimaryIndex, false);

    public static synchronized void HydraTask_initialize() {
        if (concCQAndOpsTest == null) {
            concCQAndOpsTest = new ConcCQAndOpsTest();
            concCQAndOpsTest.initialize();
        }
    }

    @Override
    protected void initialize() {
        try {
            if (cqBB.getSharedMap().get("VerifyFlag") == null) {
                this.initFlags();
            }
        }
        catch (NullPointerException e) {
            this.initFlags();
        }
        try {
            this.edgePutAndVerify = TestConfig.tab().booleanAt(CQUtilPrms.edgePutAndVerify);
        }
        catch (HydraConfigException e) {
            this.edgePutAndVerify = false;
        }
        ConcCQTest.initServerWithMultRegions();
        this.createIndex = TestConfig.tab().booleanAt(CQUtilPrms.createIndex, false);
        if (this.createIndex) {
            this.createIndex();
        }
    }

    protected void createIndex() {
        IndexTest indexTest = new IndexTest();
        String[] regionNames = MapPrms.getRegionNames();
        for (int i = 0; i < regionNames.length; ++i) {
            if (!this.createPrimaryIndex) continue;
            try {
                indexTest.createIndex(regionNames[i]);
                throw new TestException("Bug 38119 is detected. After setting value constraint and creating primary index  -- IndexType.PRIMARY_KEY on a non-existing field product did not throw IndexInvalidException.");
            }
            catch (IndexInvalidException e) {
                Log.getLogWriter().info("Got expected IndexInvalidException, continuing tests");
                indexTest.createPrimaryIndex(regionNames[i]);
            }
        }
    }

    protected void initFlags() {
        cqBB.getSharedMap().put("VerifyFlag", new Boolean(false));
        cqBB.getSharedMap().put("EntryDone", new Boolean(false));
        cqBB.getSharedMap().put("VerifyDone", new Boolean(false));
        cqBB.getSharedCounters().zero(CQUtilBB.EntryPerformed);
        cqBB.getSharedCounters().zero(CQUtilBB.Verified);
        cqBB.getSharedCounters().zero(CQUtilBB.NumCounterToDestroy);
        Log.getLogWriter().info("Init the BB varibles");
    }

    public static void HydraTask_verify() {
        concCQAndOpsTest.verify();
    }

    public static void HydraTask_doCQAndVerifyResults() {
        concCQAndOpsTest.performCQOpsAndVerifyResults();
    }

    protected void verify() {
        boolean verify = (Boolean)cqBB.getSharedMap().get("VerifyFlag");
        boolean verifyDone = (Boolean)cqBB.getSharedMap().get("VerifyDone");
        if (!verify || verifyDone) {
            if (this.edgePutAndVerify) {
                return;
            }
            MasterController.sleepForMs(this.sleepMS);
            return;
        }
        long verified = cqBB.getSharedCounters().incrementAndRead(CQUtilBB.Verified);
        Log.getLogWriter().info("verified so far is " + verified);
        if (verified > (long)ConcCQMultRegionsClient.verifyCount) {
            return;
        }
        if (verified == (long)ConcCQMultRegionsClient.verifyCount) {
            cqBB.getSharedMap().put("VerifyDone", new Boolean(true));
            Log.getLogWriter().info("reset verifyDone to true");
            this.verifySelectResults();
            MasterController.sleepForMs(this.sleepMS);
            cqBB.getSharedMap().put("VerifyFlag", new Boolean(false));
            Log.getLogWriter().info("reset verifyFlag to false");
            cqBB.getSharedCounters().zero(CQUtilBB.Verified);
            cqBB.getSharedMap().put("VerifyDone", new Boolean(false));
        } else if (((Boolean)cqBB.getSharedMap().get("VerifyFlag")).booleanValue()) {
            this.verifySelectResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySelectResults() {
        CqQuery cq = null;
        SelectResults results = null;
        cq = this.getCQForOp();
        if (cq != null) {
            this.stopCQ(cq);
            Log.getLogWriter().info("Stopping CQ and to get initial results.");
            String qs = cq.getQueryString();
            String regionName = qs.substring(15, 26);
            if (cq.isClosed()) {
                this.reRegisterCQ(cq);
            }
            try {
                CqResults rs = cq.executeWithInitialResults();
                results = CQUtil.getSelectResults(rs);
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            List list = cqList;
            synchronized (list) {
                cqList.remove(cq);
            }
            this.verifyFromSnapshots(results, regionName);
        }
    }

    @Override
    protected CqQuery getNextRandonCQ() {
        CqQuery cq = null;
        CqQuery[] cqArray = cqService.getCqs();
        int randInt = (int)(System.currentTimeMillis() % (long)cqArray.length);
        cq = cqArray[randInt];
        return cq;
    }

    protected void verifyFromSnapshots(SelectResults results, String regionName) {
        List dataFromSnapshots = this.getDataFromSnapshots(regionName);
        List resultsList = results.asList();
        Log.getLogWriter().info("regionName is " + regionName);
        Log.getLogWriter().info("size of selectResults is " + results.size());
        Log.getLogWriter().info("size of qualified data from snapshots is " + dataFromSnapshots.size());
        ArrayList dataFromSnapshotsCopy = new ArrayList(dataFromSnapshots);
        ArrayList resultsListCopy = new ArrayList(resultsList);
        resultsListCopy.removeAll(dataFromSnapshots);
        ArrayList unexpected = resultsListCopy;
        dataFromSnapshotsCopy.removeAll(resultsList);
        ArrayList missing = dataFromSnapshotsCopy;
        StringBuffer aStr = new StringBuffer();
        if (unexpected.size() > 0) {
            aStr.append("the following " + unexpected.size() + " unexpected elements in SelectResults: " + Position.toString(unexpected));
        }
        if (missing.size() > 0) {
            aStr.append("the following " + missing.size() + " elements were missing from SelectResults: " + Position.toString(missing));
        }
        if (aStr.length() != 0) {
            throw new TestException(aStr.toString());
        }
        if (dataFromSnapshots.size() != results.size()) {
            if (dataFromSnapshots.size() < results.size()) {
                throw new TestException("There are more data in selectResults");
            }
            throw new TestException("There are fewer data in selectResults");
        }
        Log.getLogWriter().info("verified that results are correct");
    }

    protected List getDataFromSnapshots(String regionName) {
        Set dataFromBB = ConcCQBB.getBB().getSharedMap().getMap().entrySet();
        ArrayList<Position> dataList = new ArrayList<Position>();
        for (Map.Entry m : dataFromBB) {
            String key = (String)m.getKey();
            Object value = m.getValue();
            if (!(value instanceof Position)) continue;
            Position aPosition = (Position)m.getValue();
            if (!key.startsWith(regionName + "_Object")) continue;
            dataList.add(aPosition);
        }
        return dataList;
    }

    protected void performCQOpsAndVerifyResults() {
        boolean verify = (Boolean)cqBB.getSharedMap().get("VerifyFlag");
        if (verify) {
            this.verify();
        } else {
            super.performCQOperations();
        }
    }

    public static void verifyCQListener() {
        concCQAndOpsTest.verifyEvents();
    }

    @Override
    protected void verifyEvents() {
        Log.getLogWriter().info("verifyEvents");
        try {
            super.verifyEvents();
        }
        catch (TestException e) {
            String str = null;
            this.createIndex = TestConfig.tab().booleanAt(CQUtilPrms.createIndex, false);
            if (!this.createIndex) {
                str = ConcCQAndOpsTest.checkFromListener();
            }
            throw new TestException(e.getMessage() + str);
        }
    }

    public static String checkFromListener() {
        StringBuffer str = new StringBuffer();
        long counter = NameFactory.getPositiveNameCounter();
        int numEdges = MapPrms.getNumEdges();
        int[] array = new int[(int)counter + 1];
        int i = 1;
        while ((long)i <= counter) {
            array[i] = 0;
            ++i;
        }
        str.append("May have incorrect number of cq event invocations for the following objects:");
        Set aSet = cqBB.getSharedMap().getMap().entrySet();
        Iterator itr = aSet.iterator();
        HashSet<String> keySet = new HashSet<String>();
        HashSet<String> objectSet = new HashSet<String>();
        while (itr.hasNext()) {
            int arrayPosition;
            Map.Entry m = itr.next();
            String key = (String)m.getKey();
            if (!key.startsWith("Object")) continue;
            String[] strArray = key.split(":");
            String name = strArray[0];
            keySet.add(name);
            String objectNumber = name.substring(7);
            int n = arrayPosition = Integer.parseInt(objectNumber);
            array[n] = array[n] + 1;
        }
        int i2 = 1;
        while ((long)i2 <= counter) {
            objectSet.add("Object_" + i2);
            ++i2;
        }
        objectSet.removeAll(keySet);
        itr = objectSet.iterator();
        while (itr.hasNext()) {
            str.append(" " + itr.next() + " ");
        }
        str.append("\n some edges may miss cq events on the following objects: ");
        i2 = 1;
        while ((long)i2 <= counter) {
            if (array[i2] % numEdges != 0) {
                str.append(" Object_" + i2 + " ");
            }
            ++i2;
        }
        return str.toString();
    }

    static {
        cqBB = CQUtilBB.getBB();
    }
}

