/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import cq.ConcCQAndOpsTest;
import cq.ConcCQBB;
import cq.ConcCQTest;
import cq.MultRegionsClient;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import mapregion.MapBB;
import mapregion.MapPrms;
import parReg.query.Position;
import util.NameFactory;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;

public class ConcCQMultRegionsClient
extends MultRegionsClient {
    public static ConcCQMultRegionsClient concCQMultRegionsClient;
    protected int entryOperations;
    static int verifyCount;
    protected int sleepMS = 10000;
    protected long minPerformEntryTime = 20000L;
    private int maxQty = 100;
    protected int maxPrice = 100;
    private int numOfSecurities = 200;
    private int numOfPutOpsByEdges;
    private int putCountByEdges = 0;
    protected boolean createIndex = false;
    protected String thePrimarySecId = TestConfig.tab().stringAt(CQUtilPrms.primary, "0");
    protected boolean testPrimaryIndex = TestConfig.tab().booleanAt(CQUtilPrms.testPrimaryIndex, false);

    public static synchronized void HydraTask_initialize() {
        if (concCQMultRegionsClient == null) {
            ConcCQTest.testInstance = new ConcCQTest();
            ConcCQAndOpsTest.concCQAndOpsTest = new ConcCQAndOpsTest();
            concCQMultRegionsClient = new ConcCQMultRegionsClient();
            verifyCount = TestConfig.tab().intAt(CQUtilPrms.edgeThreads);
            concCQMultRegionsClient.initialize();
        }
    }

    @Override
    protected void initialize() {
        try {
            this.entryOperations = TestConfig.tab().intAt(CQUtilPrms.feederThreads);
        }
        catch (HydraConfigException e) {
            this.entryOperations = TestConfig.tab().intAt(CQUtilPrms.edgeThreads);
        }
        try {
            this.numOfPutOpsByEdges = TestConfig.tab().intAt(CQUtilPrms.edgeThreadsPerVM);
        }
        catch (HydraConfigException hydraConfigException) {
            // empty catch block
        }
        this.createIndex = TestConfig.tab().booleanAt(CQUtilPrms.createIndex, false);
        super.initialize();
    }

    public static void HydraTask_performEntryOperationsWithVerification() {
        concCQMultRegionsClient.performEntryOperationsWithVerification();
        ConcCQMultRegionsClient.releaseConnections();
    }

    public static void HydraTask_performEntryOperationsWithoutVerification() {
        concCQMultRegionsClient.doEntry();
        ConcCQMultRegionsClient.releaseConnections();
    }

    protected void performEntryOperationsWithVerification() {
        boolean verify = (Boolean)CQUtilBB.getBB().getSharedMap().get("VerifyFlag");
        boolean entryDone = (Boolean)CQUtilBB.getBB().getSharedMap().get("EntryDone");
        if (verify || entryDone) {
            MasterController.sleepForMs(this.sleepMS);
            return;
        }
        long entryPerformed = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.EntryPerformed);
        if (entryPerformed > (long)this.entryOperations) {
            return;
        }
        if (entryPerformed == (long)this.entryOperations) {
            CQUtilBB.getBB().getSharedMap().put("EntryDone", new Boolean(true));
            Log.getLogWriter().info("reset entryDone to true");
            this.doEntry();
            SilenceListener.waitForSilence(30L, 5000L);
            CQUtilBB.getBB().getSharedMap().put("VerifyFlag", new Boolean(true));
            Log.getLogWriter().info("reset verifyFlag to true");
            CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.EntryPerformed);
            CQUtilBB.getBB().getSharedMap().put("EntryDone", new Boolean(false));
        } else {
            this.doEntry();
        }
    }

    protected void doEntry() {
        long startTime = System.currentTimeMillis();
        do {
            super.performEntryOperations();
        } while (System.currentTimeMillis() - startTime < this.minPerformEntryTime);
    }

    public static void HydraTask_putSameObject() {
        concCQMultRegionsClient.putSameObject();
    }

    protected void putSameObject() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        Region region = RegionHelper.getRegion(regionName);
        int numOfPutSameKey = 10;
        int fix = 1;
        Position pos = new Position();
        pos.init(fix);
        for (int i = 0; i < numOfPutSameKey; ++i) {
            region.put((Object)"Object_0", (Object)pos);
            Log.getLogWriter().info("put the same Object");
            MapBB.getBB().getSharedCounters().increment(MapBB.NUM_PUT);
            MasterController.sleepForMs(5000);
        }
    }

    @Override
    protected void putObject(String regionName) {
        Region region = RegionHelper.getRegion(regionName);
        String name = NameFactory.getNextPositiveObjectName();
        Object anObj = this.getObjectToAdd(name);
        try {
            region.put((Object)name, anObj);
            Log.getLogWriter().info("put this key " + name + " and value " + anObj.toString());
            if (this.createIndex) {
                if (this.testPrimaryIndex && ((Position)anObj).getSecId().equals(this.thePrimarySecId)) {
                    this.updateBBForPuts(regionName, name, anObj);
                }
            } else {
                this.updateBBForPuts(regionName, name, anObj);
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(region, e);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_invalidateSameKey() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        concCQMultRegionsClient.invalidateSameKey(regionName);
    }

    protected void invalidateSameKey(String regionName) {
        MasterController.sleepForMs(20000);
        Region region = RegionHelper.getRegion(regionName);
        int numOfInvalidateSameKey = 10;
        String key = null;
        if (region != null) {
            Set aSet = region.keySet();
            while (aSet == null) {
                aSet = region.keySet();
            }
            Iterator itr = aSet.iterator();
            if (itr.hasNext()) {
                key = (String)itr.next();
            }
        }
        if (key != null) {
            for (int i = 0; i < numOfInvalidateSameKey; ++i) {
                Log.getLogWriter().info("the key to be invalidated is " + key);
                region.invalidate((Object)key);
                MapBB.getBB().getSharedCounters().increment(MapBB.NUM_INVALIDATE);
                MasterController.sleepForMs(5000);
            }
        }
    }

    protected void updateBBForPuts(String regionName, String name, Object anObj) {
        MapBB.getBB().getSharedCounters().increment(MapBB.NUM_PUT);
        String key = null;
        key = this.testPrimaryIndex ? regionName + "_Object_" + name : regionName + "_" + name;
        ConcCQBB.getBB().getSharedMap().put(key, anObj);
    }

    protected Object getObjectToAdd(String name) {
        if (this.testPrimaryIndex) {
            return this.getObjectToAddForPrimaryIndex(name);
        }
        int counter = (int)NameFactory.getCounterForName(name);
        Properties props = new Properties();
        Double qty = new Double(rnd.nextInt(this.maxQty) * 100);
        Double mktValue = new Double(rnd.nextDouble() * (double)this.maxPrice);
        Integer secId = new Integer(counter % this.numOfSecurities);
        props.setProperty("qty", qty.toString());
        props.setProperty("secId", secId.toString());
        props.setProperty("mktValue", mktValue.toString());
        Position aPosition = new Position();
        aPosition.init(props);
        return aPosition;
    }

    protected Object getObjectToAddForPrimaryIndex(String name) {
        Properties props = new Properties();
        Double qty = new Double(rnd.nextInt(this.maxQty) * 100);
        Double mktValue = new Double(rnd.nextDouble() * (double)this.maxPrice);
        props.setProperty("qty", qty.toString());
        props.setProperty("secId", name);
        props.setProperty("mktValue", mktValue.toString());
        Position aPosition = new Position();
        aPosition.init(props);
        return aPosition;
    }

    @Override
    protected void putAllObjects(String regionName) {
        this.putObject(regionName);
    }

    @Override
    protected void removeObject(String regionName) {
        String key = null;
        long counter = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.NumCounterToDestroy);
        Region region = RegionHelper.getRegion(regionName);
        if (region != null) {
            Object got;
            int temp = rnd.nextInt(2);
            String string = key = temp > 0 ? this.thePrimarySecId : NameFactory.getObjectNameForCounter(counter);
            if (counter <= 100L) {
                MasterController.sleepForMs(1000);
            }
            if (counter <= 100L) {
                MasterController.sleepForMs(1000);
            }
            if (counter <= 100L) {
                MasterController.sleepForMs(1000);
            }
            if ((got = region.get((Object)key)) != null) {
                region.remove((Object)key);
                Log.getLogWriter().info("successfully removed this key: " + key + " and value " + got.toString());
                if (this.createIndex) {
                    if (this.testPrimaryIndex && ((Position)got).getSecId().equals(this.thePrimarySecId)) {
                        this.updateBBForRemoves(regionName, key);
                    }
                } else {
                    this.updateBBForRemoves(regionName, key);
                }
            }
        }
    }

    protected void updateBBForRemoves(String regionName, String key) {
        MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_REMOVE);
        key = this.testPrimaryIndex ? regionName + "_Object_" + key : regionName + "_" + key;
        long start = System.currentTimeMillis();
        long waitMs = 10000L;
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("ignore InterruptedException during waiting for putting in snapshot");
            }
        } while (ConcCQBB.getBB().getSharedMap().get(key) == null && System.currentTimeMillis() - start < waitMs);
        if (ConcCQBB.getBB().getSharedMap().get(key) == null) {
            throw new TestException("the object (" + key + ") to be removed is not in the snapshots for " + waitMs / 1000L + " second");
        }
        ConcCQBB.getBB().getSharedMap().remove(key);
        Log.getLogWriter().info("removed from snapshots the key " + key);
    }

    protected void removeObject() {
        String key = null;
        String[] regionNames = MapPrms.getRegionNames();
        long counter = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.NumCounterToDestroy);
        for (int i = 0; i < regionNames.length; ++i) {
            Object got;
            String regionName = regionNames[i];
            Region region = RegionHelper.getRegion(regionName);
            if (region == null || (got = region.get((Object)(key = NameFactory.getObjectNameForCounter(counter)))) == null) continue;
            region.remove((Object)key);
            Log.getLogWriter().info("successfully removed this key: " + key);
            MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_REMOVE);
            return;
        }
    }

    public static void feedData() {
        concCQMultRegionsClient.loadData();
        ConcCQMultRegionsClient.releaseConnections();
    }

    @Override
    protected void loadData() {
        long startTime = System.currentTimeMillis();
        do {
            super.loadData();
        } while (System.currentTimeMillis() - startTime < this.minPerformEntryTime);
    }

    public static void feedDataWithVerification() {
        concCQMultRegionsClient.loadDataWithVerification();
    }

    protected void loadDataWithVerification() {
        boolean verify = (Boolean)CQUtilBB.getBB().getSharedMap().get("VerifyFlag");
        if (!verify) {
            if (this.putCountByEdges < this.numOfPutOpsByEdges) {
                ++this.putCountByEdges;
                this.loadData();
            } else if (this.putCountByEdges == this.numOfPutOpsByEdges) {
                ++this.putCountByEdges;
                this.loadData();
                verify = (Boolean)CQUtilBB.getBB().getSharedMap().get("VerifyFlag");
                while (!verify) {
                    try {
                        Thread.sleep(this.sleepMS);
                        verify = (Boolean)CQUtilBB.getBB().getSharedMap().get("VerifyFlag");
                    }
                    catch (InterruptedException e) {
                        Log.getLogWriter().info("Got InterruptedException while sleeping");
                    }
                }
                this.putCountByEdges = 0;
            } else {
                return;
            }
        }
    }

    protected void handleRegionDestroyedException(Region aRegion, RegionDestroyedException anException) {
        if (!anException.getRegionFullPath().equals(aRegion.getFullPath())) {
            TestException te = new TestException("Got a RegionDestroyedException when operating on region " + TestHelper.regionToString(aRegion, false) + ", but the region destroyed is '" + anException.getRegionFullPath() + "'");
            te.initCause(anException);
            throw te;
        }
        boolean isDestroyed = aRegion.isDestroyed();
        if (!isDestroyed) {
            throw new TestException("Bug 30645 (likely): isDestroyed returned " + isDestroyed + " for region " + TestHelper.regionToString(aRegion, false) + ", but a region destroyed exception was thrown: " + TestHelper.getStackTrace(anException));
        }
        Log.getLogWriter().info("Got " + RegionDestroyedException.class.getName() + " on " + TestHelper.regionToString(aRegion, false) + "; exception expected, continuing test");
    }
}

