/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import cq.CQUtilPrms;
import cq.ConcCQAndOpsTest;
import cq.ConcCQBB;
import cq.ConcCQMultRegionsClient;
import cq.ConcCQTest;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Properties;
import mapregion.MapBB;
import parReg.query.Position;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class ConcCQMultRegionsClientIndex
extends ConcCQMultRegionsClient {
    public static ConcCQMultRegionsClientIndex concCQMultRegionsClientIndex;
    protected static ConcCQBB concCqBB;
    protected static String updateKey;

    public static synchronized void HydraTask_initialize() {
        if (concCQMultRegionsClient == null) {
            concCQMultRegionsClientIndex = new ConcCQMultRegionsClientIndex();
            ConcCQTest.testInstance = new ConcCQTest();
            ConcCQAndOpsTest.concCQAndOpsTest = new ConcCQAndOpsTest();
            concCQMultRegionsClient = new ConcCQMultRegionsClient();
            verifyCount = TestConfig.tab().intAt(CQUtilPrms.edgeThreads);
            concCQMultRegionsClientIndex.initialize();
        }
    }

    public static void HydraTask_performEntryOperationsWithVerification() {
        concCQMultRegionsClientIndex.performEntryOperationsWithVerification();
        ConcCQMultRegionsClientIndex.releaseConnections();
    }

    public static void feedData() {
        concCQMultRegionsClientIndex.loadData();
        ConcCQMultRegionsClientIndex.releaseConnections();
    }

    protected void putQualifiedObject(String regionName) {
        long putQualified = concCqBB.getSharedCounters().incrementAndRead(ConcCQBB.OpsForQualifiedCount);
        if (putQualified == 1L) {
            Region region = RegionHelper.getRegion(regionName);
            String name = NameFactory.getNextPositiveObjectName();
            Object anObj = this.getQualifiedObjectToAdd(name);
            try {
                Object oldValue = region.put((Object)updateKey, anObj);
                Log.getLogWriter().info("put this key " + updateKey + " and value " + anObj.toString());
                if (((Position)anObj).getMktValue() > 50.0) {
                    this.updateBBForPuts(regionName, updateKey, anObj);
                } else if (oldValue != null && ((Position)oldValue).getMktValue() > 50.0) {
                    this.updateBBForPutsFewerResults(regionName, updateKey);
                }
            }
            catch (RegionDestroyedException e) {
                this.handleRegionDestroyedException(region, e);
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            concCqBB.getSharedCounters().zero(ConcCQBB.OpsForQualifiedCount);
        }
    }

    protected void updateBBForPutsFewerResults(String regionName, String name) {
        MapBB.getBB().getSharedCounters().increment(MapBB.NUM_PUT);
        String key = regionName + "_" + name;
        ConcCQBB.getBB().getSharedMap().remove(key);
    }

    protected Object getQualifiedObjectToAdd(String name) {
        int counter = (int)NameFactory.getCounterForName(name);
        Properties props = new Properties();
        Double qty = new Double(99.0);
        Double mktValue = new Double(rnd.nextDouble() * (double)this.maxPrice);
        Integer secId = new Integer(counter);
        props.setProperty("qty", qty.toString());
        props.setProperty("secId", secId.toString());
        props.setProperty("mktValue", mktValue.toString());
        Position aPosition = new Position();
        aPosition.init(props);
        return aPosition;
    }

    @Override
    protected void putObject(String regionName) {
        int random = rnd.nextInt(10);
        if (random == 0) {
            this.putQualifiedObject(regionName);
            return;
        }
        Region region = RegionHelper.getRegion(regionName);
        String name = NameFactory.getNextPositiveObjectName();
        Object anObj = this.getObjectToAdd(name);
        try {
            region.put((Object)name, anObj);
            Log.getLogWriter().info("put this key " + name + " and value " + anObj.toString());
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(region, e);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    static {
        concCqBB = ConcCQBB.getBB();
        updateKey = "Object_0";
    }
}

