/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesMutator;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import cq.CQEventTest;
import cq.CQUtil;
import cq.CQUtilPrms;
import cq.ListenerBB;
import cq.ListenerPrms;
import cq.MultiListener;
import hydra.CacheHelper;
import hydra.Log;
import hydra.TestConfig;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class ListenerTest
extends CQEventTest {
    protected static final int ADD_LISTENER = 1;
    protected static final int REMOVE_LISTENER = 2;
    protected static final int INIT_LISTENERS = 3;
    public static boolean targetVm = false;

    public static synchronized void HydraTask_initialize() throws CqClosedException, RegionNotFoundException {
        if (testInstance == null) {
            testInstance = new ListenerTest();
            ListenerTest.testInstance.isBridgeClient = true;
            testInstance.initializeRegion("clientRegion");
            boolean registerInterest = TestConfig.tab().booleanAt(CQUtilPrms.registerInterest, false);
            if (registerInterest) {
                ListenerTest.testInstance.aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            }
        }
        testInstance.initializeCQ();
        testInstance.initializePrms();
        QueryService qService = CacheHelper.getCache().getQueryService();
        CqQuery cq = qService.getCq(CQUtil.getCqName());
        CqAttributesMutator mutator = cq.getCqAttributesMutator();
        mutator.initCqListeners(null);
    }

    public static synchronized void HydraTask_exerciseListeners() {
        ((ListenerTest)testInstance).exerciseListeners();
    }

    protected void exerciseListeners() {
        long startTime = System.currentTimeMillis();
        do {
            TestHelper.checkForEventError(ListenerBB.getBB());
            CqQuery cq = CQUtil.getCQ();
            int listenerOp = this.getListenerOp();
            switch (listenerOp) {
                case 1: {
                    this.addListener(cq);
                    break;
                }
                case 2: {
                    this.removeListener(cq);
                    break;
                }
                case 3: {
                    this.initListener(cq);
                    break;
                }
                default: {
                    throw new TestException("Unknown Listener Operation " + listenerOp);
                }
            }
            if (!this.isSerialExecution) continue;
            this.writeExpectedListenerListToBB(cq);
            this.clearInvokedListenerList(cq);
            ListenerBB.getBB().getSharedCounters().zero(ListenerBB.NUM_LISTENER_INVOCATIONS);
            targetVm = true;
            this.doEntryOperations(this.aRegion);
            TestHelper.waitForCounter(ListenerBB.getBB(), "NUM_LISTENER_INVOCATIONS", ListenerBB.NUM_LISTENER_INVOCATIONS, this.getNumCqListeners(), true, 60000L);
            this.compareListenerLists(cq);
            targetVm = false;
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected int getNumCqListeners() {
        int numListeners = 0;
        CqQuery[] cqs = CacheHelper.getCache().getQueryService().getCqs();
        Log.getLogWriter().fine("getNumCqListeners: cqs = " + cqs);
        for (int i = 0; i < cqs.length; ++i) {
            CqListener[] list = cqs[i].getCqAttributes().getCqListeners();
            if (list.length <= 0) continue;
            Log.getLogWriter().fine("cqs[" + i + "] (" + cqs[i].getName() + ") has " + list.length + " listeners " + list);
            numListeners += list.length;
        }
        Log.getLogWriter().fine("getNumCqListeners returns " + numListeners);
        return numListeners;
    }

    protected int getListenerOp() {
        int op = 0;
        String operation = TestConfig.tab().stringAt(ListenerPrms.listenerOperations);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("remove")) {
            op = 2;
        } else if (operation.equals("init")) {
            op = 3;
        } else {
            throw new TestException("Unknown listenerOperation " + operation);
        }
        return op;
    }

    protected CqListener getNewListener() {
        MultiListener newListener = new MultiListener(NameFactory.getNextListenerName());
        Log.getLogWriter().info("getNewListener() returns listener " + newListener.getName());
        return newListener;
    }

    protected void addListener(CqQuery cq) {
        CqAttributesMutator mutator = cq.getCqAttributesMutator();
        CqListener newListener = this.getNewListener();
        mutator.addCqListener(newListener);
        Log.getLogWriter().info("After adding listener " + ((MultiListener)newListener).getName() + " new list = " + this.getCqListenerNames(cq));
    }

    protected void removeListener(CqQuery cq) {
        CqAttributes attrs = cq.getCqAttributes();
        CqListener[] assignedListeners = attrs.getCqListeners();
        if (assignedListeners.length == 0) {
            Log.getLogWriter().info("removeListeners invoked, but no assigned listeners to remove.  Returning.");
            return;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, assignedListeners.length - 1);
        Log.getLogWriter().info("Removing listener " + ((MultiListener)assignedListeners[randInt]).getName() + " from list of assignedCqListeners " + this.getCqListenerNames(cq));
        CqAttributesMutator mutator = cq.getCqAttributesMutator();
        mutator.removeCqListener(assignedListeners[randInt]);
        Log.getLogWriter().info("After removing listener " + ((MultiListener)assignedListeners[randInt]).getName() + " listener list = " + this.getCqListenerNames(cq));
    }

    protected void initListener(CqQuery cq) {
        int maxListeners = TestConfig.tab().intAt(ListenerPrms.maxListeners, 10);
        StringBuffer aStr = new StringBuffer();
        int randInt = TestConfig.tab().getRandGen().nextInt(3, maxListeners - 1);
        CqListener[] newListenerList = new CqListener[randInt];
        for (int i = 0; i < randInt; ++i) {
            newListenerList[i] = this.getNewListener();
            aStr.append(((MultiListener)newListenerList[i]).getName() + ":");
        }
        Log.getLogWriter().info("Initializing cqListeners with " + aStr);
        cq.getCqAttributesMutator().initCqListeners(newListenerList);
        Log.getLogWriter().info("After initCqListeners, list = " + this.getCqListenerNames(cq));
    }

    protected void writeExpectedListenerListToBB(CqQuery cq) {
        String expected = this.getCqListenerNames(cq);
        String key = ListenerBB.ExpectedListeners + "_" + cq.getName();
        ListenerBB.getBB().getSharedMap().put(key, expected);
    }

    protected void compareListenerLists(CqQuery cq) {
        String key = ListenerBB.ExpectedListeners + "_" + cq.getName();
        String expected = (String)ListenerBB.getBB().getSharedMap().get(key);
        Log.getLogWriter().info("Expected listener list (" + key + ") = " + expected);
        key = ListenerBB.InvokedListeners + "_" + cq.getName();
        String invoked = (String)ListenerBB.getBB().getSharedMap().get(key);
        Log.getLogWriter().info("Invoked listener list (" + key + ") = " + invoked);
        if (!expected.equals(invoked)) {
            StringBuffer aStr = new StringBuffer();
            aStr.append("Listeners may not have been invoked in order expected.\n");
            aStr.append("ExpectedList = " + expected + "\n");
            aStr.append("InvokedList = " + invoked + "\n");
            throw new TestException(aStr.toString());
        }
    }

    protected String getCqListenerNames(CqQuery cq) {
        StringBuffer aStr = new StringBuffer();
        CqListener[] list = cq.getCqAttributes().getCqListeners();
        if (list == null) {
            return "";
        }
        for (int i = 0; i < list.length; ++i) {
            aStr.append(((MultiListener)list[i]).getName() + ":");
        }
        return aStr.toString();
    }

    protected void clearInvokedListenerList(CqQuery cq) {
        String key = ListenerBB.InvokedListeners + "_" + cq.getName();
        ListenerBB.getBB().getSharedMap().put(key, "");
    }
}

