/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.query.CqQuery;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import cq.ConcCQBB;
import cq.ConcCQTest;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Random;
import java.util.TreeMap;
import mapregion.MapBB;
import mapregion.MapPrms;
import objects.ObjectHelper;
import util.NameBB;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class MultRegionsClient {
    protected static MultRegionsClient testInstance;
    protected Boolean regionOpsTryLock = new Boolean(false);
    protected Integer numOfCurrentPutAllOps = new Integer(0);
    protected boolean performedDestroyRegion = false;
    protected boolean performedInvalidateRegion = false;
    protected boolean performedClearRegion = false;
    protected boolean cqsOn = true;
    protected static Random rnd;
    protected int lowerThreshold;
    protected int upperThreshold;
    protected static final int CLEAR_REGION = 10;
    protected static final int INVALIDATE_REGION = 11;
    protected static final int PUT = 1;
    protected static final int PUT_ALL = 2;
    protected static final int REMOVE = 3;
    protected static final int INVALIDATE = 4;
    protected static Region[] regions;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            ConcCQTest.testInstance = new ConcCQTest();
            testInstance = new MultRegionsClient();
            testInstance.initialize();
        }
    }

    protected void initialize() {
        try {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            RegionAttributes attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
            String[] regionNames = MapPrms.getRegionNames();
            regions = new Region[regionNames.length];
            for (int i = 0; i < regionNames.length; ++i) {
                MultRegionsClient.regions[i] = RegionHelper.createRegion(regionNames[i], attr);
                if (!regions[i].getAttributes().getDataPolicy().withPartitioning() || regions[i].getAttributes().getPartitionAttributes().getRedundantCopies() <= 0) continue;
                ConcCQBB.getBB().getSharedMap().put("expectRecovery", new Boolean(true));
            }
            ConcCQBB.getBB().getSharedMap().put("numPRs", new Integer(regionNames.length));
            String usingPool = TestConfig.tab().stringAt(CQUtilPrms.QueryServiceUsingPool, "false");
            boolean queryServiceUsingPool = Boolean.valueOf(usingPool);
            if (queryServiceUsingPool) {
                Pool pool = PoolHelper.createPool(CQUtilPrms.getQueryServicePoolName());
                ConcCQTest.cqService = pool.getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Pool. PoolName: " + pool.getName());
            } else {
                ConcCQTest.cqService = CacheHelper.getCache().getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Cache.");
            }
            this.cqsOn = TestConfig.tab().booleanAt(CQUtilPrms.CQsOn, true);
            if (this.cqsOn) {
                this.registerCQs();
            }
            CQUtilBB.getBB().getSharedMap().put("PerformedDestroyRegion", new Boolean(false));
            CQUtilBB.getBB().getSharedMap().put("PerformedInvalidateRegion", new Boolean(false));
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void registerCQs() {
        if (!ConfigPrms.getRegionConfig().equalsIgnoreCase("feed")) {
            if (MapPrms.getRegisterAndExecuteCQs()) {
                Log.getLogWriter().info("registering and executing CQs");
                ConcCQTest.testInstance.registerAndExecuteCQs();
            } else {
                Log.getLogWriter().info("registering CQs");
                ConcCQTest.testInstance.registerCQs();
            }
        }
    }

    public static void HydraTask_destroyRegion() {
        testInstance.destroyRegion();
    }

    protected void destroyRegion() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        this.destroyRegion(regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyRegion(String regionName) {
        Region region = RegionHelper.getRegion(regionName);
        MasterController.sleepForMs(20000);
        Comparable<Boolean> comparable = this.regionOpsTryLock;
        synchronized (comparable) {
            this.regionOpsTryLock = new Boolean(true);
        }
        while (true) {
            comparable = this.numOfCurrentPutAllOps;
            synchronized (comparable) {
                if (this.numOfCurrentPutAllOps == 0) {
                    if (region != null) {
                        region.destroyRegion();
                        Log.getLogWriter().info("Successfully destroyed the region " + regionName);
                        Boolean bl = this.regionOpsTryLock;
                        synchronized (bl) {
                            this.regionOpsTryLock = new Boolean(false);
                        }
                        CQUtilBB.getBB().getSharedMap().put("PerformedDestroyRegion", new Boolean(true));
                        this.performedDestroyRegion = true;
                        MapBB.getBB().getSharedCounters().increment(MapBB.NUM_CLOSE);
                        return;
                    }
                    throw new TestException("region " + regionName + " is not created properly");
                }
            }
            MasterController.sleepForMs(5000);
        }
    }

    public static void HydraTask_serialRegionOps() {
        testInstance.performRegionOperations();
    }

    protected int getRegionOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("clearRegion")) {
            op = 10;
        } else if (operation.equals("invalidateRegion")) {
            op = 11;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected void performRegionOperations() {
        try {
            int whichOp = this.getRegionOperation(MapPrms.regionOperationName);
            switch (whichOp) {
                case 10: {
                    this.clearRegion();
                    break;
                }
                case 11: {
                    this.invalidateRegion();
                    break;
                }
                default: {
                    throw new TestException("Unknown region operation " + whichOp);
                }
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void clearRegion() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        this.clearRegion(regionName);
    }

    protected void clearRegion(String regionName) {
        Region region = RegionHelper.getRegion(regionName);
        if (region != null) {
            if (region.entrySet().size() < 100) {
                Log.getLogWriter().info("Not enough entries in the region to be cleared.");
                return;
            }
            int destroyed = region.entrySet().size();
            region.clear();
            Log.getLogWriter().info("clearRegion destroys " + destroyed + " entries in region " + regionName);
            MapBB.getBB().getSharedCounters().increment(MapBB.NUM_REGION_DESTROY);
        }
    }

    public static void HydraTask_executeCQ() {
        testInstance.executeCQ();
    }

    protected void executeCQ() {
        boolean exeCq = (Boolean)CQUtilBB.getBB().getSharedMap().get("PerformedDestroyRegion");
        if (exeCq) {
            this.edgeExecuteCQ();
        }
    }

    protected void edgeExecuteCQ() {
        CqQuery[] cqArray = ConcCQTest.cqService.getCqs();
        Log.getLogWriter().info("The number of CqQuery in cqArray is " + cqArray.length);
        CqQuery cq = null;
        for (int i = 0; i < cqArray.length; ++i) {
            cq = cqArray[i];
            try {
                cq.stop();
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            ConcCQTest.testInstance.executeWithInitialResultsCQ(cq);
            Log.getLogWriter().info("executed cq for " + cqArray[i].getQuery());
        }
    }

    public static void HydraTask_invalidateRegion() {
        testInstance.invalidateRegion();
    }

    protected void invalidateRegion() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        this.invalidateRegion(regionName);
    }

    protected void invalidateRegion(String regionName) {
        Region region = RegionHelper.getRegion(regionName);
        if (region != null) {
            if (region.entrySet().size() < 100) {
                Log.getLogWriter().info("Not enough entries in the region to be invalidated.");
                return;
            }
            int invalidated = region.entrySet().size();
            region.invalidateRegion();
            Log.getLogWriter().info("invalidateRegion invalidates " + invalidated + " entries in region " + regionName);
            MapBB.getBB().getSharedCounters().increment(MapBB.NUM_REGION_INVALIDATE);
        }
    }

    public static void HydraTask_performEntryOperations() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        testInstance.performEntryOperations(regionName);
        MultRegionsClient.releaseConnections();
    }

    protected int getEntryOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("put")) {
            op = 1;
        } else if (operation.equals("putAll")) {
            op = 2;
        } else if (operation.equals("remove")) {
            op = 3;
        } else if (operation.equals("invalidate")) {
            op = 4;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected void performEntryOperations() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        this.performEntryOperations(regionName);
    }

    protected static void releaseConnections() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        Region aRegion = RegionHelper.getRegion(regionName);
        while (aRegion == null) {
            regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
            aRegion = RegionHelper.getRegion(regionName);
        }
        ClientHelper.release(aRegion);
    }

    protected void performEntryOperations(String regionName) {
        try {
            int whichOp = this.getEntryOperation(MapPrms.entryOperationName);
            int size = 0;
            this.lowerThreshold = TestConfig.tab().intAt(MapPrms.lowerThreshold, -1);
            this.upperThreshold = TestConfig.tab().intAt(MapPrms.upperThreshold, Integer.MAX_VALUE);
            Log.getLogWriter().info("lowerThreshold " + this.lowerThreshold + ", " + "upperThreshold " + this.upperThreshold);
            Region aRegion = RegionHelper.getRegion(regionName);
            if (aRegion == null) {
                return;
            }
            size = aRegion.getAttributes().getPoolName() != null ? aRegion.keySetOnServer().size() : aRegion.size();
            Log.getLogWriter().info(" Region.size= " + size);
            if (size >= this.upperThreshold) {
                Log.getLogWriter().info("Above the upperThreshold  Region.size= " + size);
                whichOp = this.getEntryOperation(MapPrms.upperThresholdOperations);
            } else if (size <= this.lowerThreshold) {
                Log.getLogWriter().info("Below the lowerThreshold  Region.size= " + size);
                whichOp = this.getEntryOperation(MapPrms.lowerThresholdOperations);
            }
            switch (whichOp) {
                case 1: {
                    this.putObject(regionName);
                    break;
                }
                case 2: {
                    this.putAllObjects(regionName);
                    break;
                }
                case 3: {
                    this.removeObject(regionName);
                    break;
                }
                case 4: {
                    this.invalidateObject(regionName);
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putObject(String regionName) {
        try {
            long limit = TestConfig.tab().longAt(MapPrms.timeForPutOperation);
            String key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            Region region = RegionHelper.getRegion(regionName);
            if (region != null) {
                long startTime = System.currentTimeMillis();
                do {
                    int numPosEntries;
                    if ((numPosEntries = (int)NameFactory.getPositiveNameCounter()) > MapPrms.getMaxPositiveKeys()) {
                        NameBB.getBB().zero("NameBB.POSITIVE_NAME_COUNTER", NameBB.POSITIVE_NAME_COUNTER);
                    }
                    key = NameFactory.getNextPositiveObjectName();
                    int putKeyInt = (int)NameFactory.getCounterForName(key);
                    val = ObjectHelper.createObject(objectType, putKeyInt);
                    region.put((Object)key, val);
                    Log.getLogWriter().info("put this key: " + key + " in " + regionName);
                    MapBB.getBB().getSharedCounters().increment(MapBB.NUM_PUT);
                } while (System.currentTimeMillis() - startTime < limit);
            }
        }
        catch (RegionDestroyedException rde) {
            Log.getLogWriter().info("RegionDestroyedException ...may occur in concurrent execution. Continuing with test.");
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAllObjects(String regionName) {
        String key = null;
        Object val = null;
        String objectType = MapPrms.getObjectType();
        int minQty = 50;
        int maxQty = 100;
        int numForPutAll = rnd.nextInt(maxQty - minQty) + minQty;
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        Region region = RegionHelper.getRegion(regionName);
        if (region != null) {
            Boolean bl = this.regionOpsTryLock;
            synchronized (bl) {
                if (this.regionOpsTryLock.booleanValue()) {
                    return;
                }
                Integer n = this.numOfCurrentPutAllOps;
                synchronized (n) {
                    this.numOfCurrentPutAllOps = new Integer(this.numOfCurrentPutAllOps + 1);
                }
            }
            for (int i = 0; i < numForPutAll; ++i) {
                int numNegEntries = Math.abs((int)NameFactory.getNegativeNameCounter());
                if (numNegEntries > MapPrms.getMaxNagetiveKeys()) {
                    NameBB.getBB().zero("NameBB.NEGATIVE_NAME_COUNTER", NameBB.NEGATIVE_NAME_COUNTER);
                }
                key = NameFactory.getNextNegativeObjectName();
                int putAllKeyInt = (int)NameFactory.getCounterForName(key);
                val = ObjectHelper.createObject(objectType, putAllKeyInt);
                m.put(key, val);
                Log.getLogWriter().info("put this key " + key + " in the map for putAll");
            }
            try {
                Log.getLogWriter().info("--- executing putAll with mapSize = " + m.size());
                region.putAll(m);
                MapBB.getBB().getSharedCounters().add(MapBB.NUM_PUT, m.size());
                Log.getLogWriter().info("----performed putAll operation on region " + regionName);
            }
            catch (Exception ex) {
                throw new TestException(TestHelper.getStackTrace(ex));
            }
            Integer n = this.numOfCurrentPutAllOps;
            synchronized (n) {
                this.numOfCurrentPutAllOps = new Integer(this.numOfCurrentPutAllOps - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void removeObject(String regionName) {
        String keyToDestroy = null;
        try {
            long limit = TestConfig.tab().longAt(MapPrms.timeForRemoveOperation);
            long startTime = System.currentTimeMillis();
            do {
                int removeCntr = rnd.nextInt(MapPrms.getMaxPositiveKeys()) + 1;
                keyToDestroy = NameFactory.getObjectNameForCounter(removeCntr);
                Region[] regionArray = regions;
                // MONITORENTER : regions
                for (int i = 0; i < regions.length; ++i) {
                    Region.Entry got;
                    if (!regions[i].getName().equalsIgnoreCase(regionName) || (got = regions[i].getEntry((Object)keyToDestroy)) == null) continue;
                    regions[i].remove((Object)keyToDestroy);
                    Log.getLogWriter().info("removed " + keyToDestroy + " in " + regionName);
                    MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_REMOVE);
                    break;
                }
                // MONITOREXIT : regionArray
            } while (System.currentTimeMillis() - startTime < limit);
            return;
        }
        catch (RegionDestroyedException rde) {
            Log.getLogWriter().info("RegionDestroyedException ...may occur in concurrent execution. Continuing with test.");
            return;
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void invalidateObject(String regionName) {
        String keyToInvalidate = null;
        try {
            long limit = TestConfig.tab().longAt(MapPrms.timeForRemoveOperation);
            long startTime = System.currentTimeMillis();
            do {
                int invalidateCounter = rnd.nextInt(MapPrms.getMaxNagetiveKeys()) + 1;
                keyToInvalidate = NameFactory.getObjectNameForCounter(invalidateCounter * -1);
                Region[] regionArray = regions;
                // MONITORENTER : regions
                for (int i = 0; i < regions.length; ++i) {
                    Object got;
                    if (!regions[i].getName().equalsIgnoreCase(regionName) || (got = regions[i].get((Object)keyToInvalidate)) == null) continue;
                    regions[i].invalidate((Object)keyToInvalidate);
                    Log.getLogWriter().info("Invalidated " + keyToInvalidate + " in " + regionName);
                    long temp = MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_INVALIDATE);
                    Log.getLogWriter().info("The number of invalidated entries is " + temp);
                    break;
                }
                // MONITOREXIT : regionArray
            } while (System.currentTimeMillis() - startTime < limit);
            return;
        }
        catch (EntryNotFoundException enfe) {
            Log.getLogWriter().info("EntryNotFoundException ...may occur in concurrent execution. Continuing with test.");
            return;
        }
        catch (RegionDestroyedException rde) {
            Log.getLogWriter().info("RegionDestroyedException ...may occur in concurrent execution. Continuing with test.");
            return;
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static void feedData() {
        testInstance.loadData();
        MultRegionsClient.releaseConnections();
    }

    protected void loadData() {
        String[] regionNames = MapPrms.getRegionNames();
        for (int i = 0; i < regionNames.length; ++i) {
            Log.getLogWriter().info("feeding data into region:- " + regionNames[i]);
            this.putAllObjects(regionNames[i]);
            Log.getLogWriter().info("data fed into region:- " + regionNames[i]);
        }
    }

    static {
        rnd = new Random();
    }
}

