/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.InvalidDeltaException;
import delta.DeltaObject;
import delta.DeltaPropagationBB;
import hydra.Log;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import util.TestException;

public class BadDeltaObject
extends DeltaObject {
    public static final int hasDeltaThrowsException = 1;
    public static final int toDeltaThrowsException = 2;
    public static final int fromDeltaThrowsException = 3;
    public static final int hasDeltaThrowsError = 4;
    public static final int toDeltaThrowsError = 5;
    public static final int fromDeltaThrowsError = 6;
    public static final int fromDeltaReadTooMuch = 7;
    public static final int toDeltaWriteNothing = 8;
    public static final int fromDeltaThrowsInvDelExc = 9;
    public static final int toDeltaThrowsIOException = 10;
    public static final int fromDeltaThrowsIOException = 11;
    public static final int numberOfBadDeltaTestCases = 11;
    public static String testCaseKey = "testCaseKey";

    public BadDeltaObject(long base, int valueGeneration, int byteArraySize, int levels) {
        super(base, valueGeneration, byteArraySize, levels);
    }

    @Override
    public synchronized void toDelta(DataOutput out) throws IOException {
        int testCase = (Integer)DeltaPropagationBB.getBB().getSharedMap().get(testCaseKey);
        if (testCase == 2) {
            Log.getLogWriter().info("In BadDeltaObject.toDelta, toDelta is throwing Exception...");
            int[] anArr = new int[1];
            int n = anArr[10];
        } else {
            if (testCase == 5) {
                Log.getLogWriter().info("In BadDeltaObject.toDelta, toDelta is throwing Error...");
                throw new AssertionError((Object)"Causing an error in toDelta");
            }
            if (testCase == 8) {
                Log.getLogWriter().info("In BadDeltaObject.toDelta, toDelta is not writing to DataOutput " + out + "...");
            } else {
                if (testCase == 10) {
                    Log.getLogWriter().info("In BadDeltaObject.toDelta, toDelta is throwing IOException...");
                    throw new IOException("Causing an IOException in toDelta");
                }
                super.toDelta(out);
            }
        }
    }

    @Override
    public synchronized void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        int testCase = (Integer)DeltaPropagationBB.getBB().getSharedMap().get(testCaseKey);
        if (testCase == 3) {
            Log.getLogWriter().info("In BadDeltaObject.fromDelta, fromDelta is throwing Exception...");
            int[] anArr = new int[1];
            int n = anArr[10];
        } else {
            if (testCase == 6) {
                Log.getLogWriter().info("In BadDeltaObject.fromDelta, fromDelta is throwing Error...");
                throw new AssertionError((Object)"Causing an error in fromDelta");
            }
            if (testCase == 7) {
                Log.getLogWriter().info("In BadDeltaObject.fromDelta, fromDelta is reading more than toDelta wrote...");
                byte[] aByteArray = new byte[1000];
                in.readFully(aByteArray);
            } else {
                if (testCase == 9) {
                    Log.getLogWriter().info("In BadDeltaObject.fromDelta, fromDelta is throwing InvalidDeltaException...");
                    throw new InvalidDeltaException("Throwing InvalidDeltaException in fromDelta");
                }
                if (testCase == 11) {
                    Log.getLogWriter().info("In BadDeltaObject.fromDelta, fromDelta is throwing IOException...");
                    throw new IOException("Causing an IOException in fromDelta");
                }
                if (testCase == 8) {
                    Log.getLogWriter().info("In BadDeltaObject.fromDelta, toDelta wrote nothing, but trying to read anyway...");
                    byte[] aByteArray = new byte[1000];
                    in.readFully(aByteArray);
                } else {
                    super.fromDelta(in);
                }
            }
        }
    }

    @Override
    public boolean hasDelta() {
        int testCase = (Integer)DeltaPropagationBB.getBB().getSharedMap().get(testCaseKey);
        if (testCase == 1) {
            Log.getLogWriter().info("In BadDeltaObject.hasDelta, hasDelta is throwing Exception...");
            int[] anArr = new int[1];
            int anInt = anArr[10];
            return true;
        }
        if (testCase == 4) {
            Log.getLogWriter().info("In BadDeltaObject.hasDelta, hasDelta is throwing Error...");
            throw new AssertionError((Object)"Causing an error in hasDelta");
        }
        return super.hasDelta();
    }

    public static String testCaseToString(int deltaTestCase) {
        if (deltaTestCase == 1) {
            return "hasDelta throws Exception";
        }
        if (deltaTestCase == 2) {
            return "toDelta throws Exception";
        }
        if (deltaTestCase == 3) {
            return "fromDelta throws Exception";
        }
        if (deltaTestCase == 4) {
            return "hasDelta throws Error";
        }
        if (deltaTestCase == 5) {
            return "toDelta throws Error";
        }
        if (deltaTestCase == 6) {
            return "fromDelta throws Error";
        }
        if (deltaTestCase == 7) {
            return "fromDelta reads more data than was written";
        }
        if (deltaTestCase == 8) {
            return "toDelta writes nothing";
        }
        if (deltaTestCase == 9) {
            return "fromDelta throws InvalidDeltaException";
        }
        if (deltaTestCase == 10) {
            return "toDelta throws IOException";
        }
        if (deltaTestCase == 11) {
            return "fromDelta throws IOException";
        }
        throw new TestException("Unknown deltaTestCase " + deltaTestCase);
    }
}

