/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import delta.DeltaPropagation;
import delta.DeltaPropagationBB;
import delta.Validator;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public class DeltaClientOldValidationListener
extends CacheListenerAdapter {
    private final Map latestValues = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.createNonDeltaCount;
            String key = (String)event.getKey();
            if (key.equals("last_key")) {
                DeltaPropagation.lastKeyReceived = true;
                Log.getLogWriter().info("'last_key' received at client");
                return;
            }
            Long value = (Long)event.getNewValue();
            if (value == null) {
                DeltaClientOldValidationListener.throwException("value in afterCreate cannot be null: key = " + key);
                return;
            }
            if (value.intValue() != 0) {
                this.validateIncrementByOne(key, value);
            }
            Log.getLogWriter().fine("create entry in Map key " + key + " : value : " + value + " : puting into map : " + value.intValue());
            this.latestValues.put(key, value.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdate(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.updateNonDeltaCount;
            String key = (String)event.getKey();
            Long newValue = (Long)event.getNewValue();
            Long oldValue = (Long)event.getOldValue();
            if (newValue == null) {
                DeltaClientOldValidationListener.throwException("newValue in afterUpdate cannot be null: key = " + key);
                return;
            }
            if (oldValue == null) {
                this.validateIncrementByOne(key, newValue);
            } else {
                long diff = newValue.intValue() - (Integer)this.latestValues.get(key);
                if (diff != 1L) {
                    DeltaClientOldValidationListener.throwException("difference expected in newValue and oldValue is less than  1, but was not for key = " + key + " & newVal = " + newValue + " oldValue = " + (Integer)this.latestValues.get(key));
                    return;
                }
            }
            Log.getLogWriter().fine("update entry in Map key " + key + " : value : " + newValue + " : puting into map : " + newValue.intValue());
            this.latestValues.put(key, newValue.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvalidate(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.invalidateCount;
            String key = (String)event.getKey();
            Long oldValue = (Long)event.getOldValue();
            if (oldValue == null) {
                DeltaClientOldValidationListener.throwException("oldValue in afterInvalidate cannot be null : key = " + key);
                return;
            }
            Log.getLogWriter().fine("invalidate entry in Map key " + key + " : value : " + oldValue + " : puting into map : " + oldValue.intValue());
            this.latestValues.put(key, oldValue.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDestroy(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.destroyCount;
            String key = (String)event.getKey();
            Long value = (Long)event.getOldValue();
            if (value != null) {
                this.latestValues.put(key, value.intValue());
                Log.getLogWriter().info("key " + key + " received at client old value : " + value);
            }
            Log.getLogWriter().fine("destroy entry in Map key " + key);
        }
    }

    private void validateIncrementByOne(String key, Long newValue) {
        Integer oldValue = (Integer)this.latestValues.get(key);
        if (oldValue == null) {
            DeltaClientOldValidationListener.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + newValue);
            return;
        }
        long diff = newValue.intValue() - oldValue;
        if (diff != 1L) {
            DeltaClientOldValidationListener.throwException("difference expected in newValue and oldValue is 1, but is was " + diff + " for key = " + key + " & newVal = " + newValue);
            return;
        }
    }

    public static void throwException(String reason) {
        ArrayList reasonArray = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        String clientName = "CLIENT_" + ds.getName();
        SharedMap shMap = DeltaPropagationBB.getBB().getSharedMap();
        reasonArray = !shMap.containsKey(clientName) ? new ArrayList() : (ArrayList)shMap.get(clientName);
        reasonArray.add(reason);
        shMap.put(clientName, reasonArray);
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.NUM_EXCEPTION);
        Log.getLogWriter().info("Exception : " + TestHelper.getStackTrace(new TestException(reason)));
    }
}

