/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import delta.DeltaPropagation;
import delta.DeltaPropagationBB;
import delta.DeltaTestObj;
import delta.Validator;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public class DeltaDurableClientValidationListener
extends CacheListenerAdapter
implements Serializable {
    static final Map latestValues = new HashMap();
    static Map durableKeyMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            ++Validator.createCount;
            String key = (String)event.getKey();
            if (key.equals("last_key")) {
                DeltaPropagation.lastKeyReceived = true;
                Log.getLogWriter().info("'last_key' received at client");
                return;
            }
            if (event.getNewValue() instanceof Long) {
                return;
            }
            DeltaTestObj value = (DeltaTestObj)((Object)event.getNewValue());
            if (value == null) {
                DeltaDurableClientValidationListener.throwException("value in afterCreate cannot be null: key = " + key);
                return;
            }
            if (value.getIntVar() != 0 && value.getFromDeltaCounter() != 0L) {
                this.validateIncrementByOne(key, value);
            }
            Log.getLogWriter().info("create entry in Map key " + key + " : value : " + (Object)((Object)value) + " : puting into map : " + value.getIntVar());
            latestValues.put(key, value.getIntVar());
            CounterHolder chold = (CounterHolder)durableKeyMap.get(key + "#" + DeltaPropagation.VmDurableId);
            if (chold == null) {
                chold = new CounterHolder(0L, 0L);
                Log.getLogWriter().info("create chold is null for key " + key + "#" + DeltaPropagation.VmDurableId);
            } else {
                chold.fullObjectCounter++;
                Log.getLogWriter().info("create chold is not null for key " + key + "#" + DeltaPropagation.VmDurableId);
            }
            durableKeyMap.put(key + "#" + DeltaPropagation.VmDurableId, chold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            ++Validator.updateCount;
            if (event.getNewValue() instanceof Long) {
                return;
            }
            String key = (String)event.getKey();
            DeltaTestObj newValue = (DeltaTestObj)((Object)event.getNewValue());
            DeltaTestObj oldValue = (DeltaTestObj)((Object)event.getOldValue());
            if (newValue == null) {
                DeltaDurableClientValidationListener.throwException("newValue in afterUpdate cannot be null: key = " + key);
                return;
            }
            CounterHolder chold = (CounterHolder)durableKeyMap.get(key + "#" + DeltaPropagation.VmDurableId);
            if (newValue.getFromDeltaCounter() == 0L) {
                if (chold == null) {
                    chold = new CounterHolder(0L, 1L);
                } else {
                    chold.fullObjectCounter++;
                }
            } else if (oldValue == null) {
                this.validateIncrementByOne(key, newValue);
                chold.fromDeltaCounter++;
            } else {
                long diff = newValue.getIntVar() - (Integer)latestValues.get(key);
                if (diff != 1L) {
                    DeltaDurableClientValidationListener.throwException("difference expected in newValue and oldValue is less than  1, but was not for key = " + key + " & newVal = " + (Object)((Object)newValue) + " oldValue = " + (Integer)latestValues.get(key));
                    return;
                }
                chold.fromDeltaCounter++;
            }
            Log.getLogWriter().info("update entry in Map key " + key + " : value : " + (Object)((Object)newValue) + " : puting into map : " + newValue.getIntVar());
            latestValues.put(key, newValue.getIntVar());
            Log.getLogWriter().info("update entry in shared Map key " + key + "#" + DeltaPropagation.VmDurableId + " : value : " + chold);
            durableKeyMap.put(key + "#" + DeltaPropagation.VmDurableId, chold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvalidate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            ++Validator.invalidateCount;
            if (event.getOldValue() instanceof Long) {
                return;
            }
            String key = (String)event.getKey();
            DeltaTestObj oldValue = (DeltaTestObj)((Object)event.getOldValue());
            if (oldValue == null) {
                DeltaDurableClientValidationListener.throwException("oldValue in afterInvalidate cannot be null : key = " + key);
                return;
            }
            Log.getLogWriter().info("invalidate entry in Map key " + key + " : value : " + (Object)((Object)oldValue) + " : puting into map : " + oldValue.getIntVar());
            latestValues.put(key, oldValue.getIntVar());
            Log.getLogWriter().info("invalidate entry in shared Map key " + key + "#" + DeltaPropagation.VmDurableId + " : value : null");
            durableKeyMap.put(key + "#" + DeltaPropagation.VmDurableId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDestroy(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            ++Validator.destroyCount;
            if (event.getOldValue() instanceof Long) {
                return;
            }
            String key = (String)event.getKey();
            DeltaTestObj value = (DeltaTestObj)((Object)event.getOldValue());
            if (value != null) {
                latestValues.put(key, value.getIntVar());
                Log.getLogWriter().info("key " + key + " received at client old value : " + (Object)((Object)value));
            }
            Log.getLogWriter().info("destroy entry in shared Map key " + key + "#" + DeltaPropagation.VmDurableId);
            durableKeyMap.remove(key + "#" + DeltaPropagation.VmDurableId);
        }
    }

    private void validateIncrementByOne(String key, DeltaTestObj newValue) {
        Integer oldValue = (Integer)latestValues.get(key);
        if (oldValue == null) {
            DeltaDurableClientValidationListener.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + (Object)((Object)newValue));
            return;
        }
        long diff = newValue.getIntVar() - oldValue;
        if (diff != 1L) {
            DeltaDurableClientValidationListener.throwException("difference expected in newValue and oldValue is 1, but is was " + diff + " for key = " + key + " & newVal = " + (Object)((Object)newValue));
            return;
        }
    }

    public static void throwException(String reason) {
        ArrayList reasonArray = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        String clientName = "CLIENT_" + ds.getName();
        SharedMap shMap = DeltaPropagationBB.getBB().getSharedMap();
        reasonArray = !shMap.containsKey(clientName) ? new ArrayList() : (ArrayList)shMap.get(clientName);
        reasonArray.add(reason);
        shMap.put(clientName, reasonArray);
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.NUM_EXCEPTION);
        Log.getLogWriter().info("Exception : " + TestHelper.getStackTrace(new TestException(reason)));
    }

    class CounterHolder
    implements Serializable {
        private long fromDeltaCounter;
        private long fullObjectCounter;

        public CounterHolder(long fmc, long foc) {
            this.fromDeltaCounter = fmc;
            this.fullObjectCounter = foc;
        }

        public long getFromDeltaCounter() {
            return this.fromDeltaCounter;
        }

        public long getFullObjectCounter() {
            return this.fullObjectCounter;
        }

        public void setFromDeltaCounter(long fromDeltaCounter) {
            this.fromDeltaCounter = fromDeltaCounter;
        }

        public void setFullObjectCounter(long fullObjectCounter) {
            this.fullObjectCounter = fullObjectCounter;
        }

        public long getTotalSum() {
            return this.fromDeltaCounter + this.fullObjectCounter;
        }

        public String toString() {
            return "CounterHolder [fromDeltaCounter " + this.fromDeltaCounter + " fullObjectCounter " + this.fullObjectCounter + "]";
        }
    }
}

