/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.Delta;
import delta.DeltaObserver;
import delta.DeltaPropagationBB;
import delta.DeltaPropagationPrms;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import util.QueryObject;
import util.RandomValues;
import util.TestException;
import util.TestHelper;

public class DeltaObject
extends QueryObject
implements Delta {
    public static boolean cloningEnabled;
    public transient boolean aPrimitiveLongChanged = false;
    public transient boolean aPrimitiveIntChanged = false;
    public transient boolean aPrimitiveShortChanged = false;
    public transient boolean aPrimitiveFloatChanged = false;
    public transient boolean aPrimitiveDoubleChanged = false;
    public transient boolean aPrimitiveByteChanged = false;
    public transient boolean aPrimitiveCharChanged = false;
    public transient boolean aPrimitiveBooleanChanged = false;
    public transient boolean aByteArrayChanged = false;
    public transient boolean aStringChanged = false;
    private final String END_SIGNAL = "delta END signal";

    public DeltaObject(long base, int valueGeneration, int byteArraySize, int levels) {
        super(base, valueGeneration, byteArraySize, levels);
    }

    public synchronized void toDelta(DataOutput out) throws IOException {
        try {
            this._toDelta(out);
            this.reset();
        }
        catch (TestException e) {
            String aStr = "In vm id " + RemoteTestModule.getMyVmid() + ", " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(aStr);
            DeltaPropagationBB.getBB().getSharedMap().replace("Error", null, aStr);
            throw e;
        }
        catch (Exception e) {
            String aStr = "In vm id " + RemoteTestModule.getMyVmid() + ", " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(aStr);
            DeltaPropagationBB.getBB().getSharedMap().replace("Error", null, aStr);
            throw new TestException(aStr);
        }
    }

    protected void _toDelta(DataOutput out) throws IOException {
        Log.getLogWriter().info("In DeltaObject.toDelta, for " + this + "\n" + "with DataOutput " + out);
        DeltaObserver.addToDeltaKey(this.extra);
        long toDeltaIdNumber = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.toDeltaIdNumber);
        out.writeLong(toDeltaIdNumber);
        Log.getLogWriter().info("Wrote toDeltaIdNumber " + toDeltaIdNumber);
        out.writeBoolean(this.aPrimitiveLongChanged);
        if (this.aPrimitiveLongChanged) {
            out.writeLong(this.aPrimitiveLong);
            Log.getLogWriter().info("Wrote changed field aPrimitiveLong " + this.aPrimitiveLong);
        }
        out.writeBoolean(this.aPrimitiveIntChanged);
        if (this.aPrimitiveIntChanged) {
            out.writeInt(this.aPrimitiveInt);
            Log.getLogWriter().info("Wrote changed field aPrimitiveInt " + this.aPrimitiveInt);
        }
        out.writeBoolean(this.aPrimitiveShortChanged);
        if (this.aPrimitiveShortChanged) {
            out.writeShort(this.aPrimitiveShort);
            Log.getLogWriter().info("Wrote changed field aPrimitiveShort " + this.aPrimitiveShort);
        }
        out.writeBoolean(this.aPrimitiveFloatChanged);
        if (this.aPrimitiveFloatChanged) {
            out.writeFloat(this.aPrimitiveFloat);
            Log.getLogWriter().info("Wrote changed field aPrimitiveFloat " + this.aPrimitiveFloat);
        }
        out.writeBoolean(this.aPrimitiveDoubleChanged);
        if (this.aPrimitiveDoubleChanged) {
            out.writeDouble(this.aPrimitiveDouble);
            Log.getLogWriter().info("Wrote changed field aPrimitiveDouble " + this.aPrimitiveDouble);
        }
        out.writeBoolean(this.aPrimitiveByteChanged);
        if (this.aPrimitiveByteChanged) {
            out.writeByte(this.aPrimitiveByte);
            Log.getLogWriter().info("Wrote changed field aPrimitiveByte " + this.aPrimitiveByte);
        }
        out.writeBoolean(this.aPrimitiveCharChanged);
        if (this.aPrimitiveCharChanged) {
            out.writeChar(this.aPrimitiveChar);
            Log.getLogWriter().info("Wrote changed field aPrimitiveChar " + this.aPrimitiveChar);
        }
        out.writeBoolean(this.aPrimitiveBooleanChanged);
        if (this.aPrimitiveBooleanChanged) {
            out.writeBoolean(this.aPrimitiveBoolean);
            Log.getLogWriter().info("Wrote changed field aPrimitiveBoolean " + this.aPrimitiveBoolean);
        }
        out.writeBoolean(this.aByteArrayChanged);
        if (this.aByteArrayChanged) {
            out.writeInt(this.aByteArray.length);
            out.write(this.aByteArray);
            Log.getLogWriter().info("Wrote changed field aByteArray of length " + this.aByteArray.length);
        }
        out.writeBoolean(this.aStringChanged);
        if (this.aStringChanged) {
            out.writeInt(this.aString.length());
            out.writeBytes(this.aString);
            Log.getLogWriter().info("Wrote changed field aString " + this.aString);
        }
        out.writeInt("delta END signal".length());
        out.writeBytes("delta END signal");
        Log.getLogWriter().info("Wrote end signal: delta END signal");
        Log.getLogWriter().info("Done writing in DeltaObject.toDelta for " + this);
    }

    public synchronized void fromDelta(DataInput in) throws IOException {
        try {
            this._fromDelta(in);
            this.verifyCloning();
        }
        catch (TestException e) {
            String aStr = "In vm id " + RemoteTestModule.getMyVmid() + ", " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(aStr);
            DeltaPropagationBB.getBB().getSharedMap().replace("Error", null, aStr);
            throw e;
        }
        catch (Exception e) {
            String aStr = "In vm id " + RemoteTestModule.getMyVmid() + ", " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(aStr);
            DeltaPropagationBB.getBB().getSharedMap().replace("Error", null, aStr);
            throw new TestException(aStr);
        }
    }

    private void verifyCloning() {
        if (!TestConfig.tab().booleanAt(DeltaPropagationPrms.enableCloningValidation, true)) {
            Log.getLogWriter().info("cloning validation is disabled");
            return;
        }
        Log.getLogWriter().info("In verifyCloning for " + this.toStringFull());
        Map regionReferences = DeltaObserver.getReferences();
        if (!regionReferences.containsKey(this.extra)) {
            Log.getLogWriter().info("Unable to verify cloning because previous reference does not exist for " + this.toStringFull());
            return;
        }
        Object[] anArr = (Object[])regionReferences.get(this.extra);
        if (anArr == null) {
            throw new TestException("Error in test, unexpected null in region references for " + this.toStringFull());
        }
        int idHashCode = (Integer)anArr[0];
        String refString = (String)anArr[1];
        long deltaObjId = (Long)anArr[2];
        int thisIdHashCode = System.identityHashCode(this);
        Log.getLogWriter().info("For key " + this.extra + " fromDelta is being called on object with identityHashCode " + thisIdHashCode + ", previous object in region had identityHashCode " + idHashCode + " and DeltaObject id " + deltaObjId);
        if (cloningEnabled) {
            if (idHashCode == thisIdHashCode && deltaObjId == this.id) {
                String aStr = "In vm id " + RemoteTestModule.getMyVmid() + ", expected fromDelta to be called on a clone, but it is being called on object with identityHashCode " + thisIdHashCode + ", " + this.toStringFull() + ", the object previously in the region has identityHashCode " + idHashCode + ", " + refString;
                Log.getLogWriter().info(aStr);
                DeltaPropagationBB.getBB().getSharedMap().replace("Error", null, aStr);
                throw new TestException(aStr);
            }
        } else if (!cloningEnabled && idHashCode != thisIdHashCode) {
            String aStr = "In vm id " + RemoteTestModule.getMyVmid() + ", expected fromDelta to be called on object existing in region (no clone), but it is being called on object with identityHashCode " + thisIdHashCode + ", " + this.toStringFull() + ", the object previously in the region has identityHashCode " + idHashCode + ", " + refString;
            Log.getLogWriter().info(aStr);
            DeltaPropagationBB.getBB().getSharedMap().replace("Error", null, aStr);
            throw new TestException(aStr);
        }
    }

    protected void _fromDelta(DataInput in) throws IOException {
        byte[] theBytes;
        int length;
        Log.getLogWriter().info("In DeltaObject.fromDelta for " + this + "\nwith dataInput " + in);
        DeltaObserver.addFromDeltaKey(this.extra);
        long toDeltaIdNumber = in.readLong();
        Log.getLogWriter().info("Read toDeltaIdNumber " + toDeltaIdNumber);
        Object prevKeyForThisIdNumber = DeltaObserver.addToDeltaIdNumber(toDeltaIdNumber, this.extra);
        if (prevKeyForThisIdNumber != null) {
            throw new TestException("In DeltaObject.fromDelta, fromDelta is being called on " + this.toStringFull() + " with fromDelta stream containing toDeltaIdNumber " + toDeltaIdNumber + ", but this id number was previously processed in vm id " + RemoteTestModule.getMyVmid() + " with key " + prevKeyForThisIdNumber);
        }
        boolean change = in.readBoolean();
        if (change) {
            this.aPrimitiveLong = in.readLong();
            Log.getLogWriter().info("Read and set field aPrimitiveLong to " + this.aPrimitiveLong);
        }
        if (change = in.readBoolean()) {
            this.aPrimitiveInt = in.readInt();
            Log.getLogWriter().info("Read and set changed field aPrimitiveInt to " + this.aPrimitiveInt);
        }
        if (change = in.readBoolean()) {
            this.aPrimitiveShort = in.readShort();
            Log.getLogWriter().info("Read and set changed field aPrimitiveShort to " + this.aPrimitiveShort);
        }
        if (change = in.readBoolean()) {
            this.aPrimitiveFloat = in.readFloat();
            Log.getLogWriter().info("Read and set changed field aPrimitiveFloat to " + this.aPrimitiveFloat);
        }
        if (change = in.readBoolean()) {
            this.aPrimitiveDouble = in.readDouble();
            Log.getLogWriter().info("Read and set changed field aPrimitiveDouble to " + this.aPrimitiveDouble);
        }
        if (change = in.readBoolean()) {
            this.aPrimitiveByte = (byte)in.readUnsignedByte();
            Log.getLogWriter().info("Read and set changed field aPrimitiveByte to " + this.aPrimitiveByte);
        }
        if (change = in.readBoolean()) {
            this.aPrimitiveChar = in.readChar();
            Log.getLogWriter().info("Read and set changed field aPrimitiveChar to " + this.aPrimitiveChar);
        }
        if (change = in.readBoolean()) {
            this.aPrimitiveBoolean = in.readBoolean();
            Log.getLogWriter().info("Read and set changed field aPrimitiveBoolean to " + this.aPrimitiveBoolean);
        }
        if (change = in.readBoolean()) {
            length = in.readInt();
            Log.getLogWriter().info("Constructing byte[] of length " + length);
            this.aByteArray = new byte[length];
            in.readFully(this.aByteArray);
            Log.getLogWriter().info("Read and set changed field aByteArray of length to " + this.aByteArray.length);
        }
        if (change = in.readBoolean()) {
            length = in.readInt();
            Log.getLogWriter().info("Constructing String of length " + length);
            theBytes = new byte[length];
            in.readFully(theBytes);
            this.aString = new String(theBytes);
            Log.getLogWriter().info("Read and set changed field aString to " + this.aString);
        }
        int endSignalLength = in.readInt();
        theBytes = new byte[endSignalLength];
        in.readFully(theBytes);
        String endSignal = new String(theBytes);
        Log.getLogWriter().info("Read end signal: " + endSignal);
        if (endSignal == null || !endSignal.equals("delta END signal")) {
            String aStr = "In DeltaObject.fromDelta, expected to find endSignal: delta END signal, but found " + endSignal;
            Log.getLogWriter().info(aStr);
            DeltaPropagationBB.getBB().getSharedMap().put("Error", aStr);
            throw new TestException(aStr);
        }
        Log.getLogWriter().info("Done reading in DeltaObject.fromDelta for " + this.toStringFull());
    }

    public boolean hasDelta() {
        boolean hasDelta = this.aPrimitiveLongChanged || this.aPrimitiveIntChanged || this.aPrimitiveShortChanged || this.aPrimitiveFloatChanged || this.aPrimitiveDoubleChanged || this.aPrimitiveByteChanged || this.aPrimitiveCharChanged || this.aPrimitiveBooleanChanged || this.aByteArrayChanged || this.aStringChanged;
        Log.getLogWriter().info("In DeltaObject.hasDelta, returning " + hasDelta + " for " + this);
        DeltaObserver.addHasDeltaKey(this.extra);
        return hasDelta;
    }

    public void reset() {
        this.aPrimitiveLongChanged = false;
        this.aPrimitiveIntChanged = false;
        this.aPrimitiveShortChanged = false;
        this.aPrimitiveFloatChanged = false;
        this.aPrimitiveDoubleChanged = false;
        this.aPrimitiveByteChanged = false;
        this.aPrimitiveCharChanged = false;
        this.aPrimitiveBooleanChanged = false;
        this.aByteArrayChanged = false;
        this.aStringChanged = false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DeltaObject clonedObj = (DeltaObject)super.clone();
        Log.getLogWriter().info("In DeltaObject clone, cloning " + System.identityHashCode(this) + ":" + this.toStringFull() + ", clone is " + System.identityHashCode(clonedObj) + ":" + clonedObj.toStringFull());
        return clonedObj;
    }

    public DeltaObject copy() {
        try {
            DeltaObject copy = (DeltaObject)super.clone();
            copy.id = this.id;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    @Override
    public void modify(int changeValueGeneration, int delta, boolean log) {
        if (log) {
            Log.getLogWriter().info("Modifying " + this.toStringFull() + " with " + this.constantToString(changeValueGeneration) + " delta " + delta);
        }
        RandomValues rv = new RandomValues();
        if (changeValueGeneration == 4) {
            this.aPrimitiveLong += (long)delta;
            this.aPrimitiveLongChanged = true;
            this.aPrimitiveInt += delta;
            this.aPrimitiveIntChanged = true;
            this.aPrimitiveShort = (short)(this.aPrimitiveShort + delta);
            this.aPrimitiveShortChanged = true;
            this.aPrimitiveFloat += (float)delta;
            this.aPrimitiveFloatChanged = true;
            this.aPrimitiveDouble += (double)delta;
            this.aPrimitiveDoubleChanged = true;
            this.aPrimitiveByte = (byte)(this.aPrimitiveByte + delta);
            this.aPrimitiveByteChanged = true;
            this.aPrimitiveChar = (char)((byte)this.aPrimitiveChar + delta);
            this.aPrimitiveCharChanged = true;
            this.aPrimitiveBoolean = !this.aPrimitiveBoolean;
            this.aPrimitiveBooleanChanged = true;
            try {
                this.aString = "" + (Long.valueOf(this.aString) + (long)delta);
            }
            catch (NumberFormatException e) {
                this.aString = rv.getRandom_String();
            }
            this.aStringChanged = true;
        } else if (changeValueGeneration == 5) {
            this.aPrimitiveLong = -this.aPrimitiveLong;
            this.aPrimitiveLongChanged = true;
            this.aPrimitiveInt = -this.aPrimitiveInt;
            this.aPrimitiveIntChanged = true;
            this.aPrimitiveShort = -this.aPrimitiveShort;
            this.aPrimitiveShortChanged = true;
            this.aPrimitiveFloat = -this.aPrimitiveFloat;
            this.aPrimitiveFloatChanged = true;
            this.aPrimitiveDouble = -this.aPrimitiveDouble;
            this.aPrimitiveDoubleChanged = true;
            this.aPrimitiveByte = -this.aPrimitiveByte;
            this.aPrimitiveByteChanged = true;
            this.aPrimitiveChar = (char)(-((byte)this.aPrimitiveChar));
            this.aPrimitiveCharChanged = true;
            this.aPrimitiveBoolean = !this.aPrimitiveBoolean;
            this.aPrimitiveBooleanChanged = true;
            try {
                this.aString = new String("" + -Long.valueOf(this.aString).longValue());
            }
            catch (NumberFormatException e) {
                this.aString = rv.getRandom_String();
            }
            this.aStringChanged = true;
        } else {
            if (changeValueGeneration == 5) {
                throw new TestException("nulling non-prim fields unsupported for delta test");
            }
            throw new TestException("unknown changeValueGeneration " + changeValueGeneration);
        }
        if (log) {
            Log.getLogWriter().info("Done modifying " + this.toStringFull() + " with " + this.constantToString(changeValueGeneration) + " delta is " + delta);
        }
    }
}

