/*
 * Decompiled with CFR 0.152.
 */
package delta;

import delta.DeltaObject;
import hydra.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeltaObserver {
    protected static List toDeltaKeys = new ArrayList();
    protected static List fromDeltaKeys = new ArrayList();
    protected static List hasDeltaKeys = new ArrayList();
    protected static Map toDeltaIdNumbers = new HashMap();
    protected static Map currentReferences = new HashMap();

    public static synchronized void addToDeltaKey(Object key) {
        toDeltaKeys.add(key);
        Log.getLogWriter().info("Saved " + key + " because its value had toDelta called on it");
    }

    public static synchronized void addFromDeltaKey(Object key) {
        fromDeltaKeys.add(key);
        Log.getLogWriter().info("Saved " + key + " because its value had fromDelta called on it");
    }

    public static synchronized void addHasDeltaKey(Object key) {
        hasDeltaKeys.add(key);
        Log.getLogWriter().info("Saved " + key + " because its value had hasDelta called on it");
    }

    public static synchronized void addReference(DeltaObject anObj) {
        Object[] anArr = new Object[]{new Integer(System.identityHashCode(anObj)), anObj.toStringFull(), anObj.id};
        currentReferences.put(anObj.extra, anArr);
        Log.getLogWriter().info("Saved object reference for key " + anObj.extra + ", value " + anObj.toStringFull() + ", id " + anObj.id);
    }

    public static synchronized void nullReference(Object key) {
        currentReferences.put(key, null);
    }

    public static synchronized Object addToDeltaIdNumber(long idNumber, Object key) {
        int sizeThreshold = 50000;
        Long idNum = new Long(idNumber);
        Object previousKey = toDeltaIdNumbers.get(idNum);
        if (toDeltaIdNumbers.size() > 50000) {
            toDeltaIdNumbers = new HashMap();
        }
        toDeltaIdNumbers.put(idNum, key);
        Log.getLogWriter().info("Saved toDelta id number " + idNumber + "; previous key is " + previousKey + " number of saved id numbers: " + toDeltaIdNumbers.size());
        return previousKey;
    }

    public static List getFromDeltaKeys() {
        return fromDeltaKeys;
    }

    public static List getToDeltaKeys() {
        return toDeltaKeys;
    }

    public static List getHasDeltaKeys() {
        return hasDeltaKeys;
    }

    public static synchronized Map getReferences() {
        return new HashMap(currentReferences);
    }

    public static synchronized void clear() {
        Log.getLogWriter().info("Clearing DeltaObserver saved data");
        toDeltaKeys = new ArrayList();
        fromDeltaKeys = new ArrayList();
        hasDeltaKeys = new ArrayList();
        currentReferences = new HashMap();
    }
}

