/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientUpdater;
import delta.DeltaDurableClientValidationListener;
import delta.DeltaPropagationBB;
import delta.DeltaPropagationPrms;
import delta.Validator;
import hct.HctPrms;
import hct.ha.HAClientQueuePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Map;
import java.util.Set;
import util.TestException;
import util.TestHelper;

public class DeltaPropagation {
    protected static PoolImpl mypool;
    protected static final String REGION_NAME;
    public static String VmDurableId;
    public static volatile boolean lastKeyReceived;

    public static void initCacheServer() {
        if (TestConfig.tab().booleanAt(HAClientQueuePrms.delayDispatcherStart, false)) {
            CacheClientProxy.isSlowStartForTesting = true;
            long delayMilis = TestConfig.tab().longAt(HAClientQueuePrms.delayDispatcherStartMilis, Long.valueOf("100000"));
            System.setProperty("slowStartTimeForTesting", String.valueOf(delayMilis));
            Log.getLogWriter().info("Configured the test with delayed start for message dispatcher with delay time " + delayMilis + " milis.");
        }
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        int numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
        for (int i = 0; i < numOfRegion; ++i) {
            RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
        }
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCacheClientOld() {
        Class<DeltaPropagation> clazz = DeltaPropagation.class;
        synchronized (DeltaPropagation.class) {
            if (CacheHelper.getCache() == null) {
                CacheHelper.createCache(ConfigPrms.getCacheConfig());
                int numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    Region region = RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
                    mypool = ClientHelper.getPool(region);
                    try {
                        region.registerInterestRegex(".*_n_d_o");
                        region.registerInterest((Object)"last_key");
                        continue;
                    }
                    catch (CacheWriterException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void waitForLastKeyReceivedAtClient() {
        long maxWaitTime = 200000L;
        long start = System.currentTimeMillis();
        while (!lastKeyReceived) {
            if (System.currentTimeMillis() - start > maxWaitTime) {
                throw new TestException("last_key was not received in " + maxWaitTime + " milliseconds, could not proceed for further validation");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                Log.getLogWriter().info("waitForLastKeyReceivedAtClient : interrupted while waiting for validation");
            }
        }
        Validator.checkBlackBoardForException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyOverflowToDisk() {
        Class<DeltaPropagation> clazz = DeltaPropagation.class;
        synchronized (DeltaPropagation.class) {
            int numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
            Cache theCache = CacheHelper.getCache();
            for (int i = 0; i < numOfRegion; ++i) {
                Region aRegion = theCache.getRegion(REGION_NAME + i);
                PartitionedRegion pr = (PartitionedRegion)aRegion;
                DeltaPropagation.verifyOverflowToDisk(pr);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void verifyOverflowToDisk(PartitionedRegion aRegion) {
        if (aRegion.getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("This is an accessor and hence eviction need not be verified");
            return;
        }
        long numOverflowToDisk = aRegion.getDiskRegionStats().getNumOverflowOnDisk();
        long entriesInVm = aRegion.getDiskRegionStats().getNumEntriesInVM();
        long totalEntriesInBuckets = 0L;
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        Log.getLogWriter().info("Number of buckets= " + bucketList.size());
        for (Map.Entry entry : bucketList) {
            BucketRegion localBucket = (BucketRegion)entry.getValue();
            if (localBucket == null) continue;
            totalEntriesInBuckets += (long)localBucket.entryCount();
        }
        if (bucketList.size() > 0) {
            if (numOverflowToDisk == 0L) {
                throw new TestException("For the region " + aRegion.getName() + " no eviction happened ");
            }
            Log.getLogWriter().info("For the region " + aRegion.getName() + " entries overflown to disk is " + numOverflowToDisk);
        }
        if (totalEntriesInBuckets != numOverflowToDisk + entriesInVm) {
            throw new TestException("Total Entries in bucket (actual value " + totalEntriesInBuckets + " ) is not the same as the sum of entries in disk and entries in vm ( " + numOverflowToDisk + " and " + entriesInVm + ")");
        }
        if (entriesInVm == 0L) {
            throw new TestException(" After eviction(overflow to disk) the entries in vm is zero but entries in disk is " + numOverflowToDisk);
        }
        Log.getLogWriter().info("Total Entries in bucket (actual value " + totalEntriesInBuckets + " ) is the same as the sum of entries in disk and entries in vm ( " + numOverflowToDisk + " and " + entriesInVm + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCacheClient() {
        Class<DeltaPropagation> clazz = DeltaPropagation.class;
        synchronized (DeltaPropagation.class) {
            if (CacheHelper.getCache() == null) {
                CacheHelper.createCache(ConfigPrms.getCacheConfig());
                int numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    Region region = RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
                    mypool = ClientHelper.getPool(region);
                    CacheClientUpdater.isUsedByTest = true;
                    try {
                        region.registerInterest((Object)"ALL_KEYS");
                        continue;
                    }
                    catch (CacheWriterException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDurableCacheClient() {
        Class<DeltaPropagation> clazz = DeltaPropagation.class;
        synchronized (DeltaPropagation.class) {
            if (CacheHelper.getCache() == null) {
                Cache cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
                int numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    Region region = RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
                    mypool = ClientHelper.getPool(region);
                    VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
                    Log.getLogWriter().info("VM Durable Client Id is " + VmDurableId);
                    boolean isClientKilled = new Boolean((String)DeltaPropagationBB.getBB().getSharedMap().get(VmDurableId));
                    if (!isClientKilled) {
                        try {
                            region.registerInterest((Object)"ALL_KEYS", true);
                            continue;
                        }
                        catch (CacheWriterException e) {
                            throw new TestException(TestHelper.getStackTrace(e));
                        }
                    }
                    DeltaDurableClientValidationListener.durableKeyMap.putAll((Map)DeltaPropagationBB.getBB().getSharedMap().getMap().get(VmDurableId + "keyValueMap"));
                }
                cache.readyForEvents();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        REGION_NAME = TestConfig.tab().stringAt(HctPrms.regionName);
        VmDurableId = "";
        lastKeyReceived = false;
    }
}

