/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.admin.AlertListener;
import delta.DeltaPropagationBB;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import util.TestException;

public class DeltaTestAlertListener
implements AlertListener {
    public static final String warningKey = "warning";
    public static final String severeKey = "severe";

    public void alert(Alert alert) {
        Log.getLogWriter().info(this.getAlertString(alert));
        this.saveAlert(alert);
    }

    protected String getAlertString(Alert alert) {
        int myPID = ProcessMgr.getProcessId();
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + " in client with vmID " + RemoteTestModule.getMyVmid() + ", pid " + myPID + "\n");
        aStr.append("   alert.getConnectionName(): " + alert.getConnectionName() + "\n");
        aStr.append("   alert.getDate(): " + alert.getDate() + "\n");
        aStr.append("   alert.getLevel(): " + alert.getLevel() + "\n");
        aStr.append("   alert.getMessage(): " + alert.getMessage() + "\n");
        aStr.append("   alert.getSourceId(): " + alert.getSourceId() + "\n");
        aStr.append("   alert.getSystemMember(): " + alert.getSystemMember());
        return aStr.toString();
    }

    public static void clearAlerts() {
        Log.getLogWriter().info("Clearing alerts in blackboard...");
        DeltaPropagationBB.getBB().getSharedMap().remove(severeKey);
        DeltaPropagationBB.getBB().getSharedMap().remove(warningKey);
    }

    private void saveAlert(Alert alert) {
        if (alert.getLevel().equals((Object)AlertLevel.SEVERE)) {
            DeltaPropagationBB.getBB().getSharedMap().put(severeKey, alert.getMessage());
        } else if (alert.getLevel().equals((Object)AlertLevel.WARNING)) {
            DeltaPropagationBB.getBB().getSharedMap().put(warningKey, alert.getMessage());
        }
    }

    public static void waitForWarning() {
        long millisToWait = 180000L;
        long startTime = System.currentTimeMillis();
        while (true) {
            String warning;
            if ((warning = (String)DeltaPropagationBB.getBB().getSharedMap().get(warningKey)) != null && warning.indexOf("The following exception occurred while attempting to put entry") >= 0 && (warning.indexOf("Causing an error in hasDelta") >= 0 || warning.indexOf("Causing an error in toDelta") >= 0 || warning.indexOf("Causing an error in fromDelta") >= 0 || warning.indexOf("ArrayIndexOutOfBoundsException") >= 0 || warning.indexOf("IOException") >= 0 || warning.indexOf("EOFException") >= 0)) {
                Log.getLogWriter().info("Found expected warning: " + warning);
                return;
            }
            if (System.currentTimeMillis() - startTime > millisToWait) {
                throw new TestException("Waited " + millisToWait + "ms for a warning indicating fromDelta " + "failed when invoked in client in server-to-client delta distribution");
            }
            Log.getLogWriter().info("Waiting for warning...");
            MasterController.sleepForMs(2000);
        }
    }
}

