/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import delta.DeltaPropagationPrms;
import hydra.TestConfig;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DeltaTestObj
extends DeltaTestImpl {
    private transient long toDeltaCounter;
    private transient long fromDeltaCounter;
    public static final boolean enableFailure = TestConfig.tab().booleanAt(DeltaPropagationPrms.enableFailure, false);

    public DeltaTestObj(int intVal, String str) {
        super(intVal, str);
    }

    public DeltaTestObj(int intVal, String str, long toDeltaCounter) {
        super(intVal, str);
        this.toDeltaCounter = toDeltaCounter;
    }

    public DeltaTestObj(DeltaTestObj obj) {
        super(obj.getIntVar(), obj.getStr(), obj.getDoubleVar(), obj.getByteArr(), obj.getTestObj());
        this.toDeltaCounter = obj.getToDeltaCounter();
        this.fromDeltaCounter = obj.getFromDeltaCounter();
    }

    public DeltaTestObj() {
    }

    public long getFromDeltaCounter() {
        return this.fromDeltaCounter;
    }

    public long getToDeltaCounter() {
        return this.toDeltaCounter;
    }

    public void toDelta(DataOutput out) throws IOException {
        ++this.toDeltaCounter;
        super.toDelta(out);
        if (GemFireCacheImpl.getInstance().getLogger().fineEnabled()) {
            GemFireCacheImpl.getInstance().getLogger().fine("toDeltaCounter: " + this.toDeltaCounter);
        }
    }

    public void fromDelta(DataInput in) throws IOException {
        ++this.fromDeltaCounter;
        super.fromDelta(in);
        if (GemFireCacheImpl.getInstance().getLogger().fineEnabled()) {
            GemFireCacheImpl.getInstance().getLogger().fine("fromDeltaCounter: " + this.fromDeltaCounter);
        }
    }

    public void setFromDeltaCounter(int counter) {
        this.fromDeltaCounter = counter;
    }

    public void setToDeltaCounter(int counter) {
        this.toDeltaCounter = counter;
    }

    protected void checkInvalidInt2(int intVal) {
        if (enableFailure && intVal % 30 == 27) {
            throw new InvalidDeltaException("Delta could not be applied. " + (Object)((Object)this));
        }
    }

    public String toString() {
        StringBuffer bytes = new StringBuffer("");
        byte[] byteArr = super.getByteArr();
        if (byteArr != null) {
            for (int i = 0; i < byteArr.length; ++i) {
                bytes.append(byteArr[i]);
            }
        }
        return "DeltaTestObj[int=" + super.getIntVar() + ",double=" + super.getDoubleVar() + ",str=" + super.getStr() + ",bytes=(" + bytes.toString() + "),testObj=" + (super.getTestObj() != null ? Integer.valueOf(super.getTestObj().hashCode()) : "") + ",toDeltaCounter=" + this.toDeltaCounter + ",fromDeltaCounter=" + this.fromDeltaCounter + "]";
    }
}

